/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.hudi.org.apache.avro.AvroMissingFieldException;
import org.apache.hudi.org.apache.avro.AvroRuntimeException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.data.RecordBuilder;
import org.apache.hudi.org.apache.avro.io.DatumReader;
import org.apache.hudi.org.apache.avro.io.DatumWriter;
import org.apache.hudi.org.apache.avro.io.Encoder;
import org.apache.hudi.org.apache.avro.io.ResolvingDecoder;
import org.apache.hudi.org.apache.avro.message.BinaryMessageDecoder;
import org.apache.hudi.org.apache.avro.message.BinaryMessageEncoder;
import org.apache.hudi.org.apache.avro.message.SchemaStore;
import org.apache.hudi.org.apache.avro.specific.AvroGenerated;
import org.apache.hudi.org.apache.avro.specific.SpecificData;
import org.apache.hudi.org.apache.avro.specific.SpecificRecord;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class FloatWrapper
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -7352168536779030662L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"FloatWrapper\",\"namespace\":\"org.apache.hudi.avro.model\",\"doc\":\"A record wrapping float type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"float\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<FloatWrapper> ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<FloatWrapper> DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
    private float value;
    private static final DatumWriter<FloatWrapper> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<FloatWrapper> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<FloatWrapper> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<FloatWrapper> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<FloatWrapper> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder<FloatWrapper>(MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static FloatWrapper fromByteBuffer(ByteBuffer b) throws IOException {
        return (FloatWrapper)DECODER.decode(b);
    }

    public FloatWrapper() {
    }

    public FloatWrapper(Float value) {
        this.value = value.floatValue();
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return Float.valueOf(this.value);
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.value = ((Float)value$).floatValue();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(FloatWrapper other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    @Override
    protected boolean hasCustomCoders() {
        return true;
    }

    @Override
    public void customEncode(Encoder out) throws IOException {
        out.writeFloat(this.value);
    }

    @Override
    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.value = in.readFloat();
        } else {
            block3: for (int i = 0; i < 1; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.value = in.readFloat();
                        continue block3;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<FloatWrapper>
    implements RecordBuilder<FloatWrapper> {
        private float value;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], Float.valueOf(other.value))) {
                this.value = this.data().deepCopy(this.fields()[0].schema(), Float.valueOf(other.value)).floatValue();
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
        }

        private Builder(FloatWrapper other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue(this.fields()[0], Float.valueOf(other.value))) {
                this.value = this.data().deepCopy(this.fields()[0].schema(), Float.valueOf(other.value)).floatValue();
                this.fieldSetFlags()[0] = true;
            }
        }

        public float getValue() {
            return this.value;
        }

        public Builder setValue(float value) {
            this.validate(this.fields()[0], Float.valueOf(value));
            this.value = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasValue() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearValue() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        @Override
        public FloatWrapper build() {
            try {
                FloatWrapper record = new FloatWrapper();
                record.value = this.fieldSetFlags()[0] ? this.value : ((Float)this.defaultValue(this.fields()[0])).floatValue();
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

