/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieCommitMetadata
implements Serializable {
    public static final String SCHEMA_KEY = "schema";
    private static final Logger LOG = LoggerFactory.getLogger(HoodieCommitMetadata.class);
    protected Map<String, List<HoodieWriteStat>> partitionToWriteStats;
    protected Boolean compacted;
    protected Map<String, String> extraMetadata;
    protected WriteOperationType operationType = WriteOperationType.UNKNOWN;

    public HoodieCommitMetadata() {
        this(false);
    }

    public HoodieCommitMetadata(boolean compacted) {
        this.extraMetadata = new HashMap<String, String>();
        this.partitionToWriteStats = new HashMap<String, List<HoodieWriteStat>>();
        this.compacted = compacted;
    }

    public void addWriteStat(String partitionPath, HoodieWriteStat stat) {
        if (!this.partitionToWriteStats.containsKey(partitionPath)) {
            this.partitionToWriteStats.put(partitionPath, new ArrayList());
        }
        this.partitionToWriteStats.get(partitionPath).add(stat);
    }

    public void addMetadata(String metaKey, String value) {
        this.extraMetadata.put(metaKey, value);
    }

    public List<HoodieWriteStat> getWriteStats(String partitionPath) {
        return this.partitionToWriteStats.get(partitionPath);
    }

    public Map<String, String> getExtraMetadata() {
        return this.extraMetadata;
    }

    public Map<String, List<HoodieWriteStat>> getPartitionToWriteStats() {
        return this.partitionToWriteStats;
    }

    public List<HoodieWriteStat> getWriteStats() {
        return this.partitionToWriteStats.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String getMetadata(String metaKey) {
        return this.extraMetadata.get(metaKey);
    }

    public Boolean getCompacted() {
        return this.compacted;
    }

    public void setCompacted(Boolean compacted) {
        this.compacted = compacted;
    }

    public HashMap<String, String> getFileIdAndRelativePaths() {
        HashMap<String, String> filePaths = new HashMap<String, String>();
        for (List<HoodieWriteStat> stats : this.getPartitionToWriteStats().values()) {
            for (HoodieWriteStat stat : stats) {
                filePaths.put(stat.getFileId(), stat.getPath());
            }
        }
        return filePaths;
    }

    public void setOperationType(WriteOperationType type) {
        this.operationType = type;
    }

    public WriteOperationType getOperationType() {
        return this.operationType;
    }

    public HashMap<String, String> getFileIdAndFullPaths(StoragePath basePath) {
        HashMap<String, String> fullPaths = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getFileIdAndRelativePaths().entrySet()) {
            String fullPath = entry.getValue() != null ? FSUtils.constructAbsolutePath(basePath, entry.getValue()).toString() : null;
            fullPaths.put(entry.getKey(), fullPath);
        }
        return fullPaths;
    }

    public List<String> getFullPathsByPartitionPath(String basePath, String partitionPath) {
        HashSet<String> fullPaths = new HashSet<String>();
        if (this.getPartitionToWriteStats().get(partitionPath) != null) {
            for (HoodieWriteStat stat : this.getPartitionToWriteStats().get(partitionPath)) {
                if (stat.getFileId() == null) continue;
                String fullPath = FSUtils.constructAbsolutePath(basePath, stat.getPath()).toString();
                fullPaths.add(fullPath);
            }
        }
        return new ArrayList<String>(fullPaths);
    }

    public Map<HoodieFileGroupId, String> getFileGroupIdAndFullPaths(String basePath) {
        HashMap<HoodieFileGroupId, String> fileGroupIdToFullPaths = new HashMap<HoodieFileGroupId, String>();
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.getPartitionToWriteStats().entrySet()) {
            for (HoodieWriteStat stat : entry.getValue()) {
                HoodieFileGroupId fileGroupId = new HoodieFileGroupId(stat.getPartitionPath(), stat.getFileId());
                StoragePath fullPath = new StoragePath(basePath, stat.getPath());
                fileGroupIdToFullPaths.put(fileGroupId, fullPath.toString());
            }
        }
        return fileGroupIdToFullPaths;
    }

    public Map<String, StoragePathInfo> getFullPathToInfo(HoodieStorage storage, String basePath) {
        HashMap<String, StoragePathInfo> fullPathToInfoMap = new HashMap<String, StoragePathInfo>();
        for (List<HoodieWriteStat> stats : this.getPartitionToWriteStats().values()) {
            for (HoodieWriteStat stat : stats) {
                String relativeFilePath = stat.getPath();
                StoragePath fullPath = relativeFilePath != null ? FSUtils.constructAbsolutePath(basePath, relativeFilePath) : null;
                if (fullPath == null) continue;
                long blockSize = storage.getDefaultBlockSize(fullPath);
                StoragePathInfo pathInfo = new StoragePathInfo(fullPath, stat.getFileSizeInBytes(), false, 0, blockSize, 0L);
                fullPathToInfoMap.put(fullPath.getName(), pathInfo);
            }
        }
        return fullPathToInfoMap;
    }

    public Map<String, StoragePathInfo> getFileIdToInfo(String basePath) {
        HashMap<String, StoragePathInfo> fileIdToInfoMap = new HashMap<String, StoragePathInfo>();
        for (List<HoodieWriteStat> stats : this.getPartitionToWriteStats().values()) {
            for (HoodieWriteStat stat : stats) {
                String relativeFilePath = stat.getPath();
                StoragePath fullPath = relativeFilePath != null ? FSUtils.constructAbsolutePath(basePath, relativeFilePath) : null;
                if (fullPath == null) continue;
                StoragePathInfo pathInfo = new StoragePathInfo(fullPath, stat.getFileSizeInBytes(), false, 0, 0L, 0L);
                fileIdToInfoMap.put(stat.getFileId(), pathInfo);
            }
        }
        return fileIdToInfoMap;
    }

    public String toJsonString() throws IOException {
        if (this.partitionToWriteStats.containsKey(null)) {
            LOG.info("partition path is null for " + this.partitionToWriteStats.get(null));
            this.partitionToWriteStats.remove(null);
        }
        return JsonUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this);
    }

    public static <T> T fromJsonString(String jsonStr, Class<T> clazz) throws Exception {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return clazz.newInstance();
        }
        return JsonUtils.getObjectMapper().readValue(jsonStr, clazz);
    }

    public static Option<Pair<String, List<String>>> getFileSliceForFileGroupFromDeltaCommit(byte[] bytes, HoodieFileGroupId fileGroupId) {
        try {
            org.apache.hudi.avro.model.HoodieCommitMetadata commitMetadata = TimelineMetadataUtils.deserializeCommitMetadata(bytes);
            Map<String, List<org.apache.hudi.avro.model.HoodieWriteStat>> partitionToWriteStatsMap = commitMetadata.getPartitionToWriteStats();
            for (Map.Entry<String, List<org.apache.hudi.avro.model.HoodieWriteStat>> partitionToWriteStat : partitionToWriteStatsMap.entrySet()) {
                for (org.apache.hudi.avro.model.HoodieWriteStat writeStat : partitionToWriteStat.getValue()) {
                    HoodieFileGroupId fgId = new HoodieFileGroupId(partitionToWriteStat.getKey(), writeStat.getFileId());
                    if (!fgId.equals(fileGroupId)) continue;
                    return Option.of(Pair.of(writeStat.getBaseFile() == null ? "" : writeStat.getBaseFile(), writeStat.getLogFiles()));
                }
            }
            return Option.empty();
        }
        catch (Exception e) {
            throw new HoodieException("Fail to parse the base file and log files from DeltaCommit", e);
        }
    }

    public long fetchTotalPartitionsWritten() {
        return this.partitionToWriteStats.size();
    }

    public long fetchTotalFilesInsert() {
        long totalFilesInsert = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                if (stat.getPrevCommit() == null || !stat.getPrevCommit().equalsIgnoreCase("null")) continue;
                ++totalFilesInsert;
            }
        }
        return totalFilesInsert;
    }

    public long fetchTotalFilesUpdated() {
        long totalFilesUpdated = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                if (stat.getPrevCommit() == null || stat.getPrevCommit().equalsIgnoreCase("null")) continue;
                ++totalFilesUpdated;
            }
        }
        return totalFilesUpdated;
    }

    public long fetchTotalUpdateRecordsWritten() {
        long totalUpdateRecordsWritten = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalUpdateRecordsWritten += stat.getNumUpdateWrites();
            }
        }
        return totalUpdateRecordsWritten;
    }

    public long fetchTotalInsertRecordsWritten() {
        long totalInsertRecordsWritten = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                if (stat.getPrevCommit() == null) continue;
                totalInsertRecordsWritten += stat.getNumInserts();
            }
        }
        return totalInsertRecordsWritten;
    }

    public long fetchTotalRecordsWritten() {
        long totalRecordsWritten = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalRecordsWritten += stat.getNumWrites();
            }
        }
        return totalRecordsWritten;
    }

    public long fetchTotalBytesWritten() {
        long totalBytesWritten = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalBytesWritten += stat.getTotalWriteBytes();
            }
        }
        return totalBytesWritten;
    }

    public long fetchTotalWriteErrors() {
        long totalWriteErrors = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalWriteErrors += stat.getTotalWriteErrors();
            }
        }
        return totalWriteErrors;
    }

    public long getTotalRecordsDeleted() {
        long totalDeletes = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalDeletes += stat.getNumDeletes();
            }
        }
        return totalDeletes;
    }

    public Long getTotalLogRecordsCompacted() {
        Long totalLogRecords = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalLogRecords = totalLogRecords + writeStat.getTotalLogRecords();
            }
        }
        return totalLogRecords;
    }

    public Long getTotalLogFilesCompacted() {
        Long totalLogFiles = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalLogFiles = totalLogFiles + writeStat.getTotalLogFilesCompacted();
            }
        }
        return totalLogFiles;
    }

    public Long getTotalCompactedRecordsUpdated() {
        Long totalUpdateRecords = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalUpdateRecords = totalUpdateRecords + writeStat.getTotalUpdatedRecordsCompacted();
            }
        }
        return totalUpdateRecords;
    }

    public Long getTotalCorruptLogBlocks() {
        Long totalCorruptedLogBlocks = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalCorruptedLogBlocks = totalCorruptedLogBlocks + writeStat.getTotalCorruptLogBlock();
            }
        }
        return totalCorruptedLogBlocks;
    }

    public Long getTotalRollbackLogBlocks() {
        Long totalRollbackLogBlocks = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalRollbackLogBlocks = totalRollbackLogBlocks + writeStat.getTotalRollbackBlocks();
            }
        }
        return totalRollbackLogBlocks;
    }

    public Long getTotalLogFilesSize() {
        Long totalLogFilesSize = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalLogFilesSize = totalLogFilesSize + writeStat.getTotalLogSizeCompacted();
            }
        }
        return totalLogFilesSize;
    }

    public Long getTotalScanTime() {
        Long totalScanTime = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                if (writeStat.getRuntimeStats() == null) continue;
                totalScanTime = totalScanTime + writeStat.getRuntimeStats().getTotalScanTime();
            }
        }
        return totalScanTime;
    }

    public Long getTotalCreateTime() {
        Long totalCreateTime = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                if (writeStat.getRuntimeStats() == null) continue;
                totalCreateTime = totalCreateTime + writeStat.getRuntimeStats().getTotalCreateTime();
            }
        }
        return totalCreateTime;
    }

    public Long getTotalUpsertTime() {
        Long totalUpsertTime = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                if (writeStat.getRuntimeStats() == null) continue;
                totalUpsertTime = totalUpsertTime + writeStat.getRuntimeStats().getTotalUpsertTime();
            }
        }
        return totalUpsertTime;
    }

    public Pair<Option<Long>, Option<Long>> getMinAndMaxEventTime() {
        long minEventTime = Long.MAX_VALUE;
        long maxEventTime = Long.MIN_VALUE;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                minEventTime = writeStat.getMinEventTime() != null ? Math.min(writeStat.getMinEventTime(), minEventTime) : minEventTime;
                maxEventTime = writeStat.getMaxEventTime() != null ? Math.max(writeStat.getMaxEventTime(), maxEventTime) : maxEventTime;
            }
        }
        return Pair.of(minEventTime == Long.MAX_VALUE ? Option.empty() : Option.of(minEventTime), maxEventTime == Long.MIN_VALUE ? Option.empty() : Option.of(maxEventTime));
    }

    public HashSet<String> getWritePartitionPaths() {
        return new HashSet<String>(this.partitionToWriteStats.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieCommitMetadata that = (HoodieCommitMetadata)o;
        if (!this.partitionToWriteStats.equals(that.partitionToWriteStats)) {
            return false;
        }
        return this.compacted.equals(that.compacted);
    }

    public int hashCode() {
        int result = this.partitionToWriteStats.hashCode();
        result = 31 * result + this.compacted.hashCode();
        return result;
    }

    public String toString() {
        return "HoodieCommitMetadata{partitionToWriteStats=" + this.partitionToWriteStats + ", compacted=" + this.compacted + ", extraMetadata=" + this.extraMetadata + ", operationType=" + (Object)((Object)this.operationType) + '}';
    }
}

