/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model.debezium;

import java.io.IOException;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDebeziumAvroPayload
extends OverwriteWithLatestAvroPayload {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDebeziumAvroPayload.class);

    public AbstractDebeziumAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public AbstractDebeziumAvroPayload(Option<GenericRecord> record) {
        super(record);
    }

    @Override
    public OverwriteWithLatestAvroPayload preCombine(OverwriteWithLatestAvroPayload oldValue) {
        if (oldValue.getRecordBytes().length == 0) {
            return this;
        }
        if (oldValue.getOrderingValue().compareTo(this.orderingVal) > 0) {
            return oldValue;
        }
        return this;
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        Option<IndexedRecord> insertValue = this.getInsertRecord(schema);
        return insertValue.isPresent() ? this.handleDeleteOperation(insertValue.get()) : Option.empty();
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
        Option insertValue;
        Option<Object> option = insertValue = this.recordBytes.length == 0 ? Option.empty() : Option.of(HoodieAvroUtils.bytesToAvro(this.recordBytes, schema));
        if (!insertValue.isPresent()) {
            return Option.empty();
        }
        if (this.shouldPickCurrentRecord(currentValue, (IndexedRecord)insertValue.get(), schema)) {
            return Option.of(currentValue);
        }
        return this.getInsertValue(schema);
    }

    protected abstract boolean shouldPickCurrentRecord(IndexedRecord var1, IndexedRecord var2, Schema var3) throws IOException;

    private Option<IndexedRecord> handleDeleteOperation(IndexedRecord insertRecord) {
        boolean delete = false;
        if (insertRecord instanceof GenericRecord) {
            GenericRecord record = (GenericRecord)insertRecord;
            delete = AbstractDebeziumAvroPayload.isDebeziumDeleteRecord(record);
        }
        return delete ? Option.empty() : Option.of(insertRecord);
    }

    private Option<IndexedRecord> getInsertRecord(Schema schema) throws IOException {
        return super.getInsertValue(schema);
    }

    @Override
    protected boolean isDeleteRecord(GenericRecord record) {
        return AbstractDebeziumAvroPayload.isDebeziumDeleteRecord(record) || super.isDeleteRecord(record);
    }

    private static boolean isDebeziumDeleteRecord(GenericRecord record) {
        Object value = HoodieAvroUtils.getFieldVal(record, "_change_operation_type");
        return value != null && value.toString().equalsIgnoreCase("d");
    }
}

