/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.HoodieLogFileReader;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.HoodieLogFormatReader;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.storage.HoodieStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieLogFormatReverseReader
implements HoodieLogFormat.Reader {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieLogFormatReader.class);
    private final List<HoodieLogFile> logFiles;
    private final List<HoodieLogFileReader> prevReadersInOpenState;
    private HoodieLogFileReader currentReader;
    private final HoodieStorage storage;
    private final Schema readerSchema;
    private InternalSchema internalSchema = InternalSchema.getEmptyInternalSchema();
    private final boolean reverseLogReader;
    private final String recordKeyField;
    private final boolean enableInlineReading;
    private int bufferSize;
    private int logFilePos = -1;

    HoodieLogFormatReverseReader(HoodieStorage storage, List<HoodieLogFile> logFiles, Schema readerSchema, boolean reverseLogReader, int bufferSize, boolean enableRecordLookups, String recordKeyField, InternalSchema internalSchema) throws IOException {
        this.logFiles = logFiles;
        this.storage = storage;
        this.readerSchema = readerSchema;
        this.reverseLogReader = reverseLogReader;
        this.bufferSize = bufferSize;
        this.prevReadersInOpenState = new ArrayList<HoodieLogFileReader>();
        this.recordKeyField = recordKeyField;
        this.enableInlineReading = enableRecordLookups;
        this.internalSchema = internalSchema == null ? InternalSchema.getEmptyInternalSchema() : internalSchema;
        this.logFilePos = logFiles.size() - 1;
        if (this.logFilePos >= 0) {
            HoodieLogFile nextLogFile = logFiles.get(this.logFilePos);
            --this.logFilePos;
            this.currentReader = new HoodieLogFileReader(storage, nextLogFile, readerSchema, bufferSize, false, enableRecordLookups, recordKeyField, internalSchema);
        }
    }

    @Override
    public void close() throws IOException {
        for (HoodieLogFileReader reader : this.prevReadersInOpenState) {
            reader.close();
        }
        this.prevReadersInOpenState.clear();
        if (this.currentReader != null) {
            this.currentReader.close();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentReader == null) {
            return false;
        }
        if (this.currentReader.hasNext()) {
            return true;
        }
        if (this.logFilePos >= 0) {
            try {
                HoodieLogFile nextLogFile = this.logFiles.get(this.logFilePos);
                --this.logFilePos;
                this.prevReadersInOpenState.add(this.currentReader);
                this.currentReader = new HoodieLogFileReader(this.storage, nextLogFile, this.readerSchema, this.bufferSize, false, this.enableInlineReading, this.recordKeyField, this.internalSchema);
            }
            catch (IOException io) {
                throw new HoodieIOException("unable to initialize read with log file ", io);
            }
            LOG.info("Moving to the next reader for logfile {}", (Object)this.currentReader.getLogFile());
            return this.hasNext();
        }
        return false;
    }

    @Override
    public HoodieLogBlock next() {
        return this.currentReader.next();
    }

    @Override
    public HoodieLogFile getLogFile() {
        return this.currentReader.getLogFile();
    }

    @Override
    public void remove() {
    }

    @Override
    public boolean hasPrev() {
        return this.currentReader.hasPrev();
    }

    @Override
    public HoodieLogBlock prev() throws IOException {
        return this.currentReader.prev();
    }
}

