/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.util.Option;

public class HoodieTableConfigUtils {
    public static Option<String> getPartitionFieldPropForKeyGenerator(HoodieConfig config) {
        return Option.ofNullable(config.getString(HoodieTableConfig.PARTITION_FIELDS));
    }

    public static Option<String> getPartitionFieldProp(HoodieConfig config) {
        if (HoodieTableConfigUtils.getTableVersion(config).greaterThan(HoodieTableVersion.SEVEN)) {
            return HoodieTableConfigUtils.getPartitionFields(config).map(fields -> String.join((CharSequence)",", fields));
        }
        return Option.ofNullable(config.getString(HoodieTableConfig.PARTITION_FIELDS));
    }

    public static Option<String[]> getPartitionFields(HoodieConfig config) {
        if (HoodieConfig.contains(HoodieTableConfig.PARTITION_FIELDS, config)) {
            return Option.of(Arrays.stream(config.getString(HoodieTableConfig.PARTITION_FIELDS).split(",")).filter(p -> !p.isEmpty()).map(p -> HoodieTableConfigUtils.getPartitionFieldWithoutKeyGenPartitionType(p, config)).collect(Collectors.toList()).toArray(new String[0]));
        }
        return Option.empty();
    }

    public static String getPartitionFieldWithoutKeyGenPartitionType(String partitionField, HoodieConfig config) {
        return HoodieTableConfigUtils.getTableVersion(config).greaterThan(HoodieTableVersion.SEVEN) ? partitionField.split(":")[0] : partitionField;
    }

    public static HoodieTableVersion getTableVersion(HoodieConfig config) {
        return HoodieConfig.contains(HoodieTableConfig.VERSION, config) ? HoodieTableVersion.fromVersionCode(config.getInt(HoodieTableConfig.VERSION)) : HoodieTableConfig.VERSION.defaultValue();
    }
}

