/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hudi.common.util.ComparableVersion;

public class StringUtils {
    public static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String EMPTY_STRING = "";
    public static final int INDEX_NOT_FOUND = -1;

    public static <T> String join(String ... elements) {
        return StringUtils.join(elements, EMPTY_STRING);
    }

    public static <T> String joinUsingDelim(String delim, String ... elements) {
        return StringUtils.join(elements, delim);
    }

    public static String join(String[] array, String separator) {
        if (array == null) {
            return null;
        }
        return String.join((CharSequence)separator, array);
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        if (elements == null) {
            return null;
        }
        return String.join(delimiter, elements);
    }

    public static String join(List<String> list, String separator) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return String.join((CharSequence)separator, list.toArray(new String[0]));
    }

    public static <K, V> String join(Map<K, V> map) {
        return map.entrySet().stream().map(e -> e.getKey() + "=" + e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }

    public static String toHexString(byte[] bytes) {
        return new String(StringUtils.encodeHex(bytes));
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int var4 = 0;
        for (int i = 0; i < l; ++i) {
            out[var4++] = HEX_CHAR[(0xF0 & data[i]) >>> 4];
            out[var4++] = HEX_CHAR[0xF & data[i]];
        }
        return out;
    }

    public static byte[] getUTF8Bytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static String fromUTF8Bytes(byte[] bytes) {
        return StringUtils.fromUTF8Bytes(bytes, 0, bytes.length);
    }

    public static String fromUTF8Bytes(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return null;
        }
        if (length == 0) {
            return EMPTY_STRING;
        }
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean nonEmpty(String str) {
        return !StringUtils.isNullOrEmpty(str);
    }

    public static String nullToEmpty(@Nullable String string) {
        return string == null ? EMPTY_STRING : string;
    }

    public static String objToString(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        return obj instanceof ByteBuffer ? StringUtils.toHexString(((ByteBuffer)obj).array()) : obj.toString();
    }

    @Nullable
    public static String emptyToNull(@Nullable String string) {
        return StringUtils.stringIsNullOrEmpty(string) ? null : string;
    }

    private static boolean stringIsNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static List<String> split(@Nullable String input, String delimiter) {
        if (StringUtils.isNullOrEmpty(input)) {
            return Collections.emptyList();
        }
        return Stream.of(input.split(delimiter)).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public static String getSuffixBy(String input, int ch) {
        int i = input.lastIndexOf(ch);
        if (i == -1) {
            return input;
        }
        return input.substring(i);
    }

    public static String removeSuffixBy(String input, int ch) {
        int i = input.lastIndexOf(ch);
        if (i == -1) {
            return input;
        }
        return input.substring(0, i);
    }

    public static String truncate(String str, int headLength, int tailLength) {
        if (StringUtils.isNullOrEmpty(str) || str.length() <= headLength + tailLength) {
            return str;
        }
        String head = str.substring(0, headLength);
        String tail = str.substring(str.length() - tailLength);
        return head + "..." + tail;
    }

    public static int compareVersions(String version1, String version2) {
        ComparableVersion v1 = new ComparableVersion(version1);
        ComparableVersion v2 = new ComparableVersion(version2);
        return v1.compareTo(v2);
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (StringUtils.isNullOrEmpty(text) || StringUtils.isNullOrEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public static String concatenateWithThreshold(String a, String b, int byteLengthThreshold) {
        byte[] bytesA = StringUtils.getUTF8Bytes(a);
        byte[] bytesB = StringUtils.getUTF8Bytes(b);
        if (bytesB.length > byteLengthThreshold) {
            throw new IllegalArgumentException(String.format("Length of the Second string to concatenate exceeds the threshold (%d > %d)", bytesB.length, byteLengthThreshold));
        }
        int totalBytes = bytesA.length + bytesB.length;
        if (totalBytes <= byteLengthThreshold) {
            return a + b;
        }
        int bestLength = StringUtils.getBestLength(a, byteLengthThreshold - bytesB.length);
        return a.substring(0, bestLength) + b;
    }

    public static <T> String toStringWithThreshold(List<T> objectList, int lengthThreshold) {
        if (objectList == null || objectList.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (T obj : objectList) {
            if (sb.length() >= lengthThreshold) {
                StringUtils.setLastThreeDots(sb);
                break;
            }
            String objString = (sb.length() > 0 ? "," : EMPTY_STRING) + obj;
            if (sb.length() + objString.length() > lengthThreshold) {
                int remaining = lengthThreshold - sb.length();
                sb.append(objString, 0, remaining);
                StringUtils.setLastThreeDots(sb);
                break;
            }
            sb.append(objString);
        }
        return sb.toString();
    }

    private static void setLastThreeDots(StringBuilder sb) {
        IntStream.range(1, 4).forEach(i -> {
            int loc = sb.length() - i;
            if (loc >= 0) {
                sb.setCharAt(loc, '.');
            }
        });
    }

    private static int getBestLength(String a, int threshold) {
        int low = 0;
        int high = Math.min(a.length(), threshold);
        int bestLength = 0;
        while (low <= high) {
            int mid = (low + high) / 2;
            byte[] subABytes = StringUtils.getUTF8Bytes(a.substring(0, mid));
            if (subABytes.length <= threshold) {
                bestLength = mid;
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return bestLength;
    }
}

