/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.hudi.common.util.ValidationUtils;

public class FilterIterator<R>
implements Iterator<R> {
    private final Iterator<R> source;
    private final Predicate<R> filter;
    private R current;

    public FilterIterator(Iterator<R> source, Predicate<R> filter) {
        this.source = source;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        while (this.current == null && this.source.hasNext()) {
            R next = this.source.next();
            if (!this.filter.test(next)) continue;
            this.current = next;
            break;
        }
        return this.current != null;
    }

    @Override
    public R next() {
        ValidationUtils.checkArgument(this.hasNext(), "No more elements to iterate");
        R next = this.current;
        this.current = null;
        return next;
    }
}

