/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.utils.shims;

import java.sql.Timestamp;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.hadoop.utils.shims.HiveShim;

public class Hive2Shim
implements HiveShim {
    private static final Hive2Shim INSTANCE = new Hive2Shim();

    private Hive2Shim() {
    }

    public static Hive2Shim getInstance() {
        return INSTANCE;
    }

    @Override
    public Writable getTimestampWriteable(long value, boolean timestampMillis) {
        Timestamp timestamp = new Timestamp(timestampMillis ? value : value / 1000L);
        return new TimestampWritable(timestamp);
    }

    @Override
    public Writable getDateWriteable(int value) {
        return new DateWritable(value);
    }

    @Override
    public int getDays(Object dateWritable) {
        return ((DateWritable)dateWritable).getDays();
    }

    @Override
    public long getMills(Object timestampWritable) {
        return ((TimestampWritable)timestampWritable).getTimestamp().getTime();
    }
}

