/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

public class HoodieFileReaderFactory {
    protected final HoodieStorage storage;

    public HoodieFileReaderFactory(HoodieStorage storage) {
        this.storage = storage;
    }

    public HoodieFileReader getFileReader(HoodieConfig hoodieConfig, StoragePath path) throws IOException {
        String extension = FSUtils.getFileExtension(path.toString());
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return this.getFileReader(hoodieConfig, path, HoodieFileFormat.PARQUET, Option.empty());
        }
        if (HoodieFileFormat.HFILE.getFileExtension().equals(extension)) {
            return this.getFileReader(hoodieConfig, path, HoodieFileFormat.HFILE, Option.empty());
        }
        if (HoodieFileFormat.ORC.getFileExtension().equals(extension)) {
            return this.getFileReader(hoodieConfig, path, HoodieFileFormat.ORC, Option.empty());
        }
        throw new UnsupportedOperationException(extension + " format not supported yet.");
    }

    public HoodieFileReader getFileReader(HoodieConfig hoodieConfig, StoragePath path, HoodieFileFormat format) throws IOException {
        return this.getFileReader(hoodieConfig, path, format, Option.empty());
    }

    public HoodieFileReader getFileReader(HoodieConfig hoodieConfig, StoragePath path, HoodieFileFormat format, Option<Schema> schemaOption) throws IOException {
        switch (format) {
            case PARQUET: {
                return this.newParquetFileReader(path);
            }
            case HFILE: {
                return this.newHFileFileReader(hoodieConfig, path, schemaOption);
            }
            case ORC: {
                return this.newOrcFileReader(path);
            }
        }
        throw new UnsupportedOperationException((Object)((Object)format) + " format not supported yet.");
    }

    public HoodieFileReader getContentReader(HoodieConfig hoodieConfig, StoragePath path, HoodieFileFormat format, HoodieStorage storage, byte[] content, Option<Schema> schemaOption) throws IOException {
        switch (format) {
            case HFILE: {
                return this.newHFileFileReader(hoodieConfig, path, storage, content, schemaOption);
            }
        }
        throw new UnsupportedOperationException((Object)((Object)format) + " format not supported yet.");
    }

    protected HoodieFileReader newParquetFileReader(StoragePath path) {
        throw new UnsupportedOperationException();
    }

    protected HoodieFileReader newHFileFileReader(HoodieConfig hoodieConfig, StoragePath path, Option<Schema> schemaOption) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected HoodieFileReader newHFileFileReader(HoodieConfig hoodieConfig, StoragePath path, HoodieStorage storage, byte[] content, Option<Schema> schemaOption) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected HoodieFileReader newOrcFileReader(StoragePath path) {
        throw new UnsupportedOperationException();
    }

    public HoodieFileReader newBootstrapFileReader(HoodieFileReader skeletonFileReader, HoodieFileReader dataFileReader, Option<String[]> partitionFields, Object[] partitionValues) {
        throw new UnsupportedOperationException();
    }

    protected static boolean isUseNativeHFileReaderEnabled(HoodieConfig hoodieConfig) {
        return hoodieConfig.getBooleanOrDefault(HoodieReaderConfig.USE_NATIVE_HFILE_READER);
    }
}

