/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.master.MetricsMasterProcSource;
import org.apache.hudi.org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.Interns;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsMasterProcSourceImpl
extends BaseSourceImpl
implements MetricsMasterProcSource {
    private final MetricsMasterWrapper masterWrapper;

    public MetricsMasterProcSourceImpl(MetricsMasterWrapper masterWrapper) {
        this("Procedure", "Metrics about HBase master procedure", "master", "Master,sub=Procedure", masterWrapper);
    }

    public MetricsMasterProcSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsMasterWrapper masterWrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.masterWrapper = masterWrapper;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder metricsRecordBuilder = metricsCollector.addRecord(this.metricsName);
        if (this.masterWrapper != null) {
            metricsRecordBuilder.addGauge(Interns.info("numMasterWALs", "Number of master WAL files"), this.masterWrapper.getNumWALFiles());
        }
        this.metricsRegistry.snapshot(metricsRecordBuilder, all);
        if (this.metricsAdapter != null) {
            this.metricsAdapter.snapshotAllMetrics(this.registry, metricsRecordBuilder);
        }
    }
}

