/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.utils.shims;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.utils.shims.HiveShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive3Shim
implements HiveShim {
    public static final Logger LOG = LoggerFactory.getLogger(Hive3Shim.class);
    public static final String HIVE_TIMESTAMP_TYPE_CLASS = "org.apache.hadoop.hive.common.type.Timestamp";
    public static final String TIMESTAMP_WRITEABLE_V2_CLASS = "org.apache.hadoop.hive.serde2.io.TimestampWritableV2";
    public static final String DATE_WRITEABLE_V2_CLASS = "org.apache.hadoop.hive.serde2.io.DateWritableV2";
    private static Class<?> TIMESTAMP_CLASS = null;
    private static Method SET_TIME_IN_MILLIS = null;
    private static Method TO_SQL_TIMESTAMP = null;
    private static Constructor<?> TIMESTAMP_WRITEABLE_V2_CONSTRUCTOR = null;
    private static Class<?> DATE_WRITEABLE_CLASS = null;
    private static Method GET_DAYS = null;
    private static Constructor<?> DATE_WRITEABLE_V2_CONSTRUCTOR = null;
    private static final Hive3Shim INSTANCE;

    private Hive3Shim() {
    }

    public static Hive3Shim getInstance() {
        return INSTANCE;
    }

    @Override
    public Writable getTimestampWriteable(long value, boolean timestampMillis) {
        try {
            Object timestamp = TIMESTAMP_CLASS.newInstance();
            SET_TIME_IN_MILLIS.invoke(timestamp, timestampMillis ? value : value / 1000L);
            return (Writable)TIMESTAMP_WRITEABLE_V2_CONSTRUCTOR.newInstance(timestamp);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new HoodieException("can not create writable v2 class!", (Throwable)e);
        }
    }

    @Override
    public Writable getDateWriteable(int value) {
        try {
            return (Writable)DATE_WRITEABLE_V2_CONSTRUCTOR.newInstance(value);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new HoodieException("can not create writable v2 class!", (Throwable)e);
        }
    }

    @Override
    public int getDays(Object dateWritable) {
        try {
            return (Integer)GET_DAYS.invoke(dateWritable, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new HoodieException("can not create writable v2 class!", (Throwable)e);
        }
    }

    @Override
    public long getMills(Object timestamp) {
        try {
            return ((Timestamp)TO_SQL_TIMESTAMP.invoke(timestamp, new Object[0])).getTime();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new HoodieException("can not create writable v2 class!", (Throwable)e);
        }
    }

    static {
        try {
            TIMESTAMP_CLASS = Class.forName(HIVE_TIMESTAMP_TYPE_CLASS);
            SET_TIME_IN_MILLIS = TIMESTAMP_CLASS.getDeclaredMethod("setTimeInMillis", Long.TYPE);
            TO_SQL_TIMESTAMP = TIMESTAMP_CLASS.getDeclaredMethod("toSqlTimestamp", new Class[0]);
            TIMESTAMP_WRITEABLE_V2_CONSTRUCTOR = Class.forName(TIMESTAMP_WRITEABLE_V2_CLASS).getConstructor(TIMESTAMP_CLASS);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LOG.trace("can not find hive3 timestampv2 class or method, use hive2 class!", (Throwable)e);
        }
        try {
            DATE_WRITEABLE_CLASS = Class.forName(DATE_WRITEABLE_V2_CLASS);
            GET_DAYS = DATE_WRITEABLE_CLASS.getDeclaredMethod("getDays", new Class[0]);
            DATE_WRITEABLE_V2_CONSTRUCTOR = DATE_WRITEABLE_CLASS.getConstructor(Integer.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LOG.trace("can not find hive3 datev2 class or method, use hive2 class!", (Throwable)e);
        }
        INSTANCE = new Hive3Shim();
    }
}

