/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetRecordReaderWrapper;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.TablePathUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.BootstrapBaseFileSplit;
import org.apache.hudi.hadoop.BootstrapColumnStichingRecordReader;
import org.apache.hudi.hadoop.HoodieColumnProjectionUtils;
import org.apache.hudi.hadoop.HoodieCopyOnWriteTableInputFormat;
import org.apache.hudi.hadoop.HoodieFileGroupReaderBasedRecordReader;
import org.apache.hudi.hadoop.HoodieParquetInputFormatBase;
import org.apache.hudi.hadoop.SchemaEvolutionContext;
import org.apache.hudi.hadoop.UseFileSplitsFromInputFormat;
import org.apache.hudi.hadoop.UseRecordReaderFromInputFormat;
import org.apache.hudi.hadoop.avro.HoodieTimestampAwareParquetInputFormat;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.hadoop.utils.HoodieRealtimeInputFormatUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseRecordReaderFromInputFormat
@UseFileSplitsFromInputFormat
public class HoodieParquetInputFormat
extends HoodieParquetInputFormatBase {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieParquetInputFormat.class);
    private boolean supportAvroRead = false;

    public HoodieParquetInputFormat() {
        super(new HoodieCopyOnWriteTableInputFormat());
        this.initAvroInputFormat();
    }

    protected HoodieParquetInputFormat(HoodieCopyOnWriteTableInputFormat delegate) {
        super(delegate);
        this.initAvroInputFormat();
    }

    private void initAvroInputFormat() {
        try {
            Constructor<?>[] constructors = ParquetRecordReaderWrapper.class.getConstructors();
            if (Arrays.stream(constructors).anyMatch(c -> c.getParameterCount() > 0 && c.getParameterTypes()[0].getName().equals(ParquetInputFormat.class.getName()))) {
                this.supportAvroRead = true;
            }
        }
        catch (SecurityException e) {
            throw new HoodieException("Failed to check if support avro reader: " + e.getMessage(), (Throwable)e);
        }
    }

    private static boolean checkIfHudiTable(InputSplit split, JobConf job) {
        try {
            Path inputPath = ((FileSplit)split).getPath();
            FileSystem fs = inputPath.getFileSystem((Configuration)job);
            HoodieHadoopStorage storage = new HoodieHadoopStorage(fs);
            return (Boolean)TablePathUtils.getTablePath((HoodieStorage)storage, (StoragePath)HadoopFSUtils.convertToStoragePath((Path)inputPath)).map(arg_0 -> HoodieParquetInputFormat.lambda$checkIfHudiTable$1((HoodieStorage)storage, arg_0)).orElse((Object)false);
        }
        catch (IOException e) {
            return false;
        }
    }

    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        HoodieRealtimeInputFormatUtils.addProjectionField((Configuration)job, job.get("partition_columns", "").split("/"));
        if (HoodieInputFormatUtils.shouldUseFilegroupReader(job, split)) {
            try {
                if (!(split instanceof FileSplit) || !HoodieParquetInputFormat.checkIfHudiTable(split, job)) {
                    return super.getRecordReader(split, job, reporter);
                }
                if (this.supportAvroRead && HoodieColumnProjectionUtils.supportTimestamp((Configuration)job)) {
                    return new HoodieFileGroupReaderBasedRecordReader((s, j) -> {
                        try {
                            return new ParquetRecordReaderWrapper((ParquetInputFormat)new HoodieTimestampAwareParquetInputFormat(), s, j, reporter);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }, split, job);
                }
                return new HoodieFileGroupReaderBasedRecordReader((s, j) -> super.getRecordReader(s, j, reporter), split, job);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot create a RecordReaderWrapper", e);
            }
        }
        if (split instanceof BootstrapBaseFileSplit) {
            return this.createBootstrappingRecordReader(split, job, reporter);
        }
        new SchemaEvolutionContext(split, job).doEvolutionForParquetFormat();
        if (LOG.isDebugEnabled()) {
            LOG.debug("EMPLOYING DEFAULT RECORD READER - " + split);
        }
        return this.getRecordReaderInternal(split, job, reporter);
    }

    private RecordReader<NullWritable, ArrayWritable> getRecordReaderInternal(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        try {
            if (this.supportAvroRead && HoodieColumnProjectionUtils.supportTimestamp((Configuration)job)) {
                return new ParquetRecordReaderWrapper((ParquetInputFormat)new HoodieTimestampAwareParquetInputFormat(), split, job, reporter);
            }
            return super.getRecordReader(split, job, reporter);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Cannot create a RecordReaderWrapper", e);
        }
    }

    private RecordReader<NullWritable, ArrayWritable> createBootstrappingRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        BootstrapBaseFileSplit eSplit = (BootstrapBaseFileSplit)split;
        String[] rawColNames = HoodieColumnProjectionUtils.getReadColumnNames((Configuration)job);
        List<Integer> rawColIds = HoodieColumnProjectionUtils.getReadColumnIDs((Configuration)job);
        List projectedColsWithIndex = IntStream.range(0, rawColIds.size()).mapToObj(idx -> Pair.of(rawColIds.get(idx), (Object)rawColNames[idx])).collect(Collectors.toList());
        List hoodieColsProjected = projectedColsWithIndex.stream().filter(idxWithName -> HoodieRecord.HOODIE_META_COLUMNS.contains(idxWithName.getValue())).collect(Collectors.toList());
        List externalColsProjected = projectedColsWithIndex.stream().filter(idxWithName -> !HoodieRecord.HOODIE_META_COLUMNS.contains(idxWithName.getValue()) && !HoodieHiveUtils.VIRTUAL_COLUMN_NAMES.contains(idxWithName.getValue())).collect(Collectors.toList());
        List<Pair<String, String>> colNameWithTypes = HoodieColumnProjectionUtils.getIOColumnNameAndTypes((Configuration)job);
        List colNamesWithTypesForExternal = colNameWithTypes.stream().filter(p -> !HoodieRecord.HOODIE_META_COLUMNS.contains(p.getKey())).collect(Collectors.toList());
        LOG.info("colNameWithTypes =" + colNameWithTypes + ", Num Entries =" + colNameWithTypes.size());
        if (hoodieColsProjected.isEmpty()) {
            return this.getRecordReaderInternal((InputSplit)eSplit.getBootstrapFileSplit(), job, reporter);
        }
        if (externalColsProjected.isEmpty()) {
            return this.getRecordReaderInternal(split, job, reporter);
        }
        FileSplit rightSplit = eSplit.getBootstrapFileSplit();
        JobConf jobConfCopy = new JobConf((Configuration)job);
        jobConfCopy.unset("hive.io.filter.expr.serialized");
        jobConfCopy.unset("sarg.pushdown");
        LOG.info("Generating column stitching reader for " + eSplit.getPath() + " and " + rightSplit.getPath());
        return new BootstrapColumnStichingRecordReader(this.getRecordReaderInternal((InputSplit)eSplit, jobConfCopy, reporter), HoodieRecord.HOODIE_META_COLUMNS.size(), this.getRecordReaderInternal((InputSplit)rightSplit, jobConfCopy, reporter), colNamesWithTypesForExternal.size(), true);
    }

    private static /* synthetic */ Boolean lambda$checkIfHudiTable$1(HoodieStorage storage, StoragePath path) {
        return TablePathUtils.isHoodieTablePath((HoodieStorage)storage, (StoragePath)path);
    }
}

