/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.collection.ArrayUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;

public class HoodieCombineRealtimeFileSplit
extends CombineFileSplit {
    List<FileSplit> realtimeFileSplits = new ArrayList<FileSplit>();

    public HoodieCombineRealtimeFileSplit() {
    }

    public HoodieCombineRealtimeFileSplit(JobConf jobConf, List<FileSplit> realtimeFileSplits) {
        super(jobConf, realtimeFileSplits.stream().map(p -> ((HoodieRealtimeFileSplit)p).getPath()).collect(Collectors.toList()).toArray(new Path[realtimeFileSplits.size()]), ArrayUtils.toPrimitive((Long[])realtimeFileSplits.stream().map(p -> ((HoodieRealtimeFileSplit)p).getStart()).collect(Collectors.toList()).toArray(new Long[realtimeFileSplits.size()])), ArrayUtils.toPrimitive((Long[])realtimeFileSplits.stream().map(p -> ((HoodieRealtimeFileSplit)p).getLength()).collect(Collectors.toList()).toArray(new Long[realtimeFileSplits.size()])), realtimeFileSplits.stream().map(p -> {
            try {
                return Arrays.asList(p.getLocations());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList()).toArray(new String[realtimeFileSplits.size()]));
        this.realtimeFileSplits = realtimeFileSplits;
    }

    public List<FileSplit> getRealtimeFileSplits() {
        return this.realtimeFileSplits;
    }

    public String toString() {
        return "HoodieCombineRealtimeFileSplit{realtimeFileSplits=" + this.realtimeFileSplits + '}';
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.realtimeFileSplits.size());
        for (InputSplit inputSplit : this.realtimeFileSplits) {
            Text.writeString((DataOutput)out, (String)inputSplit.getClass().getName());
            inputSplit.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int listLength = in.readInt();
        this.realtimeFileSplits = new ArrayList<FileSplit>(listLength);
        for (int i = 0; i < listLength; ++i) {
            String inputClassName = Text.readString((DataInput)in);
            HoodieRealtimeFileSplit inputSplit = (HoodieRealtimeFileSplit)ReflectionUtils.loadClass((String)inputClassName);
            inputSplit.readFields(in);
            this.realtimeFileSplits.add(inputSplit);
        }
    }

    public long getLength() {
        return this.realtimeFileSplits.size();
    }

    public long[] getStartOffsets() {
        return this.realtimeFileSplits.stream().mapToLong(x -> 0L).toArray();
    }

    public long[] getLengths() {
        return this.realtimeFileSplits.stream().mapToLong(FileSplit::getLength).toArray();
    }

    public long getOffset(int i) {
        return 0L;
    }

    public long getLength(int i) {
        return this.realtimeFileSplits.get(i).getLength();
    }

    public int getNumPaths() {
        return this.realtimeFileSplits.size();
    }

    public Path getPath(int i) {
        return this.realtimeFileSplits.get(i).getPath();
    }

    public Path[] getPaths() {
        return (Path[])this.realtimeFileSplits.stream().map(x -> x.getPath()).toArray(Path[]::new);
    }

    public String[] getLocations() throws IOException {
        return (String[])this.realtimeFileSplits.stream().flatMap(x -> {
            try {
                return Arrays.stream(x.getLocations());
            }
            catch (IOException e) {
                throw new HoodieIOException(e.getMessage(), e);
            }
        }).toArray(String[]::new);
    }

    public static class Builder {
        public List<FileSplit> fileSplits = new ArrayList<FileSplit>();

        public void addSplit(FileSplit split) {
            this.fileSplits.add(split);
        }

        public HoodieCombineRealtimeFileSplit build(JobConf conf) {
            return new HoodieCombineRealtimeFileSplit(conf, this.fileSplits);
        }
    }
}

