/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.InstanceCache;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hudi.avro.AvroSchemaUtils;

public class HiveTypeUtils {
    private static final Map<Schema.Type, TypeInfo> PRIMITIVE_TYPE_TO_TYPE_INFO = HiveTypeUtils.initTypeMap();
    static InstanceCache<Schema, TypeInfo> typeInfoCache = new InstanceCache<Schema, TypeInfo>(){

        protected TypeInfo makeInstance(Schema s, Set<Schema> seenSchemas) throws AvroSerdeException {
            return HiveTypeUtils.generateTypeInfoWorker(s, seenSchemas);
        }
    };

    private static Map<Schema.Type, TypeInfo> initTypeMap() {
        Hashtable<Schema.Type, PrimitiveTypeInfo> theMap = new Hashtable<Schema.Type, PrimitiveTypeInfo>();
        theMap.put(Schema.Type.NULL, TypeInfoFactory.getPrimitiveTypeInfo((String)"void"));
        theMap.put(Schema.Type.BOOLEAN, TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean"));
        theMap.put(Schema.Type.INT, TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        theMap.put(Schema.Type.LONG, TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        theMap.put(Schema.Type.FLOAT, TypeInfoFactory.getPrimitiveTypeInfo((String)"float"));
        theMap.put(Schema.Type.DOUBLE, TypeInfoFactory.getPrimitiveTypeInfo((String)"double"));
        theMap.put(Schema.Type.BYTES, TypeInfoFactory.getPrimitiveTypeInfo((String)"binary"));
        theMap.put(Schema.Type.FIXED, TypeInfoFactory.getPrimitiveTypeInfo((String)"binary"));
        theMap.put(Schema.Type.STRING, TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        return Collections.unmodifiableMap(theMap);
    }

    public static List<TypeInfo> generateColumnTypes(Schema schema) throws AvroSerdeException {
        return HiveTypeUtils.generateColumnTypes(schema, null);
    }

    public static List<TypeInfo> generateColumnTypes(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        List fields = schema.getFields();
        ArrayList<TypeInfo> types = new ArrayList<TypeInfo>(fields.size());
        for (Schema.Field field : fields) {
            types.add(HiveTypeUtils.generateTypeInfo(field.schema(), seenSchemas));
        }
        return types;
    }

    public static TypeInfo generateTypeInfo(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        Schema.Type type = schema.getType();
        if ((type == Schema.Type.BYTES || type == Schema.Type.FIXED) && "decimal".equalsIgnoreCase(schema.getProp("logicalType"))) {
            int precision = 0;
            int scale = 0;
            try {
                precision = HiveTypeUtils.getIntValue(schema.getObjectProp("precision"));
                scale = HiveTypeUtils.getIntValue(schema.getObjectProp("scale"));
            }
            catch (Exception ex) {
                throw new AvroSerdeException("Failed to obtain scale value from file schema: " + schema, (Throwable)ex);
            }
            try {
                HiveDecimalUtils.validateParameter((int)precision, (int)scale);
            }
            catch (Exception ex) {
                throw new AvroSerdeException("Invalid precision or scale for decimal type", (Throwable)ex);
            }
            return TypeInfoFactory.getDecimalTypeInfo((int)precision, (int)scale);
        }
        if (type == Schema.Type.STRING && "char".equalsIgnoreCase(schema.getProp("logicalType"))) {
            int maxLength = 0;
            try {
                maxLength = HiveTypeUtils.getIntFromSchema(schema, "maxLength");
            }
            catch (Exception ex) {
                throw new AvroSerdeException("Failed to obtain maxLength value from file schema: " + schema, (Throwable)ex);
            }
            return TypeInfoFactory.getCharTypeInfo((int)maxLength);
        }
        if (type == Schema.Type.STRING && "varchar".equalsIgnoreCase(schema.getProp("logicalType"))) {
            int maxLength = 0;
            try {
                maxLength = HiveTypeUtils.getIntFromSchema(schema, "maxLength");
            }
            catch (Exception ex) {
                throw new AvroSerdeException("Failed to obtain maxLength value from file schema: " + schema, (Throwable)ex);
            }
            return TypeInfoFactory.getVarcharTypeInfo((int)maxLength);
        }
        if (type == Schema.Type.INT && "date".equals(schema.getProp("logicalType"))) {
            return TypeInfoFactory.dateTypeInfo;
        }
        if (type == Schema.Type.LONG && "timestamp-millis".equals(schema.getProp("logicalType"))) {
            return TypeInfoFactory.timestampTypeInfo;
        }
        return (TypeInfo)typeInfoCache.retrieve((Object)schema, seenSchemas);
    }

    private static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    private static boolean isNumeric(CharSequence cs) {
        if (HiveTypeUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int getIntValue(Object obj) {
        int value = 0;
        if (obj instanceof Integer) {
            value = (Integer)obj;
        } else if (obj instanceof String && HiveTypeUtils.isNumeric((String)obj)) {
            value = Integer.parseInt((String)obj);
        }
        return value;
    }

    public static int getIntFromSchema(Schema schema, String name) {
        Object obj = schema.getObjectProp(name);
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new IllegalArgumentException("Expect integer or string value from property " + name + " but found type " + obj.getClass().getName());
    }

    private static TypeInfo generateTypeInfoWorker(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        if (AvroSchemaUtils.isNullable((Schema)schema)) {
            return HiveTypeUtils.generateTypeInfo(AvroSchemaUtils.getNonNullTypeFromUnion((Schema)schema), seenSchemas);
        }
        Schema.Type type = schema.getType();
        if (PRIMITIVE_TYPE_TO_TYPE_INFO.containsKey(type)) {
            return PRIMITIVE_TYPE_TO_TYPE_INFO.get(type);
        }
        switch (type) {
            case RECORD: {
                return HiveTypeUtils.generateRecordTypeInfo(schema, seenSchemas);
            }
            case MAP: {
                return HiveTypeUtils.generateMapTypeInfo(schema, seenSchemas);
            }
            case ARRAY: {
                return HiveTypeUtils.generateArrayTypeInfo(schema, seenSchemas);
            }
            case UNION: {
                return HiveTypeUtils.generateUnionTypeInfo(schema, seenSchemas);
            }
            case ENUM: {
                return HiveTypeUtils.generateEnumTypeInfo(schema);
            }
        }
        throw new AvroSerdeException("Do not yet support: " + schema);
    }

    private static TypeInfo generateRecordTypeInfo(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        assert (schema.getType().equals((Object)Schema.Type.RECORD));
        if (seenSchemas == null) {
            seenSchemas = Collections.newSetFromMap(new IdentityHashMap());
        } else if (seenSchemas.contains(schema)) {
            throw new AvroSerdeException("Recursive schemas are not supported. Recursive schema was " + schema.getFullName());
        }
        seenSchemas.add(schema);
        List fields = schema.getFields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            fieldNames.add(i, ((Schema.Field)fields.get(i)).name());
            typeInfos.add(i, HiveTypeUtils.generateTypeInfo(((Schema.Field)fields.get(i)).schema(), seenSchemas));
        }
        return TypeInfoFactory.getStructTypeInfo(fieldNames, typeInfos);
    }

    private static TypeInfo generateMapTypeInfo(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        assert (schema.getType().equals((Object)Schema.Type.MAP));
        Schema valueType = schema.getValueType();
        TypeInfo ti = HiveTypeUtils.generateTypeInfo(valueType, seenSchemas);
        return TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), (TypeInfo)ti);
    }

    private static TypeInfo generateArrayTypeInfo(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        assert (schema.getType().equals((Object)Schema.Type.ARRAY));
        Schema itemsType = schema.getElementType();
        TypeInfo itemsTypeInfo = HiveTypeUtils.generateTypeInfo(itemsType, seenSchemas);
        return TypeInfoFactory.getListTypeInfo((TypeInfo)itemsTypeInfo);
    }

    private static TypeInfo generateUnionTypeInfo(Schema schema, Set<Schema> seenSchemas) throws AvroSerdeException {
        assert (schema.getType().equals((Object)Schema.Type.UNION));
        List types = schema.getTypes();
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>(types.size());
        for (Schema type : types) {
            typeInfos.add(HiveTypeUtils.generateTypeInfo(type, seenSchemas));
        }
        return TypeInfoFactory.getUnionTypeInfo(typeInfos);
    }

    private static TypeInfo generateEnumTypeInfo(Schema schema) {
        assert (schema.getType().equals((Object)Schema.Type.ENUM));
        return TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
    }
}

