/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.hadoop.HoodieHiveRecordMerger;

public class DefaultHiveRecordMerger
extends HoodieHiveRecordMerger {
    public <T> BufferedRecord<T> merge(BufferedRecord<T> older, BufferedRecord<T> newer, RecordContext<T> recordContext, TypedProperties props) throws IOException {
        if (HoodieRecordMerger.isCommitTimeOrderingDelete(older, newer)) {
            return newer;
        }
        if (older.getOrderingValue().compareTo(newer.getOrderingValue()) > 0) {
            return older;
        }
        return newer;
    }

    public String getMergingStrategy() {
        return "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5";
    }
}

