/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.HiveTypeUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieAvroSchemaException;
import org.apache.hudi.hadoop.DefaultHiveRecordMerger;
import org.apache.hudi.hadoop.HiveRecordContext;
import org.apache.hudi.hadoop.HoodieFileGroupReaderBasedRecordReader;
import org.apache.hudi.hadoop.OverwriteWithLatestHiveRecordMerger;
import org.apache.hudi.hadoop.RecordReaderValueIterator;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.parquet.schema.AvroSchemaRepair;

public class HiveHoodieReaderContext
extends HoodieReaderContext<ArrayWritable> {
    protected final HoodieFileGroupReaderBasedRecordReader.HiveReaderCreator readerCreator;
    private RecordReader<NullWritable, ArrayWritable> firstRecordReader = null;
    private final List<String> partitionCols;
    private final Set<String> partitionColSet;

    protected HiveHoodieReaderContext(HoodieFileGroupReaderBasedRecordReader.HiveReaderCreator readerCreator, List<String> partitionCols, StorageConfiguration<?> storageConfiguration, HoodieTableConfig tableConfig) {
        super(storageConfiguration, tableConfig, Option.empty(), Option.empty(), (RecordContext)new HiveRecordContext(tableConfig));
        if (storageConfiguration.getString("parquet.avro.add-list-element-records").isEmpty()) {
            storageConfiguration.set("parquet.avro.add-list-element-records", "false");
        }
        this.readerCreator = readerCreator;
        this.partitionCols = partitionCols;
        this.partitionColSet = new HashSet<String>(this.partitionCols);
    }

    private void setSchemas(JobConf jobConf, Schema dataSchema, Schema requiredSchema) {
        List<TypeInfo> columnTypes;
        List dataColumnNameList = dataSchema.getFields().stream().map(f -> f.name().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
        jobConf.set("columns", String.join((CharSequence)",", dataColumnNameList));
        try {
            columnTypes = HiveTypeUtils.generateColumnTypes(dataSchema);
        }
        catch (AvroSerdeException e) {
            throw new HoodieAvroSchemaException(String.format("Failed to generate hive column types from avro schema: %s, due to %s", new Object[]{dataSchema, e}));
        }
        jobConf.set("columns.types", columnTypes.stream().map(TypeInfo::getTypeName).collect(Collectors.joining(",")));
        String readColNames = requiredSchema.getFields().stream().map(f -> f.name()).collect(Collectors.joining(","));
        jobConf.set("hive.io.file.readcolumn.names", readColNames);
        jobConf.set("hive.io.file.readcolumn.ids", requiredSchema.getFields().stream().map(f -> String.valueOf(dataSchema.getField(f.name()).pos())).collect(Collectors.joining(",")));
    }

    public ClosableIterator<ArrayWritable> getFileRecordIterator(StoragePath filePath, long start, long length, Schema dataSchema, Schema requiredSchema, HoodieStorage storage) throws IOException {
        return this.getFileRecordIterator(filePath, null, start, length, dataSchema, requiredSchema, storage);
    }

    public ClosableIterator<ArrayWritable> getFileRecordIterator(StoragePathInfo storagePathInfo, long start, long length, Schema dataSchema, Schema requiredSchema, HoodieStorage storage) throws IOException {
        return this.getFileRecordIterator(storagePathInfo.getPath(), storagePathInfo.getLocations(), start, length, dataSchema, requiredSchema, storage);
    }

    private ClosableIterator<ArrayWritable> getFileRecordIterator(StoragePath filePath, String[] hosts, long start, long length, Schema dataSchema, Schema requiredSchema, HoodieStorage storage) throws IOException {
        boolean isParquetOrOrc = filePath.getFileExtension().equals(HoodieFileFormat.PARQUET.getFileExtension()) || filePath.getFileExtension().equals(HoodieFileFormat.ORC.getFileExtension());
        Schema avroFileSchema = AvroSchemaRepair.repairLogicalTypes((Schema)(isParquetOrOrc ? HoodieIOFactory.getIOFactory((HoodieStorage)storage).getFileFormatUtils(filePath).readAvroSchema(storage, filePath) : dataSchema), (Schema)dataSchema);
        Schema actualRequiredSchema = isParquetOrOrc ? AvroSchemaUtils.pruneDataSchema((Schema)avroFileSchema, (Schema)requiredSchema, Collections.emptySet()) : requiredSchema;
        JobConf jobConfCopy = new JobConf((Configuration)storage.getConf().unwrapAs(Configuration.class));
        if (this.getNeedsBootstrapMerge()) {
            jobConfCopy.unset("hive.io.filter.expr.serialized");
            jobConfCopy.unset("sarg.pushdown");
        }
        Schema modifiedDataSchema = HoodieAvroUtils.generateProjectionSchema((Schema)avroFileSchema, Stream.concat(avroFileSchema.getFields().stream().map(f -> f.name().toLowerCase(Locale.ROOT)).filter(n -> !this.partitionColSet.contains(n)), this.partitionCols.stream().filter(c -> avroFileSchema.getField(c) != null)).collect(Collectors.toList()));
        this.setSchemas(jobConfCopy, modifiedDataSchema, actualRequiredSchema);
        FileSplit inputSplit = new FileSplit(new Path(filePath.toString()), start, length, hosts);
        RecordReader<NullWritable, ArrayWritable> recordReader = this.readerCreator.getRecordReader((InputSplit)inputSplit, jobConfCopy, modifiedDataSchema);
        if (this.firstRecordReader == null) {
            this.firstRecordReader = recordReader;
        }
        RecordReaderValueIterator<NullWritable, ArrayWritable> recordIterator = new RecordReaderValueIterator<NullWritable, ArrayWritable>(recordReader);
        if (AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)modifiedDataSchema, (Schema)requiredSchema)) {
            return recordIterator;
        }
        return new CloseableMappingIterator(recordIterator, (Function)this.recordContext.projectRecord(modifiedDataSchema, requiredSchema));
    }

    public Option<HoodieRecordMerger> getRecordMerger(RecordMergeMode mergeMode, String mergeStrategyId, String mergeImplClasses) {
        switch (mergeMode) {
            case EVENT_TIME_ORDERING: {
                return Option.of((Object)new DefaultHiveRecordMerger());
            }
            case COMMIT_TIME_ORDERING: {
                return Option.of((Object)new OverwriteWithLatestHiveRecordMerger());
            }
        }
        Option recordMerger = HoodieRecordUtils.createValidRecordMerger((EngineType)EngineType.JAVA, (String)mergeImplClasses, (String)mergeStrategyId);
        if (recordMerger.isEmpty()) {
            throw new IllegalArgumentException("No valid hive merger implementation set for `hoodie.write.record.merge.custom.implementation.classes`");
        }
        return recordMerger;
    }

    public ClosableIterator<ArrayWritable> mergeBootstrapReaders(final ClosableIterator<ArrayWritable> skeletonFileIterator, Schema skeletonRequiredSchema, final ClosableIterator<ArrayWritable> dataFileIterator, Schema dataRequiredSchema, List<Pair<String, Object>> partitionFieldsAndValues) {
        final int skeletonLen = skeletonRequiredSchema.getFields().size();
        final int dataLen = dataRequiredSchema.getFields().size();
        final int[] partitionFieldPositions = partitionFieldsAndValues.stream().map(pair -> dataRequiredSchema.getField((String)pair.getKey()).pos()).mapToInt(Integer::intValue).toArray();
        final Writable[] convertedPartitionValues = (Writable[])partitionFieldsAndValues.stream().map(Pair::getValue).toArray(Writable[]::new);
        return new ClosableIterator<ArrayWritable>(){
            private final ArrayWritable returnWritable = new ArrayWritable(Writable.class);

            public boolean hasNext() {
                if (dataFileIterator.hasNext() != skeletonFileIterator.hasNext()) {
                    throw new IllegalStateException("bootstrap data file iterator and skeleton file iterator are out of sync");
                }
                return dataFileIterator.hasNext();
            }

            public ArrayWritable next() {
                Writable[] skeletonWritable = ((ArrayWritable)skeletonFileIterator.next()).get();
                Writable[] dataWritable = ((ArrayWritable)dataFileIterator.next()).get();
                for (int i = 0; i < partitionFieldPositions.length; ++i) {
                    if (dataWritable[partitionFieldPositions[i]] != null && !(dataWritable[partitionFieldPositions[i]] instanceof NullWritable)) continue;
                    dataWritable[partitionFieldPositions[i]] = convertedPartitionValues[i];
                }
                Writable[] mergedWritable = new Writable[skeletonLen + dataLen];
                System.arraycopy(skeletonWritable, 0, mergedWritable, 0, skeletonLen);
                System.arraycopy(dataWritable, 0, mergedWritable, skeletonLen, dataLen);
                this.returnWritable.set(mergedWritable);
                return this.returnWritable;
            }

            public void close() {
                skeletonFileIterator.close();
                dataFileIterator.close();
            }
        };
    }

    public long getPos() throws IOException {
        if (this.firstRecordReader != null) {
            return this.firstRecordReader.getPos();
        }
        throw new IllegalStateException("getProgress() should not be called before a record reader has been initialized");
    }

    public float getProgress() throws IOException {
        if (this.firstRecordReader != null) {
            return this.firstRecordReader.getProgress();
        }
        throw new IllegalStateException("getProgress() should not be called before a record reader has been initialized");
    }
}

