/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieEmptyRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.util.JavaTypeConverter;
import org.apache.hudi.hadoop.HoodieHiveRecord;
import org.apache.hudi.hadoop.utils.HiveAvroSerializer;
import org.apache.hudi.hadoop.utils.HiveJavaTypeConverter;
import org.apache.hudi.hadoop.utils.HoodieArrayWritableAvroUtils;
import org.apache.hudi.hadoop.utils.HoodieRealtimeRecordReaderUtils;

public class HiveRecordContext
extends RecordContext<ArrayWritable> {
    private static final HiveRecordContext FIELD_ACCESSOR_INSTANCE = new HiveRecordContext();
    private final Map<Schema, HiveAvroSerializer> serializerCache = new ConcurrentHashMap<Schema, HiveAvroSerializer>();

    public static HiveRecordContext getFieldAccessorInstance() {
        return FIELD_ACCESSOR_INSTANCE;
    }

    private HiveAvroSerializer getHiveAvroSerializer(Schema schema) {
        return this.serializerCache.computeIfAbsent(schema, HiveAvroSerializer::new);
    }

    public HiveRecordContext(HoodieTableConfig tableConfig) {
        super(tableConfig, (JavaTypeConverter)new HiveJavaTypeConverter());
    }

    private HiveRecordContext() {
        super((JavaTypeConverter)new HiveJavaTypeConverter());
    }

    public Object getValue(ArrayWritable record, Schema schema, String fieldName) {
        return this.getHiveAvroSerializer(schema).getValue(record, fieldName);
    }

    public String getMetaFieldValue(ArrayWritable record, int pos) {
        return record.get()[pos].toString();
    }

    public HoodieRecord<ArrayWritable> constructHoodieRecord(BufferedRecord<ArrayWritable> bufferedRecord, String partitionPath) {
        HoodieKey key = new HoodieKey(bufferedRecord.getRecordKey(), partitionPath);
        if (bufferedRecord.isDelete()) {
            return new HoodieEmptyRecord(key, bufferedRecord.getHoodieOperation(), bufferedRecord.getOrderingValue(), HoodieRecord.HoodieRecordType.HIVE);
        }
        Schema schema = this.getSchemaFromBufferRecord(bufferedRecord);
        ArrayWritable writable = (ArrayWritable)bufferedRecord.getRecord();
        return new HoodieHiveRecord(key, writable, schema, this.getHiveAvroSerializer(schema), bufferedRecord.getHoodieOperation(), bufferedRecord.getOrderingValue(), bufferedRecord.isDelete());
    }

    public ArrayWritable constructEngineRecord(Schema recordSchema, Object[] fieldValues) {
        return new ArrayWritable(Writable.class, (Writable[])fieldValues);
    }

    public ArrayWritable mergeWithEngineRecord(Schema schema, Map<Integer, Object> updateValues, BufferedRecord<ArrayWritable> baseRecord) {
        Writable[] engineRecord = ((ArrayWritable)baseRecord.getRecord()).get();
        for (Map.Entry<Integer, Object> value : updateValues.entrySet()) {
            engineRecord[value.getKey().intValue()] = (Writable)value.getValue();
        }
        return (ArrayWritable)baseRecord.getRecord();
    }

    public Comparable convertValueToEngineType(Comparable value) {
        if (value instanceof WritableComparable) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return new Text((String)((Object)value));
        }
        if (value instanceof Integer) {
            return new IntWritable(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new LongWritable(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return new FloatWritable(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new DoubleWritable(((Double)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return new BooleanWritable(((Boolean)value).booleanValue());
        }
        return value;
    }

    public ArrayWritable convertAvroRecord(IndexedRecord avroRecord) {
        return (ArrayWritable)HoodieRealtimeRecordReaderUtils.avroToArrayWritable(avroRecord, avroRecord.getSchema(), true);
    }

    public GenericRecord convertToAvroRecord(ArrayWritable record, Schema schema) {
        return this.getHiveAvroSerializer(schema).serialize(record);
    }

    public ArrayWritable getDeleteRow(String recordKey) {
        throw new UnsupportedOperationException("Not supported for " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public ArrayWritable seal(ArrayWritable record) {
        return new ArrayWritable(Writable.class, Arrays.copyOf(record.get(), record.get().length));
    }

    public ArrayWritable toBinaryRow(Schema schema, ArrayWritable record) {
        return record;
    }

    public UnaryOperator<ArrayWritable> projectRecord(Schema from, Schema to, Map<String, String> renamedColumns) {
        return record -> HoodieArrayWritableAvroUtils.rewriteRecordWithNewSchema(record, from, to, renamedColumns);
    }
}

