/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.OrderingValues;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hadoop.HiveRecordContext;
import org.apache.hudi.hadoop.utils.HiveAvroSerializer;
import org.apache.hudi.keygen.BaseKeyGenerator;

public class HoodieHiveRecord
extends HoodieRecord<ArrayWritable> {
    private boolean copy;
    private final HiveAvroSerializer avroSerializer;
    protected Schema schema;

    public HoodieHiveRecord(HoodieKey key, ArrayWritable data, Schema schema, HiveAvroSerializer avroSerializer) {
        super(key, (Object)data);
        this.avroSerializer = avroSerializer;
        this.schema = schema;
        this.copy = false;
        this.isDelete = data == null;
    }

    public HoodieHiveRecord(HoodieKey key, ArrayWritable data, Schema schema, HiveAvroSerializer avroSerializer, HoodieOperation hoodieOperation, Comparable orderingValue, boolean isDelete) {
        super(key, (Object)data, hoodieOperation, Boolean.valueOf(isDelete), Option.empty());
        this.orderingValue = orderingValue;
        this.avroSerializer = avroSerializer;
        this.schema = schema;
        this.copy = false;
    }

    private HoodieHiveRecord(HoodieKey key, ArrayWritable data, Schema schema, HoodieOperation operation, boolean isCopy, HiveAvroSerializer avroSerializer) {
        super(key, (Object)data, operation, Option.empty());
        this.schema = schema;
        this.copy = isCopy;
        this.isDelete = data == null;
        this.avroSerializer = avroSerializer;
    }

    public HoodieRecord<ArrayWritable> newInstance() {
        return new HoodieHiveRecord(this.key, (ArrayWritable)this.data, this.schema, this.operation, this.copy, this.avroSerializer);
    }

    public HoodieRecord<ArrayWritable> newInstance(HoodieKey key, HoodieOperation op) {
        throw new UnsupportedOperationException("ObjectInspector is needed for HoodieHiveRecord");
    }

    public HoodieRecord<ArrayWritable> newInstance(HoodieKey key) {
        throw new UnsupportedOperationException("ObjectInspector is needed for HoodieHiveRecord");
    }

    public Comparable<?> doGetOrderingValue(Schema recordSchema, Properties props, String[] orderingFields) {
        if (orderingFields == null) {
            return OrderingValues.getDefault();
        }
        return OrderingValues.create((String[])orderingFields, field -> (Comparable)this.getValue((String)field));
    }

    public HoodieRecord.HoodieRecordType getRecordType() {
        return HoodieRecord.HoodieRecordType.HIVE;
    }

    public String getRecordKey(Schema recordSchema, Option<BaseKeyGenerator> keyGeneratorOpt) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    public String getRecordKey(Schema recordSchema, String keyFieldName) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    protected void writeRecordPayload(ArrayWritable payload, Kryo kryo, Output output) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    protected ArrayWritable readRecordPayload(Kryo kryo, Input input) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    public Object convertColumnValueForLogicalType(Schema fieldSchema, Object fieldValue, boolean keepConsistentLogicalTimestamp) {
        if (fieldValue == null) {
            return null;
        }
        LogicalType logicalType = fieldSchema.getLogicalType();
        if (logicalType == LogicalTypes.date()) {
            return LocalDate.ofEpochDay(((IntWritable)fieldValue).get());
        }
        if (logicalType == LogicalTypes.timestampMillis() && keepConsistentLogicalTimestamp) {
            return ((LongWritable)fieldValue).get();
        }
        if (logicalType == LogicalTypes.timestampMicros() && keepConsistentLogicalTimestamp) {
            return ((LongWritable)fieldValue).get() / 1000L;
        }
        if (logicalType instanceof LogicalTypes.Decimal) {
            return ((HiveDecimalWritable)fieldValue).getHiveDecimal().bigDecimalValue();
        }
        return fieldValue;
    }

    public Object[] getColumnValues(Schema recordSchema, String[] columns, boolean consistentLogicalTimestampEnabled) {
        Object[] objects = new Object[columns.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this.getValue(columns[i]);
        }
        return objects;
    }

    public Object getColumnValueAsJava(Schema recordSchema, String column, Properties props) {
        return this.avroSerializer.getValueAsJava((ArrayWritable)this.data, column);
    }

    public HoodieRecord joinWith(HoodieRecord other, Schema targetSchema) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    public HoodieRecord prependMetaFields(Schema recordSchema, Schema targetSchema, MetadataValues metadataValues, Properties props) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    public HoodieRecord rewriteRecordWithNewSchema(Schema recordSchema, Properties props, Schema newSchema, Map<String, String> renameCols) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    public boolean checkIsDelete(DeleteContext deleteContext, Properties props) {
        if (null == this.data || HoodieOperation.isDelete((HoodieOperation)this.getOperation())) {
            return true;
        }
        return HiveRecordContext.getFieldAccessorInstance().isDeleteRecord(this.data, deleteContext);
    }

    public boolean shouldIgnore(Schema recordSchema, Properties props) throws IOException {
        return false;
    }

    public HoodieRecord<ArrayWritable> copy() {
        if (!this.copy) {
            this.data = new ArrayWritable(Writable.class, Arrays.copyOf(((ArrayWritable)this.data).get(), ((ArrayWritable)this.data).get().length));
            this.copy = true;
        }
        return this;
    }

    public Option<Map<String, String>> getMetadata() {
        return Option.empty();
    }

    public HoodieRecord wrapIntoHoodieRecordPayloadWithParams(Schema recordSchema, Properties props, Option<Pair<String, String>> simpleKeyGenFieldsOpt, Boolean withOperation, Option<String> partitionNameOp, Boolean populateMetaFieldsOp, Option<Schema> schemaWithoutMetaFields) throws IOException {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    public HoodieRecord wrapIntoHoodieRecordPayloadWithKeyGen(Schema recordSchema, Properties props, Option<BaseKeyGenerator> keyGen) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    public HoodieRecord truncateRecordKey(Schema recordSchema, Properties props, String keyFieldName) throws IOException {
        ((ArrayWritable)this.data).get()[recordSchema.getIndexNamed((String)keyFieldName).intValue()] = new Text();
        return this;
    }

    public Option<HoodieAvroIndexedRecord> toIndexedRecord(Schema recordSchema, Properties props) throws IOException {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    public ByteArrayOutputStream getAvroBytes(Schema recordSchema, Properties props) throws IOException {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    private Object getValue(String name) {
        return this.avroSerializer.getValue((ArrayWritable)this.data, name);
    }

    protected Schema getSchema() {
        return this.schema;
    }
}

