/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieROTablePathFilter
implements Configurable,
PathFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HoodieROTablePathFilter.class);
    private final Map<String, HashSet<Path>> hoodiePathCache = new ConcurrentHashMap<String, HashSet<Path>>();
    Set<String> nonHoodiePathCache = new HashSet<String>();
    Map<String, HoodieTableMetaClient> metaClientCache;
    private StorageConfiguration<?> conf;
    private transient HoodieLocalEngineContext engineContext;
    private transient HoodieStorage storage;

    public HoodieROTablePathFilter() {
        this(new Configuration());
    }

    public HoodieROTablePathFilter(Configuration conf) {
        this.conf = HadoopFSUtils.getStorageConfWithCopy((Configuration)conf);
        this.metaClientCache = new HashMap<String, HoodieTableMetaClient>();
    }

    private Path safeGetParentsParent(Path path) {
        if (path.getParent() != null && path.getParent().getParent() != null && path.getParent().getParent().getParent() != null) {
            return path.getParent().getParent().getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accept(Path path) {
        if (this.engineContext == null) {
            this.engineContext = new HoodieLocalEngineContext(this.conf);
        }
        LOG.debug("Checking acceptance for path {}", (Object)path);
        Path folder = null;
        try {
            Path baseDir;
            if (this.storage == null) {
                this.storage = new HoodieHadoopStorage(HadoopFSUtils.convertToStoragePath((Path)path), this.conf);
            }
            if (this.nonHoodiePathCache.contains((folder = path.getParent()).toString())) {
                LOG.debug("Accepting non-hoodie path from cache: {}", (Object)path);
                return true;
            }
            if (this.hoodiePathCache.containsKey(folder.toString())) {
                LOG.debug("{} Hoodie path checked against cache, accept => {}", (Object)path, (Object)this.hoodiePathCache.get(folder.toString()).contains(path));
                return this.hoodiePathCache.get(folder.toString()).contains(path);
            }
            String filePath = path.toString();
            if (filePath.contains("/.hoodie/") || filePath.endsWith("/.hoodie")) {
                LOG.debug("Skipping Hoodie Metadata file {}", (Object)filePath);
                return false;
            }
            StoragePath storagePath = HadoopFSUtils.convertToStoragePath((Path)folder);
            if (HoodiePartitionMetadata.hasPartitionMetadata((HoodieStorage)this.storage, (StoragePath)storagePath)) {
                HoodiePartitionMetadata metadata = new HoodiePartitionMetadata(this.storage, storagePath);
                metadata.readFromFS();
                baseDir = HoodieHiveUtils.getNthParent(folder, metadata.getPartitionDepth());
            } else {
                baseDir = this.safeGetParentsParent(folder);
            }
            if (baseDir == null) {
                LOG.debug("(2) Caching non-hoodie path under{}", (Object)folder);
                this.nonHoodiePathCache.add(folder.toString());
                return true;
            }
            if (this.nonHoodiePathCache.contains(baseDir.toString())) {
                LOG.debug("Accepting non-hoodie path from cache: {}", (Object)path);
                return true;
            }
            try (HoodieTableFileSystemView fsView = null;){
                Configuration conf;
                String timestampAsOf;
                HoodieTableMetaClient metaClient = this.metaClientCache.get(baseDir.toString());
                if (null == metaClient) {
                    metaClient = HoodieTableMetaClient.builder().setConf(this.storage.getConf().newInstance()).setBasePath(baseDir.toString()).setLoadActiveTimelineOnLoad(true).build();
                    this.metaClientCache.put(baseDir.toString(), metaClient);
                }
                if (StringUtils.nonEmpty((String)(timestampAsOf = (conf = this.getConf()).get(HoodieCommonConfig.TIMESTAMP_AS_OF.key())))) {
                    TimelineUtils.validateTimestampAsOf((HoodieTableMetaClient)metaClient, (String)timestampAsOf);
                    fsView = FileSystemViewManager.createInMemoryFileSystemViewWithTimeline((HoodieEngineContext)this.engineContext, (HoodieTableMetaClient)metaClient, (HoodieMetadataConfig)HoodieInputFormatUtils.buildMetadataConfig(conf), (HoodieTimeline)metaClient.getActiveTimeline().filterCompletedInstants().findInstantsBeforeOrEquals(timestampAsOf));
                } else {
                    fsView = FileSystemViewManager.createInMemoryFileSystemView((HoodieEngineContext)this.engineContext, (HoodieTableMetaClient)metaClient, (HoodieMetadataConfig)HoodieInputFormatUtils.buildMetadataConfig(conf));
                }
                String partition = HadoopFSUtils.getRelativePartitionPath((Path)new Path(metaClient.getBasePath().toString()), (Path)folder);
                List latestFiles = fsView.getLatestBaseFiles(partition).collect(Collectors.toList());
                if (!this.hoodiePathCache.containsKey(folder.toString())) {
                    this.hoodiePathCache.put(folder.toString(), new HashSet());
                }
                LOG.info("Based on hoodie metadata from base path: {}, caching {} files under {}", new Object[]{baseDir, latestFiles.size(), folder});
                for (HoodieBaseFile lfile : latestFiles) {
                    this.hoodiePathCache.get(folder.toString()).add(new Path(lfile.getPath()));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} checked after cache population, accept => {}", (Object)path, (Object)this.hoodiePathCache.get(folder.toString()).contains(path));
                }
                boolean bl = this.hoodiePathCache.get(folder.toString()).contains(path);
                return bl;
            }
        }
        catch (Exception e) {
            String msg = "Error checking path :" + path + ", under folder: " + folder;
            LOG.error(msg, (Throwable)e);
            throw new HoodieException(msg, (Throwable)e);
        }
    }

    public void setConf(Configuration conf) {
        this.conf = HadoopFSUtils.getStorageConfWithCopy((Configuration)conf);
    }

    public Configuration getConf() {
        return (Configuration)this.conf.unwrapAs(Configuration.class);
    }
}

