/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.avro;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.avro.HoodieAvroParquetReader;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.util.ContextUtil;

public class HoodieTimestampAwareParquetInputFormat
extends ParquetInputFormat<ArrayWritable> {
    private final Option<InternalSchema> internalSchemaOption;
    private final Option<Schema> dataSchema;

    public HoodieTimestampAwareParquetInputFormat(Option<InternalSchema> internalSchemaOption, Option<Schema> dataSchema) {
        this.internalSchemaOption = internalSchemaOption;
        this.dataSchema = dataSchema;
    }

    public RecordReader<Void, ArrayWritable> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        Configuration conf = ContextUtil.getConfiguration((JobContext)taskAttemptContext);
        return new HoodieAvroParquetReader(inputSplit, conf, this.internalSchemaOption, this.dataSchema);
    }
}

