/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieAvroSchemaException;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;

public class HoodieArrayWritableAvroUtils {
    public static ArrayWritable rewriteRecordWithNewSchema(ArrayWritable writable, Schema oldSchema, Schema newSchema, Map<String, String> renameCols) {
        return (ArrayWritable)HoodieArrayWritableAvroUtils.rewriteRecordWithNewSchema((Writable)writable, oldSchema, newSchema, renameCols, new LinkedList<String>());
    }

    private static Writable rewriteRecordWithNewSchema(Writable writable, Schema oldAvroSchema, Schema newAvroSchema, Map<String, String> renameCols, Deque<String> fieldNames) {
        Schema newSchema;
        if (writable == null) {
            return null;
        }
        Schema oldSchema = AvroSchemaUtils.getNonNullTypeFromUnion((Schema)oldAvroSchema);
        if (AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)oldSchema, (Schema)(newSchema = AvroSchemaUtils.getNonNullTypeFromUnion((Schema)newAvroSchema)))) {
            return writable;
        }
        return HoodieArrayWritableAvroUtils.rewriteRecordWithNewSchemaInternal(writable, oldSchema, newSchema, renameCols, fieldNames);
    }

    private static Writable rewriteRecordWithNewSchemaInternal(Writable writable, Schema oldSchema, Schema newSchema, Map<String, String> renameCols, Deque<String> fieldNames) {
        switch (newSchema.getType()) {
            case RECORD: {
                if (!(writable instanceof ArrayWritable)) {
                    throw new SchemaCompatibilityException(String.format("Cannot rewrite %s as a record", writable.getClass().getName()));
                }
                ArrayWritable arrayWritable = (ArrayWritable)writable;
                List fields = newSchema.getFields();
                boolean noFieldsRenaming = renameCols.isEmpty();
                String namePrefix = HoodieAvroUtils.createNamePrefix((boolean)noFieldsRenaming, fieldNames);
                Writable[] values = new Writable[Math.max(fields.size(), arrayWritable.get().length)];
                for (int i = 0; i < fields.size(); ++i) {
                    Schema.Field oldField;
                    Schema.Field newField = (Schema.Field)newSchema.getFields().get(i);
                    String newFieldName = newField.name();
                    fieldNames.push(newFieldName);
                    Schema.Field field = oldField = noFieldsRenaming ? oldSchema.getField(newFieldName) : oldSchema.getField(HoodieAvroUtils.getOldFieldNameWithRenaming((String)namePrefix, (String)newFieldName, renameCols));
                    if (oldField != null) {
                        values[i] = HoodieArrayWritableAvroUtils.rewriteRecordWithNewSchema(arrayWritable.get()[oldField.pos()], oldField.schema(), newField.schema(), renameCols, fieldNames);
                    } else if (newField.defaultVal() instanceof JsonProperties.Null) {
                        values[i] = NullWritable.get();
                    } else {
                        if (!AvroSchemaUtils.isNullable((Schema)newField.schema()) && newField.defaultVal() == null) {
                            throw new SchemaCompatibilityException("Field " + HoodieAvroUtils.createFullName(fieldNames) + " has no default value and is non-nullable");
                        }
                        if (newField.defaultVal() != null) {
                            switch (AvroSchemaUtils.getNonNullTypeFromUnion((Schema)newField.schema()).getType()) {
                                case BOOLEAN: {
                                    values[i] = new BooleanWritable(((Boolean)newField.defaultVal()).booleanValue());
                                    break;
                                }
                                case INT: {
                                    values[i] = new IntWritable(((Integer)newField.defaultVal()).intValue());
                                    break;
                                }
                                case LONG: {
                                    values[i] = new LongWritable(((Long)newField.defaultVal()).longValue());
                                    break;
                                }
                                case FLOAT: {
                                    values[i] = new FloatWritable(((Float)newField.defaultVal()).floatValue());
                                    break;
                                }
                                case DOUBLE: {
                                    values[i] = new DoubleWritable(((Double)newField.defaultVal()).doubleValue());
                                    break;
                                }
                                case STRING: {
                                    values[i] = new Text(newField.defaultVal().toString());
                                    break;
                                }
                                default: {
                                    throw new SchemaCompatibilityException("Field " + HoodieAvroUtils.createFullName(fieldNames) + " has no default value");
                                }
                            }
                        }
                    }
                    fieldNames.pop();
                }
                return new ArrayWritable(Writable.class, values);
            }
            case ENUM: {
                if (writable instanceof BytesWritable) {
                    return writable;
                }
                if (oldSchema.getType() != Schema.Type.STRING && oldSchema.getType() != Schema.Type.ENUM) {
                    throw new SchemaCompatibilityException(String.format("Only ENUM or STRING type can be converted ENUM type. Schema type was %s", oldSchema.getType().getName()));
                }
                if (oldSchema.getType() == Schema.Type.STRING) {
                    return new BytesWritable(((Text)writable).copyBytes());
                }
                return writable;
            }
            case ARRAY: {
                if (!(writable instanceof ArrayWritable)) {
                    throw new SchemaCompatibilityException(String.format("Cannot rewrite %s as an array", writable.getClass().getName()));
                }
                ArrayWritable array = (ArrayWritable)writable;
                fieldNames.push("element");
                for (int i = 0; i < array.get().length; ++i) {
                    array.get()[i] = HoodieArrayWritableAvroUtils.rewriteRecordWithNewSchema(array.get()[i], oldSchema.getElementType(), newSchema.getElementType(), renameCols, fieldNames);
                }
                fieldNames.pop();
                return array;
            }
            case MAP: {
                if (!(writable instanceof ArrayWritable)) {
                    throw new SchemaCompatibilityException(String.format("Cannot rewrite %s as a map", writable.getClass().getName()));
                }
                ArrayWritable map = (ArrayWritable)writable;
                fieldNames.push("value");
                for (int i = 0; i < map.get().length; ++i) {
                    Writable mapEntry = map.get()[i];
                    ((ArrayWritable)mapEntry).get()[1] = HoodieArrayWritableAvroUtils.rewriteRecordWithNewSchema(((ArrayWritable)mapEntry).get()[1], oldSchema.getValueType(), newSchema.getValueType(), renameCols, fieldNames);
                }
                return map;
            }
            case UNION: {
                throw new IllegalArgumentException("should not be here?");
            }
        }
        return HoodieArrayWritableAvroUtils.rewritePrimaryType(writable, oldSchema, newSchema);
    }

    public static Writable rewritePrimaryType(Writable writable, Schema oldSchema, Schema newSchema) {
        if (oldSchema.getType() == newSchema.getType()) {
            switch (oldSchema.getType()) {
                case BOOLEAN: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case STRING: 
                case NULL: 
                case BYTES: {
                    return writable;
                }
                case FIXED: {
                    if (oldSchema.getFixedSize() != newSchema.getFixedSize()) {
                        if (oldSchema.getLogicalType() instanceof LogicalTypes.Decimal) {
                            LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)oldSchema.getLogicalType();
                            return HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)((HiveDecimalWritable)writable), (DecimalTypeInfo)new DecimalTypeInfo(decimal.getPrecision(), decimal.getScale()));
                        }
                        throw new HoodieAvroSchemaException("Fixed type size change is not currently supported");
                    }
                    if (Objects.equals(oldSchema.getFullName(), newSchema.getFullName())) {
                        return writable;
                    }
                    LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)oldSchema.getLogicalType();
                    return HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)((HiveDecimalWritable)writable), (DecimalTypeInfo)new DecimalTypeInfo(decimal.getPrecision(), decimal.getScale()));
                }
            }
            throw new HoodieAvroSchemaException("Unknown schema type: " + newSchema.getType());
        }
        return HoodieArrayWritableAvroUtils.rewritePrimaryTypeWithDiffSchemaType(writable, oldSchema, newSchema);
    }

    private static Writable rewritePrimaryTypeWithDiffSchemaType(Writable writable, Schema oldSchema, Schema newSchema) {
        switch (newSchema.getType()) {
            case BOOLEAN: 
            case NULL: {
                break;
            }
            case INT: {
                if (newSchema.getLogicalType() != LogicalTypes.date() || oldSchema.getType() != Schema.Type.STRING) break;
                return HoodieHiveUtils.getDateWriteable(HoodieAvroUtils.fromJavaDate((Date)Date.valueOf(writable.toString())));
            }
            case LONG: {
                if (oldSchema.getType() != Schema.Type.INT) break;
                return new LongWritable((long)((IntWritable)writable).get());
            }
            case FLOAT: {
                if (oldSchema.getType() != Schema.Type.INT && oldSchema.getType() != Schema.Type.LONG) break;
                return oldSchema.getType() == Schema.Type.INT ? new FloatWritable((float)((IntWritable)writable).get()) : new FloatWritable((float)((LongWritable)writable).get());
            }
            case DOUBLE: {
                if (oldSchema.getType() == Schema.Type.FLOAT) {
                    return new DoubleWritable(Double.parseDouble(((FloatWritable)writable).get() + ""));
                }
                if (oldSchema.getType() == Schema.Type.INT) {
                    return new DoubleWritable((double)((IntWritable)writable).get());
                }
                if (oldSchema.getType() != Schema.Type.LONG) break;
                return new DoubleWritable((double)((LongWritable)writable).get());
            }
            case BYTES: {
                if (oldSchema.getType() != Schema.Type.STRING) break;
                return new BytesWritable(StringUtils.getUTF8Bytes((String)writable.toString()));
            }
            case STRING: {
                if (oldSchema.getType() == Schema.Type.ENUM) {
                    return writable;
                }
                if (oldSchema.getType() == Schema.Type.BYTES) {
                    return new Text(StringUtils.fromUTF8Bytes((byte[])((BytesWritable)writable).getBytes()));
                }
                if (oldSchema.getLogicalType() == LogicalTypes.date()) {
                    return new Text(HoodieAvroUtils.toJavaDate((int)((IntWritable)writable).get()).toString());
                }
                if (oldSchema.getType() == Schema.Type.INT || oldSchema.getType() == Schema.Type.LONG || oldSchema.getType() == Schema.Type.FLOAT || oldSchema.getType() == Schema.Type.DOUBLE) {
                    return new Text(writable.toString());
                }
                if (oldSchema.getType() != Schema.Type.FIXED || !(oldSchema.getLogicalType() instanceof LogicalTypes.Decimal)) break;
                HiveDecimalWritable hdw = (HiveDecimalWritable)writable;
                return new Text(hdw.getHiveDecimal().bigDecimalValue().toPlainString());
            }
            case FIXED: {
                if (!(newSchema.getLogicalType() instanceof LogicalTypes.Decimal)) break;
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)newSchema.getLogicalType();
                DecimalTypeInfo decimalTypeInfo = new DecimalTypeInfo(decimal.getPrecision(), decimal.getScale());
                if (oldSchema.getType() == Schema.Type.STRING || oldSchema.getType() == Schema.Type.INT || oldSchema.getType() == Schema.Type.LONG || oldSchema.getType() == Schema.Type.FLOAT || oldSchema.getType() == Schema.Type.DOUBLE) {
                    HiveDecimalWritable converted = new HiveDecimalWritable(HiveDecimal.create((BigDecimal)new BigDecimal(writable.toString())));
                    return HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)converted, (DecimalTypeInfo)decimalTypeInfo);
                }
                if (oldSchema.getType() != Schema.Type.BYTES) break;
                ByteBuffer buffer = ByteBuffer.wrap(((BytesWritable)writable).getBytes());
                BigDecimal bd = new BigDecimal(new BigInteger(buffer.array()), decimal.getScale());
                HiveDecimalWritable converted = new HiveDecimalWritable(HiveDecimal.create((BigDecimal)bd));
                return HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)converted, (DecimalTypeInfo)decimalTypeInfo);
            }
        }
        throw new HoodieAvroSchemaException(String.format("cannot support rewrite value for schema type: %s since the old schema type is: %s", newSchema, oldSchema));
    }

    private static int[] getReverseProjectionMapping(Schema from, Schema to) {
        List fromFields = from.getFields();
        int[] newProjection = new int[fromFields.size()];
        for (int i = 0; i < newProjection.length; ++i) {
            newProjection[i] = to.getField(((Schema.Field)fromFields.get(i)).name()).pos();
        }
        return newProjection;
    }

    public static UnaryOperator<ArrayWritable> getReverseProjection(Schema from, Schema to) {
        int[] projection = HoodieArrayWritableAvroUtils.getReverseProjectionMapping(from, to);
        return arrayWritable -> {
            Writable[] values = new Writable[to.getFields().size()];
            for (int i = 0; i < projection.length; ++i) {
                values[projection[i]] = arrayWritable.get()[i];
            }
            arrayWritable.set(values);
            return arrayWritable;
        };
    }
}

