/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class DecimalWrapper
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -562900601579885202L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"DecimalWrapper\",\"namespace\":\"org.apache.hudi.avro.model\",\"doc\":\"A record wrapping Decimal logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":30,\"scale\":15}}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<DecimalWrapper> ENCODER;
    private static final BinaryMessageDecoder<DecimalWrapper> DECODER;
    private ByteBuffer value;
    private static final Conversion<?>[] conversions;
    private static final DatumWriter<DecimalWrapper> WRITER$;
    private static final DatumReader<DecimalWrapper> READER$;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<DecimalWrapper> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<DecimalWrapper> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<DecimalWrapper> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder<DecimalWrapper>(MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static DecimalWrapper fromByteBuffer(ByteBuffer b) throws IOException {
        return (DecimalWrapper)DECODER.decode(b);
    }

    public DecimalWrapper() {
    }

    public DecimalWrapper(ByteBuffer value) {
        this.value = value;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.value;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public Conversion<?> getConversion(int field) {
        return conversions[field];
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.value = (ByteBuffer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public ByteBuffer getValue() {
        return this.value;
    }

    public void setValue(ByteBuffer value) {
        this.value = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(DecimalWrapper other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    static {
        MODEL$.addLogicalTypeConversion(new Conversions.DecimalConversion());
        ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
        DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
        conversions = new Conversion[]{null, null};
        WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
        READER$ = MODEL$.createDatumReader(SCHEMA$);
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<DecimalWrapper>
    implements RecordBuilder<DecimalWrapper> {
        private ByteBuffer value;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.value)) {
                this.value = this.data().deepCopy(this.fields()[0].schema(), other.value);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
        }

        private Builder(DecimalWrapper other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue(this.fields()[0], other.value)) {
                this.value = this.data().deepCopy(this.fields()[0].schema(), other.value);
                this.fieldSetFlags()[0] = true;
            }
        }

        public ByteBuffer getValue() {
            return this.value;
        }

        public Builder setValue(ByteBuffer value) {
            this.validate(this.fields()[0], value);
            this.value = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasValue() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearValue() {
            this.value = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        @Override
        public DecimalWrapper build() {
            try {
                DecimalWrapper record = new DecimalWrapper();
                record.value = this.fieldSetFlags()[0] ? this.value : (ByteBuffer)this.defaultValue(this.fields()[0]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

