/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class HoodieCleanPartitionMetadata
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 2969629020681825222L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieCleanPartitionMetadata\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"partitionPath\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"policy\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"deletePathPatterns\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}},{\"name\":\"successDeleteFiles\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}},{\"name\":\"failedDeleteFiles\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}},{\"name\":\"isPartitionDeleted\",\"type\":[\"null\",\"boolean\"],\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieCleanPartitionMetadata> ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HoodieCleanPartitionMetadata> DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
    private String partitionPath;
    private String policy;
    private List<String> deletePathPatterns;
    private List<String> successDeleteFiles;
    private List<String> failedDeleteFiles;
    private Boolean isPartitionDeleted;
    private static final DatumWriter<HoodieCleanPartitionMetadata> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HoodieCleanPartitionMetadata> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieCleanPartitionMetadata> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieCleanPartitionMetadata> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieCleanPartitionMetadata> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder<HoodieCleanPartitionMetadata>(MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static HoodieCleanPartitionMetadata fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieCleanPartitionMetadata)DECODER.decode(b);
    }

    public HoodieCleanPartitionMetadata() {
    }

    public HoodieCleanPartitionMetadata(String partitionPath, String policy, List<String> deletePathPatterns, List<String> successDeleteFiles, List<String> failedDeleteFiles, Boolean isPartitionDeleted) {
        this.partitionPath = partitionPath;
        this.policy = policy;
        this.deletePathPatterns = deletePathPatterns;
        this.successDeleteFiles = successDeleteFiles;
        this.failedDeleteFiles = failedDeleteFiles;
        this.isPartitionDeleted = isPartitionDeleted;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.partitionPath;
            }
            case 1: {
                return this.policy;
            }
            case 2: {
                return this.deletePathPatterns;
            }
            case 3: {
                return this.successDeleteFiles;
            }
            case 4: {
                return this.failedDeleteFiles;
            }
            case 5: {
                return this.isPartitionDeleted;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.partitionPath = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.policy = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.deletePathPatterns = (List)value$;
                break;
            }
            case 3: {
                this.successDeleteFiles = (List)value$;
                break;
            }
            case 4: {
                this.failedDeleteFiles = (List)value$;
                break;
            }
            case 5: {
                this.isPartitionDeleted = (Boolean)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(String value) {
        this.partitionPath = value;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String value) {
        this.policy = value;
    }

    public List<String> getDeletePathPatterns() {
        return this.deletePathPatterns;
    }

    public void setDeletePathPatterns(List<String> value) {
        this.deletePathPatterns = value;
    }

    public List<String> getSuccessDeleteFiles() {
        return this.successDeleteFiles;
    }

    public void setSuccessDeleteFiles(List<String> value) {
        this.successDeleteFiles = value;
    }

    public List<String> getFailedDeleteFiles() {
        return this.failedDeleteFiles;
    }

    public void setFailedDeleteFiles(List<String> value) {
        this.failedDeleteFiles = value;
    }

    public Boolean getIsPartitionDeleted() {
        return this.isPartitionDeleted;
    }

    public void setIsPartitionDeleted(Boolean value) {
        this.isPartitionDeleted = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieCleanPartitionMetadata other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    @Override
    protected boolean hasCustomCoders() {
        return true;
    }

    @Override
    public void customEncode(Encoder out) throws IOException {
        out.writeString(this.partitionPath);
        out.writeString(this.policy);
        long size0 = this.deletePathPatterns.size();
        out.writeArrayStart();
        out.setItemCount(size0);
        long actualSize0 = 0L;
        for (String e0 : this.deletePathPatterns) {
            ++actualSize0;
            out.startItem();
            out.writeString(e0);
        }
        out.writeArrayEnd();
        if (actualSize0 != size0) {
            throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
        }
        long size1 = this.successDeleteFiles.size();
        out.writeArrayStart();
        out.setItemCount(size1);
        long actualSize1 = 0L;
        for (String e1 : this.successDeleteFiles) {
            ++actualSize1;
            out.startItem();
            out.writeString(e1);
        }
        out.writeArrayEnd();
        if (actualSize1 != size1) {
            throw new ConcurrentModificationException("Array-size written was " + size1 + ", but element count was " + actualSize1 + ".");
        }
        long size2 = this.failedDeleteFiles.size();
        out.writeArrayStart();
        out.setItemCount(size2);
        long actualSize2 = 0L;
        for (String e2 : this.failedDeleteFiles) {
            ++actualSize2;
            out.startItem();
            out.writeString(e2);
        }
        out.writeArrayEnd();
        if (actualSize2 != size2) {
            throw new ConcurrentModificationException("Array-size written was " + size2 + ", but element count was " + actualSize2 + ".");
        }
        if (this.isPartitionDeleted == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBoolean(this.isPartitionDeleted);
        }
    }

    @Override
    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            GenericData.Array ga2;
            GenericData.Array ga1;
            GenericData.Array ga0;
            this.partitionPath = in.readString();
            this.policy = in.readString();
            long size0 = in.readArrayStart();
            List<String> a0 = this.deletePathPatterns;
            if (a0 == null) {
                this.deletePathPatterns = a0 = new GenericData.Array<String>((int)size0, SCHEMA$.getField("deletePathPatterns").schema());
            } else {
                a0.clear();
            }
            GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
            while (0L < size0) {
                while (size0 != 0L) {
                    String e0 = ga0 != null ? (String)ga0.peek() : null;
                    e0 = in.readString();
                    a0.add(e0);
                    --size0;
                }
                size0 = in.arrayNext();
            }
            long size1 = in.readArrayStart();
            List<String> a1 = this.successDeleteFiles;
            if (a1 == null) {
                this.successDeleteFiles = a1 = new GenericData.Array<String>((int)size1, SCHEMA$.getField("successDeleteFiles").schema());
            } else {
                a1.clear();
            }
            GenericData.Array array2 = ga1 = a1 instanceof GenericData.Array ? (GenericData.Array)a1 : null;
            while (0L < size1) {
                while (size1 != 0L) {
                    String e1 = ga1 != null ? (String)ga1.peek() : null;
                    e1 = in.readString();
                    a1.add(e1);
                    --size1;
                }
                size1 = in.arrayNext();
            }
            long size2 = in.readArrayStart();
            List<String> a2 = this.failedDeleteFiles;
            if (a2 == null) {
                this.failedDeleteFiles = a2 = new GenericData.Array<String>((int)size2, SCHEMA$.getField("failedDeleteFiles").schema());
            } else {
                a2.clear();
            }
            GenericData.Array array3 = ga2 = a2 instanceof GenericData.Array ? (GenericData.Array)a2 : null;
            while (0L < size2) {
                while (size2 != 0L) {
                    String e2 = ga2 != null ? (String)ga2.peek() : null;
                    e2 = in.readString();
                    a2.add(e2);
                    --size2;
                }
                size2 = in.arrayNext();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.isPartitionDeleted = null;
            } else {
                this.isPartitionDeleted = in.readBoolean();
            }
        } else {
            block14: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.partitionPath = in.readString();
                        continue block14;
                    }
                    case 1: {
                        this.policy = in.readString();
                        continue block14;
                    }
                    case 2: {
                        GenericData.Array ga0;
                        long size0 = in.readArrayStart();
                        List<String> a0 = this.deletePathPatterns;
                        if (a0 == null) {
                            this.deletePathPatterns = a0 = new GenericData.Array<String>((int)size0, SCHEMA$.getField("deletePathPatterns").schema());
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                String e0 = ga0 != null ? (String)ga0.peek() : null;
                                e0 = in.readString();
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block14;
                    }
                    case 3: {
                        GenericData.Array ga1;
                        long size1 = in.readArrayStart();
                        List<String> a1 = this.successDeleteFiles;
                        if (a1 == null) {
                            this.successDeleteFiles = a1 = new GenericData.Array<String>((int)size1, SCHEMA$.getField("successDeleteFiles").schema());
                        } else {
                            a1.clear();
                        }
                        GenericData.Array array = ga1 = a1 instanceof GenericData.Array ? (GenericData.Array)a1 : null;
                        while (0L < size1) {
                            while (size1 != 0L) {
                                String e1 = ga1 != null ? (String)ga1.peek() : null;
                                e1 = in.readString();
                                a1.add(e1);
                                --size1;
                            }
                            size1 = in.arrayNext();
                        }
                        continue block14;
                    }
                    case 4: {
                        GenericData.Array ga2;
                        long size2 = in.readArrayStart();
                        List<String> a2 = this.failedDeleteFiles;
                        if (a2 == null) {
                            this.failedDeleteFiles = a2 = new GenericData.Array<String>((int)size2, SCHEMA$.getField("failedDeleteFiles").schema());
                        } else {
                            a2.clear();
                        }
                        GenericData.Array array = ga2 = a2 instanceof GenericData.Array ? (GenericData.Array)a2 : null;
                        while (0L < size2) {
                            while (size2 != 0L) {
                                String e2 = ga2 != null ? (String)ga2.peek() : null;
                                e2 = in.readString();
                                a2.add(e2);
                                --size2;
                            }
                            size2 = in.arrayNext();
                        }
                        continue block14;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.isPartitionDeleted = null;
                            continue block14;
                        }
                        this.isPartitionDeleted = in.readBoolean();
                        continue block14;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieCleanPartitionMetadata>
    implements RecordBuilder<HoodieCleanPartitionMetadata> {
        private String partitionPath;
        private String policy;
        private List<String> deletePathPatterns;
        private List<String> successDeleteFiles;
        private List<String> failedDeleteFiles;
        private Boolean isPartitionDeleted;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.partitionPath)) {
                this.partitionPath = this.data().deepCopy(this.fields()[0].schema(), other.partitionPath);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue(this.fields()[1], other.policy)) {
                this.policy = this.data().deepCopy(this.fields()[1].schema(), other.policy);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue(this.fields()[2], other.deletePathPatterns)) {
                this.deletePathPatterns = this.data().deepCopy(this.fields()[2].schema(), other.deletePathPatterns);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue(this.fields()[3], other.successDeleteFiles)) {
                this.successDeleteFiles = this.data().deepCopy(this.fields()[3].schema(), other.successDeleteFiles);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue(this.fields()[4], other.failedDeleteFiles)) {
                this.failedDeleteFiles = this.data().deepCopy(this.fields()[4].schema(), other.failedDeleteFiles);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue(this.fields()[5], other.isPartitionDeleted)) {
                this.isPartitionDeleted = this.data().deepCopy(this.fields()[5].schema(), other.isPartitionDeleted);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(HoodieCleanPartitionMetadata other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue(this.fields()[0], other.partitionPath)) {
                this.partitionPath = this.data().deepCopy(this.fields()[0].schema(), other.partitionPath);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue(this.fields()[1], other.policy)) {
                this.policy = this.data().deepCopy(this.fields()[1].schema(), other.policy);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue(this.fields()[2], other.deletePathPatterns)) {
                this.deletePathPatterns = this.data().deepCopy(this.fields()[2].schema(), other.deletePathPatterns);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue(this.fields()[3], other.successDeleteFiles)) {
                this.successDeleteFiles = this.data().deepCopy(this.fields()[3].schema(), other.successDeleteFiles);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue(this.fields()[4], other.failedDeleteFiles)) {
                this.failedDeleteFiles = this.data().deepCopy(this.fields()[4].schema(), other.failedDeleteFiles);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue(this.fields()[5], other.isPartitionDeleted)) {
                this.isPartitionDeleted = this.data().deepCopy(this.fields()[5].schema(), other.isPartitionDeleted);
                this.fieldSetFlags()[5] = true;
            }
        }

        public String getPartitionPath() {
            return this.partitionPath;
        }

        public Builder setPartitionPath(String value) {
            this.validate(this.fields()[0], value);
            this.partitionPath = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasPartitionPath() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearPartitionPath() {
            this.partitionPath = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getPolicy() {
            return this.policy;
        }

        public Builder setPolicy(String value) {
            this.validate(this.fields()[1], value);
            this.policy = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasPolicy() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearPolicy() {
            this.policy = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public List<String> getDeletePathPatterns() {
            return this.deletePathPatterns;
        }

        public Builder setDeletePathPatterns(List<String> value) {
            this.validate(this.fields()[2], value);
            this.deletePathPatterns = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasDeletePathPatterns() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearDeletePathPatterns() {
            this.deletePathPatterns = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public List<String> getSuccessDeleteFiles() {
            return this.successDeleteFiles;
        }

        public Builder setSuccessDeleteFiles(List<String> value) {
            this.validate(this.fields()[3], value);
            this.successDeleteFiles = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasSuccessDeleteFiles() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearSuccessDeleteFiles() {
            this.successDeleteFiles = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public List<String> getFailedDeleteFiles() {
            return this.failedDeleteFiles;
        }

        public Builder setFailedDeleteFiles(List<String> value) {
            this.validate(this.fields()[4], value);
            this.failedDeleteFiles = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasFailedDeleteFiles() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearFailedDeleteFiles() {
            this.failedDeleteFiles = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Boolean getIsPartitionDeleted() {
            return this.isPartitionDeleted;
        }

        public Builder setIsPartitionDeleted(Boolean value) {
            this.validate(this.fields()[5], value);
            this.isPartitionDeleted = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasIsPartitionDeleted() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearIsPartitionDeleted() {
            this.isPartitionDeleted = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        @Override
        public HoodieCleanPartitionMetadata build() {
            try {
                HoodieCleanPartitionMetadata record = new HoodieCleanPartitionMetadata();
                record.partitionPath = this.fieldSetFlags()[0] ? this.partitionPath : (String)this.defaultValue(this.fields()[0]);
                record.policy = this.fieldSetFlags()[1] ? this.policy : (String)this.defaultValue(this.fields()[1]);
                record.deletePathPatterns = this.fieldSetFlags()[2] ? this.deletePathPatterns : (List)this.defaultValue(this.fields()[2]);
                record.successDeleteFiles = this.fieldSetFlags()[3] ? this.successDeleteFiles : (List)this.defaultValue(this.fields()[3]);
                record.failedDeleteFiles = this.fieldSetFlags()[4] ? this.failedDeleteFiles : (List)this.defaultValue(this.fields()[4]);
                record.isPartitionDeleted = this.fieldSetFlags()[5] ? this.isPartitionDeleted : (Boolean)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

