/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class HoodieIndexPartitionInfo
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 3465166363103761429L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieIndexPartitionInfo\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1},{\"name\":\"metadataPartitionPath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"indexUptoInstant\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"extraMetadata\",\"type\":[\"null\",{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"}],\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieIndexPartitionInfo> ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HoodieIndexPartitionInfo> DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
    private Integer version;
    private String metadataPartitionPath;
    private String indexUptoInstant;
    private Map<String, String> extraMetadata;
    private static final DatumWriter<HoodieIndexPartitionInfo> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HoodieIndexPartitionInfo> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieIndexPartitionInfo> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieIndexPartitionInfo> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieIndexPartitionInfo> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder<HoodieIndexPartitionInfo>(MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static HoodieIndexPartitionInfo fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieIndexPartitionInfo)DECODER.decode(b);
    }

    public HoodieIndexPartitionInfo() {
    }

    public HoodieIndexPartitionInfo(Integer version, String metadataPartitionPath, String indexUptoInstant, Map<String, String> extraMetadata) {
        this.version = version;
        this.metadataPartitionPath = metadataPartitionPath;
        this.indexUptoInstant = indexUptoInstant;
        this.extraMetadata = extraMetadata;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.version;
            }
            case 1: {
                return this.metadataPartitionPath;
            }
            case 2: {
                return this.indexUptoInstant;
            }
            case 3: {
                return this.extraMetadata;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.version = (Integer)value$;
                break;
            }
            case 1: {
                this.metadataPartitionPath = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.indexUptoInstant = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.extraMetadata = (Map)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer value) {
        this.version = value;
    }

    public String getMetadataPartitionPath() {
        return this.metadataPartitionPath;
    }

    public void setMetadataPartitionPath(String value) {
        this.metadataPartitionPath = value;
    }

    public String getIndexUptoInstant() {
        return this.indexUptoInstant;
    }

    public void setIndexUptoInstant(String value) {
        this.indexUptoInstant = value;
    }

    public Map<String, String> getExtraMetadata() {
        return this.extraMetadata;
    }

    public void setExtraMetadata(Map<String, String> value) {
        this.extraMetadata = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieIndexPartitionInfo other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    @Override
    protected boolean hasCustomCoders() {
        return true;
    }

    @Override
    public void customEncode(Encoder out) throws IOException {
        if (this.version == null) {
            out.writeIndex(1);
            out.writeNull();
        } else {
            out.writeIndex(0);
            out.writeInt(this.version);
        }
        if (this.metadataPartitionPath == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.metadataPartitionPath);
        }
        if (this.indexUptoInstant == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.indexUptoInstant);
        }
        if (this.extraMetadata == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size0 = this.extraMetadata.size();
            out.writeMapStart();
            out.setItemCount(size0);
            long actualSize0 = 0L;
            for (Map.Entry<String, String> e0 : this.extraMetadata.entrySet()) {
                ++actualSize0;
                out.startItem();
                out.writeString(e0.getKey());
                String v0 = e0.getValue();
                out.writeString(v0);
            }
            out.writeMapEnd();
            if (actualSize0 != size0) {
                throw new ConcurrentModificationException("Map-size written was " + size0 + ", but element count was " + actualSize0 + ".");
            }
        }
    }

    @Override
    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (in.readIndex() != 0) {
                in.readNull();
                this.version = null;
            } else {
                this.version = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.metadataPartitionPath = null;
            } else {
                this.metadataPartitionPath = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.indexUptoInstant = null;
            } else {
                this.indexUptoInstant = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.extraMetadata = null;
            } else {
                long size0 = in.readMapStart();
                Map<String, String> m0 = this.extraMetadata;
                if (m0 == null) {
                    this.extraMetadata = m0 = new HashMap<String, String>((int)size0);
                } else {
                    m0.clear();
                }
                while (0L < size0) {
                    while (size0 != 0L) {
                        String k0 = null;
                        k0 = in.readString();
                        String v0 = null;
                        v0 = in.readString();
                        m0.put(k0, v0);
                        --size0;
                    }
                    size0 = in.mapNext();
                }
            }
        } else {
            block8: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        if (in.readIndex() != 0) {
                            in.readNull();
                            this.version = null;
                            continue block8;
                        }
                        this.version = in.readInt();
                        continue block8;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.metadataPartitionPath = null;
                            continue block8;
                        }
                        this.metadataPartitionPath = in.readString();
                        continue block8;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.indexUptoInstant = null;
                            continue block8;
                        }
                        this.indexUptoInstant = in.readString();
                        continue block8;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.extraMetadata = null;
                            continue block8;
                        }
                        long size0 = in.readMapStart();
                        Map<String, String> m0 = this.extraMetadata;
                        if (m0 == null) {
                            this.extraMetadata = m0 = new HashMap<String, String>((int)size0);
                        } else {
                            m0.clear();
                        }
                        while (0L < size0) {
                            while (size0 != 0L) {
                                String k0 = null;
                                k0 = in.readString();
                                String v0 = null;
                                v0 = in.readString();
                                m0.put(k0, v0);
                                --size0;
                            }
                            size0 = in.mapNext();
                        }
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieIndexPartitionInfo>
    implements RecordBuilder<HoodieIndexPartitionInfo> {
        private Integer version;
        private String metadataPartitionPath;
        private String indexUptoInstant;
        private Map<String, String> extraMetadata;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.version)) {
                this.version = this.data().deepCopy(this.fields()[0].schema(), other.version);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue(this.fields()[1], other.metadataPartitionPath)) {
                this.metadataPartitionPath = this.data().deepCopy(this.fields()[1].schema(), other.metadataPartitionPath);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue(this.fields()[2], other.indexUptoInstant)) {
                this.indexUptoInstant = this.data().deepCopy(this.fields()[2].schema(), other.indexUptoInstant);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue(this.fields()[3], other.extraMetadata)) {
                this.extraMetadata = this.data().deepCopy(this.fields()[3].schema(), other.extraMetadata);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(HoodieIndexPartitionInfo other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue(this.fields()[0], other.version)) {
                this.version = this.data().deepCopy(this.fields()[0].schema(), other.version);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue(this.fields()[1], other.metadataPartitionPath)) {
                this.metadataPartitionPath = this.data().deepCopy(this.fields()[1].schema(), other.metadataPartitionPath);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue(this.fields()[2], other.indexUptoInstant)) {
                this.indexUptoInstant = this.data().deepCopy(this.fields()[2].schema(), other.indexUptoInstant);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue(this.fields()[3], other.extraMetadata)) {
                this.extraMetadata = this.data().deepCopy(this.fields()[3].schema(), other.extraMetadata);
                this.fieldSetFlags()[3] = true;
            }
        }

        public Integer getVersion() {
            return this.version;
        }

        public Builder setVersion(Integer value) {
            this.validate(this.fields()[0], value);
            this.version = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasVersion() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearVersion() {
            this.version = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getMetadataPartitionPath() {
            return this.metadataPartitionPath;
        }

        public Builder setMetadataPartitionPath(String value) {
            this.validate(this.fields()[1], value);
            this.metadataPartitionPath = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasMetadataPartitionPath() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearMetadataPartitionPath() {
            this.metadataPartitionPath = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getIndexUptoInstant() {
            return this.indexUptoInstant;
        }

        public Builder setIndexUptoInstant(String value) {
            this.validate(this.fields()[2], value);
            this.indexUptoInstant = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasIndexUptoInstant() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearIndexUptoInstant() {
            this.indexUptoInstant = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Map<String, String> getExtraMetadata() {
            return this.extraMetadata;
        }

        public Builder setExtraMetadata(Map<String, String> value) {
            this.validate(this.fields()[3], value);
            this.extraMetadata = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasExtraMetadata() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearExtraMetadata() {
            this.extraMetadata = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        @Override
        public HoodieIndexPartitionInfo build() {
            try {
                HoodieIndexPartitionInfo record = new HoodieIndexPartitionInfo();
                record.version = this.fieldSetFlags()[0] ? this.version : (Integer)this.defaultValue(this.fields()[0]);
                record.metadataPartitionPath = this.fieldSetFlags()[1] ? this.metadataPartitionPath : (String)this.defaultValue(this.fields()[1]);
                record.indexUptoInstant = this.fieldSetFlags()[2] ? this.indexUptoInstant : (String)this.defaultValue(this.fields()[2]);
                record.extraMetadata = this.fieldSetFlags()[3] ? this.extraMetadata : (Map)this.defaultValue(this.fields()[3]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

