/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class HoodieWriteStat
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -7657389832893929925L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieWriteStat\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"fileId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"path\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"prevCommit\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"numWrites\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"numDeletes\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"numUpdateWrites\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"totalWriteBytes\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"totalWriteErrors\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"partitionPath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"totalLogRecords\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"totalLogFiles\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"totalUpdatedRecordsCompacted\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"numInserts\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"totalLogBlocks\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"totalCorruptLogBlock\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"totalRollbackBlocks\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"fileSizeInBytes\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"logVersion\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"logOffset\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"baseFile\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"logFiles\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"default\":null}],\"default\":null},{\"name\":\"cdcStats\",\"type\":[\"null\",{\"type\":\"map\",\"values\":\"long\",\"avro.java.string\":\"String\",\"default\":null}],\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieWriteStat> ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HoodieWriteStat> DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
    private String fileId;
    private String path;
    private String prevCommit;
    private Long numWrites;
    private Long numDeletes;
    private Long numUpdateWrites;
    private Long totalWriteBytes;
    private Long totalWriteErrors;
    private String partitionPath;
    private Long totalLogRecords;
    private Long totalLogFiles;
    private Long totalUpdatedRecordsCompacted;
    private Long numInserts;
    private Long totalLogBlocks;
    private Long totalCorruptLogBlock;
    private Long totalRollbackBlocks;
    private Long fileSizeInBytes;
    private Integer logVersion;
    private Long logOffset;
    private String baseFile;
    private List<String> logFiles;
    private Map<String, Long> cdcStats;
    private static final DatumWriter<HoodieWriteStat> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HoodieWriteStat> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieWriteStat> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieWriteStat> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieWriteStat> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder<HoodieWriteStat>(MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static HoodieWriteStat fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieWriteStat)DECODER.decode(b);
    }

    public HoodieWriteStat() {
    }

    public HoodieWriteStat(String fileId, String path, String prevCommit, Long numWrites, Long numDeletes, Long numUpdateWrites, Long totalWriteBytes, Long totalWriteErrors, String partitionPath, Long totalLogRecords, Long totalLogFiles, Long totalUpdatedRecordsCompacted, Long numInserts, Long totalLogBlocks, Long totalCorruptLogBlock, Long totalRollbackBlocks, Long fileSizeInBytes, Integer logVersion, Long logOffset, String baseFile, List<String> logFiles, Map<String, Long> cdcStats) {
        this.fileId = fileId;
        this.path = path;
        this.prevCommit = prevCommit;
        this.numWrites = numWrites;
        this.numDeletes = numDeletes;
        this.numUpdateWrites = numUpdateWrites;
        this.totalWriteBytes = totalWriteBytes;
        this.totalWriteErrors = totalWriteErrors;
        this.partitionPath = partitionPath;
        this.totalLogRecords = totalLogRecords;
        this.totalLogFiles = totalLogFiles;
        this.totalUpdatedRecordsCompacted = totalUpdatedRecordsCompacted;
        this.numInserts = numInserts;
        this.totalLogBlocks = totalLogBlocks;
        this.totalCorruptLogBlock = totalCorruptLogBlock;
        this.totalRollbackBlocks = totalRollbackBlocks;
        this.fileSizeInBytes = fileSizeInBytes;
        this.logVersion = logVersion;
        this.logOffset = logOffset;
        this.baseFile = baseFile;
        this.logFiles = logFiles;
        this.cdcStats = cdcStats;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.fileId;
            }
            case 1: {
                return this.path;
            }
            case 2: {
                return this.prevCommit;
            }
            case 3: {
                return this.numWrites;
            }
            case 4: {
                return this.numDeletes;
            }
            case 5: {
                return this.numUpdateWrites;
            }
            case 6: {
                return this.totalWriteBytes;
            }
            case 7: {
                return this.totalWriteErrors;
            }
            case 8: {
                return this.partitionPath;
            }
            case 9: {
                return this.totalLogRecords;
            }
            case 10: {
                return this.totalLogFiles;
            }
            case 11: {
                return this.totalUpdatedRecordsCompacted;
            }
            case 12: {
                return this.numInserts;
            }
            case 13: {
                return this.totalLogBlocks;
            }
            case 14: {
                return this.totalCorruptLogBlock;
            }
            case 15: {
                return this.totalRollbackBlocks;
            }
            case 16: {
                return this.fileSizeInBytes;
            }
            case 17: {
                return this.logVersion;
            }
            case 18: {
                return this.logOffset;
            }
            case 19: {
                return this.baseFile;
            }
            case 20: {
                return this.logFiles;
            }
            case 21: {
                return this.cdcStats;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.fileId = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.path = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.prevCommit = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.numWrites = (Long)value$;
                break;
            }
            case 4: {
                this.numDeletes = (Long)value$;
                break;
            }
            case 5: {
                this.numUpdateWrites = (Long)value$;
                break;
            }
            case 6: {
                this.totalWriteBytes = (Long)value$;
                break;
            }
            case 7: {
                this.totalWriteErrors = (Long)value$;
                break;
            }
            case 8: {
                this.partitionPath = value$ != null ? value$.toString() : null;
                break;
            }
            case 9: {
                this.totalLogRecords = (Long)value$;
                break;
            }
            case 10: {
                this.totalLogFiles = (Long)value$;
                break;
            }
            case 11: {
                this.totalUpdatedRecordsCompacted = (Long)value$;
                break;
            }
            case 12: {
                this.numInserts = (Long)value$;
                break;
            }
            case 13: {
                this.totalLogBlocks = (Long)value$;
                break;
            }
            case 14: {
                this.totalCorruptLogBlock = (Long)value$;
                break;
            }
            case 15: {
                this.totalRollbackBlocks = (Long)value$;
                break;
            }
            case 16: {
                this.fileSizeInBytes = (Long)value$;
                break;
            }
            case 17: {
                this.logVersion = (Integer)value$;
                break;
            }
            case 18: {
                this.logOffset = (Long)value$;
                break;
            }
            case 19: {
                this.baseFile = value$ != null ? value$.toString() : null;
                break;
            }
            case 20: {
                this.logFiles = (List)value$;
                break;
            }
            case 21: {
                this.cdcStats = (Map)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String value) {
        this.fileId = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String value) {
        this.path = value;
    }

    public String getPrevCommit() {
        return this.prevCommit;
    }

    public void setPrevCommit(String value) {
        this.prevCommit = value;
    }

    public Long getNumWrites() {
        return this.numWrites;
    }

    public void setNumWrites(Long value) {
        this.numWrites = value;
    }

    public Long getNumDeletes() {
        return this.numDeletes;
    }

    public void setNumDeletes(Long value) {
        this.numDeletes = value;
    }

    public Long getNumUpdateWrites() {
        return this.numUpdateWrites;
    }

    public void setNumUpdateWrites(Long value) {
        this.numUpdateWrites = value;
    }

    public Long getTotalWriteBytes() {
        return this.totalWriteBytes;
    }

    public void setTotalWriteBytes(Long value) {
        this.totalWriteBytes = value;
    }

    public Long getTotalWriteErrors() {
        return this.totalWriteErrors;
    }

    public void setTotalWriteErrors(Long value) {
        this.totalWriteErrors = value;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(String value) {
        this.partitionPath = value;
    }

    public Long getTotalLogRecords() {
        return this.totalLogRecords;
    }

    public void setTotalLogRecords(Long value) {
        this.totalLogRecords = value;
    }

    public Long getTotalLogFiles() {
        return this.totalLogFiles;
    }

    public void setTotalLogFiles(Long value) {
        this.totalLogFiles = value;
    }

    public Long getTotalUpdatedRecordsCompacted() {
        return this.totalUpdatedRecordsCompacted;
    }

    public void setTotalUpdatedRecordsCompacted(Long value) {
        this.totalUpdatedRecordsCompacted = value;
    }

    public Long getNumInserts() {
        return this.numInserts;
    }

    public void setNumInserts(Long value) {
        this.numInserts = value;
    }

    public Long getTotalLogBlocks() {
        return this.totalLogBlocks;
    }

    public void setTotalLogBlocks(Long value) {
        this.totalLogBlocks = value;
    }

    public Long getTotalCorruptLogBlock() {
        return this.totalCorruptLogBlock;
    }

    public void setTotalCorruptLogBlock(Long value) {
        this.totalCorruptLogBlock = value;
    }

    public Long getTotalRollbackBlocks() {
        return this.totalRollbackBlocks;
    }

    public void setTotalRollbackBlocks(Long value) {
        this.totalRollbackBlocks = value;
    }

    public Long getFileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public void setFileSizeInBytes(Long value) {
        this.fileSizeInBytes = value;
    }

    public Integer getLogVersion() {
        return this.logVersion;
    }

    public void setLogVersion(Integer value) {
        this.logVersion = value;
    }

    public Long getLogOffset() {
        return this.logOffset;
    }

    public void setLogOffset(Long value) {
        this.logOffset = value;
    }

    public String getBaseFile() {
        return this.baseFile;
    }

    public void setBaseFile(String value) {
        this.baseFile = value;
    }

    public List<String> getLogFiles() {
        return this.logFiles;
    }

    public void setLogFiles(List<String> value) {
        this.logFiles = value;
    }

    public Map<String, Long> getCdcStats() {
        return this.cdcStats;
    }

    public void setCdcStats(Map<String, Long> value) {
        this.cdcStats = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieWriteStat other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    @Override
    protected boolean hasCustomCoders() {
        return true;
    }

    @Override
    public void customEncode(Encoder out) throws IOException {
        if (this.fileId == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.fileId);
        }
        if (this.path == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.path);
        }
        if (this.prevCommit == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.prevCommit);
        }
        if (this.numWrites == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.numWrites);
        }
        if (this.numDeletes == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.numDeletes);
        }
        if (this.numUpdateWrites == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.numUpdateWrites);
        }
        if (this.totalWriteBytes == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.totalWriteBytes);
        }
        if (this.totalWriteErrors == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.totalWriteErrors);
        }
        if (this.partitionPath == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.partitionPath);
        }
        if (this.totalLogRecords == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.totalLogRecords);
        }
        if (this.totalLogFiles == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.totalLogFiles);
        }
        if (this.totalUpdatedRecordsCompacted == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.totalUpdatedRecordsCompacted);
        }
        if (this.numInserts == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.numInserts);
        }
        if (this.totalLogBlocks == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.totalLogBlocks);
        }
        if (this.totalCorruptLogBlock == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.totalCorruptLogBlock);
        }
        if (this.totalRollbackBlocks == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.totalRollbackBlocks);
        }
        if (this.fileSizeInBytes == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.fileSizeInBytes);
        }
        if (this.logVersion == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.logVersion);
        }
        if (this.logOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.logOffset);
        }
        if (this.baseFile == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.baseFile);
        }
        if (this.logFiles == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size0 = this.logFiles.size();
            out.writeArrayStart();
            out.setItemCount(size0);
            long actualSize0 = 0L;
            for (String string : this.logFiles) {
                ++actualSize0;
                out.startItem();
                out.writeString(string);
            }
            out.writeArrayEnd();
            if (actualSize0 != size0) {
                throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
            }
        }
        if (this.cdcStats == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size1 = this.cdcStats.size();
            out.writeMapStart();
            out.setItemCount(size1);
            long actualSize1 = 0L;
            for (Map.Entry entry : this.cdcStats.entrySet()) {
                ++actualSize1;
                out.startItem();
                out.writeString((String)entry.getKey());
                Long v1 = (Long)entry.getValue();
                out.writeLong(v1);
            }
            out.writeMapEnd();
            if (actualSize1 != size1) {
                throw new ConcurrentModificationException("Map-size written was " + size1 + ", but element count was " + actualSize1 + ".");
            }
        }
    }

    @Override
    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (in.readIndex() != 1) {
                in.readNull();
                this.fileId = null;
            } else {
                this.fileId = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.path = null;
            } else {
                this.path = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.prevCommit = null;
            } else {
                this.prevCommit = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.numWrites = null;
            } else {
                this.numWrites = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.numDeletes = null;
            } else {
                this.numDeletes = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.numUpdateWrites = null;
            } else {
                this.numUpdateWrites = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalWriteBytes = null;
            } else {
                this.totalWriteBytes = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalWriteErrors = null;
            } else {
                this.totalWriteErrors = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.partitionPath = null;
            } else {
                this.partitionPath = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalLogRecords = null;
            } else {
                this.totalLogRecords = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalLogFiles = null;
            } else {
                this.totalLogFiles = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalUpdatedRecordsCompacted = null;
            } else {
                this.totalUpdatedRecordsCompacted = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.numInserts = null;
            } else {
                this.numInserts = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalLogBlocks = null;
            } else {
                this.totalLogBlocks = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalCorruptLogBlock = null;
            } else {
                this.totalCorruptLogBlock = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalRollbackBlocks = null;
            } else {
                this.totalRollbackBlocks = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fileSizeInBytes = null;
            } else {
                this.fileSizeInBytes = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.logVersion = null;
            } else {
                this.logVersion = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.logOffset = null;
            } else {
                this.logOffset = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.baseFile = null;
            } else {
                this.baseFile = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.logFiles = null;
            } else {
                GenericData.Array ga0;
                long size0 = in.readArrayStart();
                List<String> a0 = this.logFiles;
                if (a0 == null) {
                    this.logFiles = a0 = new GenericData.Array<String>((int)size0, SCHEMA$.getField("logFiles").schema().getTypes().get(1));
                } else {
                    a0.clear();
                }
                GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                while (0L < size0) {
                    while (size0 != 0L) {
                        String e0 = ga0 != null ? (String)ga0.peek() : null;
                        e0 = in.readString();
                        a0.add(e0);
                        --size0;
                    }
                    size0 = in.arrayNext();
                }
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.cdcStats = null;
            } else {
                long size1 = in.readMapStart();
                Map<String, Long> m1 = this.cdcStats;
                if (m1 == null) {
                    this.cdcStats = m1 = new HashMap<String, Long>((int)size1);
                } else {
                    m1.clear();
                }
                while (0L < size1) {
                    while (size1 != 0L) {
                        String k1 = null;
                        k1 = in.readString();
                        Long v1 = null;
                        v1 = in.readLong();
                        m1.put(k1, v1);
                        --size1;
                    }
                    size1 = in.mapNext();
                }
            }
        } else {
            block28: for (int i = 0; i < 22; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fileId = null;
                            continue block28;
                        }
                        this.fileId = in.readString();
                        continue block28;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.path = null;
                            continue block28;
                        }
                        this.path = in.readString();
                        continue block28;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.prevCommit = null;
                            continue block28;
                        }
                        this.prevCommit = in.readString();
                        continue block28;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.numWrites = null;
                            continue block28;
                        }
                        this.numWrites = in.readLong();
                        continue block28;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.numDeletes = null;
                            continue block28;
                        }
                        this.numDeletes = in.readLong();
                        continue block28;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.numUpdateWrites = null;
                            continue block28;
                        }
                        this.numUpdateWrites = in.readLong();
                        continue block28;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalWriteBytes = null;
                            continue block28;
                        }
                        this.totalWriteBytes = in.readLong();
                        continue block28;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalWriteErrors = null;
                            continue block28;
                        }
                        this.totalWriteErrors = in.readLong();
                        continue block28;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.partitionPath = null;
                            continue block28;
                        }
                        this.partitionPath = in.readString();
                        continue block28;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalLogRecords = null;
                            continue block28;
                        }
                        this.totalLogRecords = in.readLong();
                        continue block28;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalLogFiles = null;
                            continue block28;
                        }
                        this.totalLogFiles = in.readLong();
                        continue block28;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalUpdatedRecordsCompacted = null;
                            continue block28;
                        }
                        this.totalUpdatedRecordsCompacted = in.readLong();
                        continue block28;
                    }
                    case 12: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.numInserts = null;
                            continue block28;
                        }
                        this.numInserts = in.readLong();
                        continue block28;
                    }
                    case 13: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalLogBlocks = null;
                            continue block28;
                        }
                        this.totalLogBlocks = in.readLong();
                        continue block28;
                    }
                    case 14: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalCorruptLogBlock = null;
                            continue block28;
                        }
                        this.totalCorruptLogBlock = in.readLong();
                        continue block28;
                    }
                    case 15: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalRollbackBlocks = null;
                            continue block28;
                        }
                        this.totalRollbackBlocks = in.readLong();
                        continue block28;
                    }
                    case 16: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fileSizeInBytes = null;
                            continue block28;
                        }
                        this.fileSizeInBytes = in.readLong();
                        continue block28;
                    }
                    case 17: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.logVersion = null;
                            continue block28;
                        }
                        this.logVersion = in.readInt();
                        continue block28;
                    }
                    case 18: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.logOffset = null;
                            continue block28;
                        }
                        this.logOffset = in.readLong();
                        continue block28;
                    }
                    case 19: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.baseFile = null;
                            continue block28;
                        }
                        this.baseFile = in.readString();
                        continue block28;
                    }
                    case 20: {
                        GenericData.Array ga0;
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.logFiles = null;
                            continue block28;
                        }
                        long size0 = in.readArrayStart();
                        List<String> a0 = this.logFiles;
                        if (a0 == null) {
                            this.logFiles = a0 = new GenericData.Array<String>((int)size0, SCHEMA$.getField("logFiles").schema().getTypes().get(1));
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                String e0 = ga0 != null ? (String)ga0.peek() : null;
                                e0 = in.readString();
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block28;
                    }
                    case 21: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.cdcStats = null;
                            continue block28;
                        }
                        long size1 = in.readMapStart();
                        Map<String, Long> m1 = this.cdcStats;
                        if (m1 == null) {
                            this.cdcStats = m1 = new HashMap<String, Long>((int)size1);
                        } else {
                            m1.clear();
                        }
                        while (0L < size1) {
                            while (size1 != 0L) {
                                String k1 = null;
                                k1 = in.readString();
                                Long v1 = null;
                                v1 = in.readLong();
                                m1.put(k1, v1);
                                --size1;
                            }
                            size1 = in.mapNext();
                        }
                        continue block28;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieWriteStat>
    implements RecordBuilder<HoodieWriteStat> {
        private String fileId;
        private String path;
        private String prevCommit;
        private Long numWrites;
        private Long numDeletes;
        private Long numUpdateWrites;
        private Long totalWriteBytes;
        private Long totalWriteErrors;
        private String partitionPath;
        private Long totalLogRecords;
        private Long totalLogFiles;
        private Long totalUpdatedRecordsCompacted;
        private Long numInserts;
        private Long totalLogBlocks;
        private Long totalCorruptLogBlock;
        private Long totalRollbackBlocks;
        private Long fileSizeInBytes;
        private Integer logVersion;
        private Long logOffset;
        private String baseFile;
        private List<String> logFiles;
        private Map<String, Long> cdcStats;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.fileId)) {
                this.fileId = this.data().deepCopy(this.fields()[0].schema(), other.fileId);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue(this.fields()[1], other.path)) {
                this.path = this.data().deepCopy(this.fields()[1].schema(), other.path);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue(this.fields()[2], other.prevCommit)) {
                this.prevCommit = this.data().deepCopy(this.fields()[2].schema(), other.prevCommit);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue(this.fields()[3], other.numWrites)) {
                this.numWrites = this.data().deepCopy(this.fields()[3].schema(), other.numWrites);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue(this.fields()[4], other.numDeletes)) {
                this.numDeletes = this.data().deepCopy(this.fields()[4].schema(), other.numDeletes);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue(this.fields()[5], other.numUpdateWrites)) {
                this.numUpdateWrites = this.data().deepCopy(this.fields()[5].schema(), other.numUpdateWrites);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue(this.fields()[6], other.totalWriteBytes)) {
                this.totalWriteBytes = this.data().deepCopy(this.fields()[6].schema(), other.totalWriteBytes);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue(this.fields()[7], other.totalWriteErrors)) {
                this.totalWriteErrors = this.data().deepCopy(this.fields()[7].schema(), other.totalWriteErrors);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue(this.fields()[8], other.partitionPath)) {
                this.partitionPath = this.data().deepCopy(this.fields()[8].schema(), other.partitionPath);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue(this.fields()[9], other.totalLogRecords)) {
                this.totalLogRecords = this.data().deepCopy(this.fields()[9].schema(), other.totalLogRecords);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue(this.fields()[10], other.totalLogFiles)) {
                this.totalLogFiles = this.data().deepCopy(this.fields()[10].schema(), other.totalLogFiles);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue(this.fields()[11], other.totalUpdatedRecordsCompacted)) {
                this.totalUpdatedRecordsCompacted = this.data().deepCopy(this.fields()[11].schema(), other.totalUpdatedRecordsCompacted);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue(this.fields()[12], other.numInserts)) {
                this.numInserts = this.data().deepCopy(this.fields()[12].schema(), other.numInserts);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue(this.fields()[13], other.totalLogBlocks)) {
                this.totalLogBlocks = this.data().deepCopy(this.fields()[13].schema(), other.totalLogBlocks);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (Builder.isValidValue(this.fields()[14], other.totalCorruptLogBlock)) {
                this.totalCorruptLogBlock = this.data().deepCopy(this.fields()[14].schema(), other.totalCorruptLogBlock);
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (Builder.isValidValue(this.fields()[15], other.totalRollbackBlocks)) {
                this.totalRollbackBlocks = this.data().deepCopy(this.fields()[15].schema(), other.totalRollbackBlocks);
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (Builder.isValidValue(this.fields()[16], other.fileSizeInBytes)) {
                this.fileSizeInBytes = this.data().deepCopy(this.fields()[16].schema(), other.fileSizeInBytes);
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
            if (Builder.isValidValue(this.fields()[17], other.logVersion)) {
                this.logVersion = this.data().deepCopy(this.fields()[17].schema(), other.logVersion);
                this.fieldSetFlags()[17] = other.fieldSetFlags()[17];
            }
            if (Builder.isValidValue(this.fields()[18], other.logOffset)) {
                this.logOffset = this.data().deepCopy(this.fields()[18].schema(), other.logOffset);
                this.fieldSetFlags()[18] = other.fieldSetFlags()[18];
            }
            if (Builder.isValidValue(this.fields()[19], other.baseFile)) {
                this.baseFile = this.data().deepCopy(this.fields()[19].schema(), other.baseFile);
                this.fieldSetFlags()[19] = other.fieldSetFlags()[19];
            }
            if (Builder.isValidValue(this.fields()[20], other.logFiles)) {
                this.logFiles = this.data().deepCopy(this.fields()[20].schema(), other.logFiles);
                this.fieldSetFlags()[20] = other.fieldSetFlags()[20];
            }
            if (Builder.isValidValue(this.fields()[21], other.cdcStats)) {
                this.cdcStats = this.data().deepCopy(this.fields()[21].schema(), other.cdcStats);
                this.fieldSetFlags()[21] = other.fieldSetFlags()[21];
            }
        }

        private Builder(HoodieWriteStat other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue(this.fields()[0], other.fileId)) {
                this.fileId = this.data().deepCopy(this.fields()[0].schema(), other.fileId);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue(this.fields()[1], other.path)) {
                this.path = this.data().deepCopy(this.fields()[1].schema(), other.path);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue(this.fields()[2], other.prevCommit)) {
                this.prevCommit = this.data().deepCopy(this.fields()[2].schema(), other.prevCommit);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue(this.fields()[3], other.numWrites)) {
                this.numWrites = this.data().deepCopy(this.fields()[3].schema(), other.numWrites);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue(this.fields()[4], other.numDeletes)) {
                this.numDeletes = this.data().deepCopy(this.fields()[4].schema(), other.numDeletes);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue(this.fields()[5], other.numUpdateWrites)) {
                this.numUpdateWrites = this.data().deepCopy(this.fields()[5].schema(), other.numUpdateWrites);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue(this.fields()[6], other.totalWriteBytes)) {
                this.totalWriteBytes = this.data().deepCopy(this.fields()[6].schema(), other.totalWriteBytes);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue(this.fields()[7], other.totalWriteErrors)) {
                this.totalWriteErrors = this.data().deepCopy(this.fields()[7].schema(), other.totalWriteErrors);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue(this.fields()[8], other.partitionPath)) {
                this.partitionPath = this.data().deepCopy(this.fields()[8].schema(), other.partitionPath);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue(this.fields()[9], other.totalLogRecords)) {
                this.totalLogRecords = this.data().deepCopy(this.fields()[9].schema(), other.totalLogRecords);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue(this.fields()[10], other.totalLogFiles)) {
                this.totalLogFiles = this.data().deepCopy(this.fields()[10].schema(), other.totalLogFiles);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue(this.fields()[11], other.totalUpdatedRecordsCompacted)) {
                this.totalUpdatedRecordsCompacted = this.data().deepCopy(this.fields()[11].schema(), other.totalUpdatedRecordsCompacted);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue(this.fields()[12], other.numInserts)) {
                this.numInserts = this.data().deepCopy(this.fields()[12].schema(), other.numInserts);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue(this.fields()[13], other.totalLogBlocks)) {
                this.totalLogBlocks = this.data().deepCopy(this.fields()[13].schema(), other.totalLogBlocks);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue(this.fields()[14], other.totalCorruptLogBlock)) {
                this.totalCorruptLogBlock = this.data().deepCopy(this.fields()[14].schema(), other.totalCorruptLogBlock);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue(this.fields()[15], other.totalRollbackBlocks)) {
                this.totalRollbackBlocks = this.data().deepCopy(this.fields()[15].schema(), other.totalRollbackBlocks);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue(this.fields()[16], other.fileSizeInBytes)) {
                this.fileSizeInBytes = this.data().deepCopy(this.fields()[16].schema(), other.fileSizeInBytes);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue(this.fields()[17], other.logVersion)) {
                this.logVersion = this.data().deepCopy(this.fields()[17].schema(), other.logVersion);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue(this.fields()[18], other.logOffset)) {
                this.logOffset = this.data().deepCopy(this.fields()[18].schema(), other.logOffset);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue(this.fields()[19], other.baseFile)) {
                this.baseFile = this.data().deepCopy(this.fields()[19].schema(), other.baseFile);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue(this.fields()[20], other.logFiles)) {
                this.logFiles = this.data().deepCopy(this.fields()[20].schema(), other.logFiles);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue(this.fields()[21], other.cdcStats)) {
                this.cdcStats = this.data().deepCopy(this.fields()[21].schema(), other.cdcStats);
                this.fieldSetFlags()[21] = true;
            }
        }

        public String getFileId() {
            return this.fileId;
        }

        public Builder setFileId(String value) {
            this.validate(this.fields()[0], value);
            this.fileId = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasFileId() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearFileId() {
            this.fileId = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getPath() {
            return this.path;
        }

        public Builder setPath(String value) {
            this.validate(this.fields()[1], value);
            this.path = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasPath() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearPath() {
            this.path = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getPrevCommit() {
            return this.prevCommit;
        }

        public Builder setPrevCommit(String value) {
            this.validate(this.fields()[2], value);
            this.prevCommit = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasPrevCommit() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearPrevCommit() {
            this.prevCommit = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Long getNumWrites() {
            return this.numWrites;
        }

        public Builder setNumWrites(Long value) {
            this.validate(this.fields()[3], value);
            this.numWrites = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasNumWrites() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearNumWrites() {
            this.numWrites = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Long getNumDeletes() {
            return this.numDeletes;
        }

        public Builder setNumDeletes(Long value) {
            this.validate(this.fields()[4], value);
            this.numDeletes = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasNumDeletes() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearNumDeletes() {
            this.numDeletes = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Long getNumUpdateWrites() {
            return this.numUpdateWrites;
        }

        public Builder setNumUpdateWrites(Long value) {
            this.validate(this.fields()[5], value);
            this.numUpdateWrites = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasNumUpdateWrites() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearNumUpdateWrites() {
            this.numUpdateWrites = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Long getTotalWriteBytes() {
            return this.totalWriteBytes;
        }

        public Builder setTotalWriteBytes(Long value) {
            this.validate(this.fields()[6], value);
            this.totalWriteBytes = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasTotalWriteBytes() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearTotalWriteBytes() {
            this.totalWriteBytes = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Long getTotalWriteErrors() {
            return this.totalWriteErrors;
        }

        public Builder setTotalWriteErrors(Long value) {
            this.validate(this.fields()[7], value);
            this.totalWriteErrors = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasTotalWriteErrors() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearTotalWriteErrors() {
            this.totalWriteErrors = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public String getPartitionPath() {
            return this.partitionPath;
        }

        public Builder setPartitionPath(String value) {
            this.validate(this.fields()[8], value);
            this.partitionPath = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasPartitionPath() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearPartitionPath() {
            this.partitionPath = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Long getTotalLogRecords() {
            return this.totalLogRecords;
        }

        public Builder setTotalLogRecords(Long value) {
            this.validate(this.fields()[9], value);
            this.totalLogRecords = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasTotalLogRecords() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearTotalLogRecords() {
            this.totalLogRecords = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Long getTotalLogFiles() {
            return this.totalLogFiles;
        }

        public Builder setTotalLogFiles(Long value) {
            this.validate(this.fields()[10], value);
            this.totalLogFiles = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasTotalLogFiles() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearTotalLogFiles() {
            this.totalLogFiles = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Long getTotalUpdatedRecordsCompacted() {
            return this.totalUpdatedRecordsCompacted;
        }

        public Builder setTotalUpdatedRecordsCompacted(Long value) {
            this.validate(this.fields()[11], value);
            this.totalUpdatedRecordsCompacted = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasTotalUpdatedRecordsCompacted() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearTotalUpdatedRecordsCompacted() {
            this.totalUpdatedRecordsCompacted = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Long getNumInserts() {
            return this.numInserts;
        }

        public Builder setNumInserts(Long value) {
            this.validate(this.fields()[12], value);
            this.numInserts = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasNumInserts() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearNumInserts() {
            this.numInserts = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Long getTotalLogBlocks() {
            return this.totalLogBlocks;
        }

        public Builder setTotalLogBlocks(Long value) {
            this.validate(this.fields()[13], value);
            this.totalLogBlocks = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasTotalLogBlocks() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearTotalLogBlocks() {
            this.totalLogBlocks = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Long getTotalCorruptLogBlock() {
            return this.totalCorruptLogBlock;
        }

        public Builder setTotalCorruptLogBlock(Long value) {
            this.validate(this.fields()[14], value);
            this.totalCorruptLogBlock = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasTotalCorruptLogBlock() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearTotalCorruptLogBlock() {
            this.totalCorruptLogBlock = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Long getTotalRollbackBlocks() {
            return this.totalRollbackBlocks;
        }

        public Builder setTotalRollbackBlocks(Long value) {
            this.validate(this.fields()[15], value);
            this.totalRollbackBlocks = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasTotalRollbackBlocks() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearTotalRollbackBlocks() {
            this.totalRollbackBlocks = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Long getFileSizeInBytes() {
            return this.fileSizeInBytes;
        }

        public Builder setFileSizeInBytes(Long value) {
            this.validate(this.fields()[16], value);
            this.fileSizeInBytes = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasFileSizeInBytes() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearFileSizeInBytes() {
            this.fileSizeInBytes = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public Integer getLogVersion() {
            return this.logVersion;
        }

        public Builder setLogVersion(Integer value) {
            this.validate(this.fields()[17], value);
            this.logVersion = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasLogVersion() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearLogVersion() {
            this.logVersion = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public Long getLogOffset() {
            return this.logOffset;
        }

        public Builder setLogOffset(Long value) {
            this.validate(this.fields()[18], value);
            this.logOffset = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasLogOffset() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearLogOffset() {
            this.logOffset = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public String getBaseFile() {
            return this.baseFile;
        }

        public Builder setBaseFile(String value) {
            this.validate(this.fields()[19], value);
            this.baseFile = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasBaseFile() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearBaseFile() {
            this.baseFile = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public List<String> getLogFiles() {
            return this.logFiles;
        }

        public Builder setLogFiles(List<String> value) {
            this.validate(this.fields()[20], value);
            this.logFiles = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasLogFiles() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearLogFiles() {
            this.logFiles = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public Map<String, Long> getCdcStats() {
            return this.cdcStats;
        }

        public Builder setCdcStats(Map<String, Long> value) {
            this.validate(this.fields()[21], value);
            this.cdcStats = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasCdcStats() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearCdcStats() {
            this.cdcStats = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        @Override
        public HoodieWriteStat build() {
            try {
                HoodieWriteStat record = new HoodieWriteStat();
                record.fileId = this.fieldSetFlags()[0] ? this.fileId : (String)this.defaultValue(this.fields()[0]);
                record.path = this.fieldSetFlags()[1] ? this.path : (String)this.defaultValue(this.fields()[1]);
                record.prevCommit = this.fieldSetFlags()[2] ? this.prevCommit : (String)this.defaultValue(this.fields()[2]);
                record.numWrites = this.fieldSetFlags()[3] ? this.numWrites : (Long)this.defaultValue(this.fields()[3]);
                record.numDeletes = this.fieldSetFlags()[4] ? this.numDeletes : (Long)this.defaultValue(this.fields()[4]);
                record.numUpdateWrites = this.fieldSetFlags()[5] ? this.numUpdateWrites : (Long)this.defaultValue(this.fields()[5]);
                record.totalWriteBytes = this.fieldSetFlags()[6] ? this.totalWriteBytes : (Long)this.defaultValue(this.fields()[6]);
                record.totalWriteErrors = this.fieldSetFlags()[7] ? this.totalWriteErrors : (Long)this.defaultValue(this.fields()[7]);
                record.partitionPath = this.fieldSetFlags()[8] ? this.partitionPath : (String)this.defaultValue(this.fields()[8]);
                record.totalLogRecords = this.fieldSetFlags()[9] ? this.totalLogRecords : (Long)this.defaultValue(this.fields()[9]);
                record.totalLogFiles = this.fieldSetFlags()[10] ? this.totalLogFiles : (Long)this.defaultValue(this.fields()[10]);
                record.totalUpdatedRecordsCompacted = this.fieldSetFlags()[11] ? this.totalUpdatedRecordsCompacted : (Long)this.defaultValue(this.fields()[11]);
                record.numInserts = this.fieldSetFlags()[12] ? this.numInserts : (Long)this.defaultValue(this.fields()[12]);
                record.totalLogBlocks = this.fieldSetFlags()[13] ? this.totalLogBlocks : (Long)this.defaultValue(this.fields()[13]);
                record.totalCorruptLogBlock = this.fieldSetFlags()[14] ? this.totalCorruptLogBlock : (Long)this.defaultValue(this.fields()[14]);
                record.totalRollbackBlocks = this.fieldSetFlags()[15] ? this.totalRollbackBlocks : (Long)this.defaultValue(this.fields()[15]);
                record.fileSizeInBytes = this.fieldSetFlags()[16] ? this.fileSizeInBytes : (Long)this.defaultValue(this.fields()[16]);
                record.logVersion = this.fieldSetFlags()[17] ? this.logVersion : (Integer)this.defaultValue(this.fields()[17]);
                record.logOffset = this.fieldSetFlags()[18] ? this.logOffset : (Long)this.defaultValue(this.fields()[18]);
                record.baseFile = this.fieldSetFlags()[19] ? this.baseFile : (String)this.defaultValue(this.fields()[19]);
                record.logFiles = this.fieldSetFlags()[20] ? this.logFiles : (List)this.defaultValue(this.fields()[20]);
                record.cdcStats = this.fieldSetFlags()[21] ? this.cdcStats : (Map)this.defaultValue(this.fields()[21]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

