/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.processors;

import java.util.List;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroLogicalTypeEnum;
import org.apache.hudi.avro.processors.JsonFieldProcessor;

public abstract class DurationLogicalTypeProcessor
extends JsonFieldProcessor {
    private static final int NUM_ELEMENTS_FOR_DURATION_TYPE = 3;

    protected boolean isValidDurationInput(Object value) {
        if (!(value instanceof List)) {
            return false;
        }
        List list = (List)value;
        if (list.size() != 3) {
            return false;
        }
        for (Object element : list) {
            if (element instanceof Integer) continue;
            return false;
        }
        return true;
    }

    protected static boolean isValidDurationTypeConfig(Schema schema) {
        String durationTypeName = AvroLogicalTypeEnum.DURATION.getValue();
        LogicalType durationType = schema.getLogicalType();
        String durationTypeProp = schema.getProp("logicalType");
        return schema.getType().equals((Object)Schema.Type.FIXED) && schema.getFixedSize() == 12 && (durationType != null && durationType.getName().equals(durationTypeName) || durationTypeProp != null && durationTypeProp.equals(durationTypeName));
    }
}

