/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.Objects;
import org.apache.hudi.common.model.HoodieKey;

public class DeleteRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final HoodieKey hoodieKey;
    private final Comparable<?> orderingVal;

    private DeleteRecord(HoodieKey hoodieKey, Comparable orderingVal) {
        this.hoodieKey = hoodieKey;
        this.orderingVal = orderingVal;
    }

    public static DeleteRecord create(HoodieKey hoodieKey) {
        return DeleteRecord.create(hoodieKey, Integer.valueOf(0));
    }

    public static DeleteRecord create(String recordKey, String partitionPath) {
        return DeleteRecord.create(recordKey, partitionPath, Integer.valueOf(0));
    }

    public static DeleteRecord create(String recordKey, String partitionPath, Comparable orderingVal) {
        return DeleteRecord.create(new HoodieKey(recordKey, partitionPath), orderingVal);
    }

    public static DeleteRecord create(HoodieKey hoodieKey, Comparable orderingVal) {
        return new DeleteRecord(hoodieKey, orderingVal);
    }

    public String getRecordKey() {
        return this.hoodieKey.getRecordKey();
    }

    public String getPartitionPath() {
        return this.hoodieKey.getPartitionPath();
    }

    public HoodieKey getHoodieKey() {
        return this.hoodieKey;
    }

    public Comparable<?> getOrderingValue() {
        return this.orderingVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteRecord)) {
            return false;
        }
        DeleteRecord that = (DeleteRecord)o;
        return this.hoodieKey.equals(that.hoodieKey) && this.orderingVal.equals(that.orderingVal);
    }

    public int hashCode() {
        return Objects.hash(this.hoodieKey, this.orderingVal);
    }

    public String toString() {
        return "DeleteRecord { key=" + this.hoodieKey + " orderingVal=" + this.orderingVal + '}';
    }
}

