/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.Option;

public class OverwriteNonDefaultsWithLatestAvroPayload
extends OverwriteWithLatestAvroPayload {
    public OverwriteNonDefaultsWithLatestAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public OverwriteNonDefaultsWithLatestAvroPayload(Option<GenericRecord> record) {
        super(record);
    }

    @Override
    public OverwriteWithLatestAvroPayload preCombine(OverwriteWithLatestAvroPayload oldValue) {
        if (oldValue.recordBytes.length == 0) {
            return this;
        }
        if (oldValue.orderingVal.compareTo(this.orderingVal) > 0) {
            return oldValue;
        }
        return this;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
        Option<IndexedRecord> recordOption = this.getInsertValue(schema);
        if (!recordOption.isPresent()) {
            return Option.empty();
        }
        GenericRecord insertRecord = (GenericRecord)recordOption.get();
        GenericRecord currentRecord = (GenericRecord)currentValue;
        return this.mergeRecords(schema, insertRecord, currentRecord);
    }

    protected Option<IndexedRecord> mergeRecords(Schema schema, GenericRecord baseRecord, GenericRecord mergedRecord) {
        if (this.isDeleteRecord(baseRecord)) {
            return Option.empty();
        }
        GenericRecordBuilder builder = new GenericRecordBuilder(schema);
        List<Schema.Field> fields = schema.getFields();
        fields.forEach(field -> this.setField(baseRecord, mergedRecord, builder, (Schema.Field)field));
        return Option.of(builder.build());
    }

    protected void setField(GenericRecord baseRecord, GenericRecord mergedRecord, GenericRecordBuilder builder, Schema.Field field) {
        Object defaultValue;
        Object value = baseRecord.get(field.name());
        value = field.schema().getType().equals((Object)Schema.Type.STRING) && value != null ? value.toString() : value;
        if (!this.overwriteField(value, defaultValue = field.defaultVal()).booleanValue()) {
            builder.set(field, value);
        } else {
            builder.set(field, mergedRecord.get(field.name()));
        }
    }
}

