/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import org.apache.hudi.common.util.Base64CodecUtil;
import org.apache.hudi.org.roaringbitmap.longlong.Roaring64NavigableMap;

public class LogReaderUtils {
    public static String encodePositions(Set<Long> positions) throws IOException {
        Roaring64NavigableMap positionBitmap = new Roaring64NavigableMap();
        positions.forEach(xva$0 -> positionBitmap.add((long)xva$0));
        return LogReaderUtils.encodePositions(positionBitmap);
    }

    public static String encodePositions(Roaring64NavigableMap positionBitmap) throws IOException {
        positionBitmap.runOptimize();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        positionBitmap.serializePortable(dos);
        return Base64CodecUtil.encode(baos.toByteArray());
    }

    public static Roaring64NavigableMap decodeRecordPositionsHeader(String content) throws IOException {
        Roaring64NavigableMap positionBitmap = new Roaring64NavigableMap();
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64CodecUtil.decode(content));
        DataInputStream dis = new DataInputStream(bais);
        positionBitmap.deserializePortable(dis);
        return positionBitmap;
    }
}

