/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.storage.HoodieStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieDataBlock
extends HoodieLogBlock {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieDataBlock.class);
    private final Option<List<HoodieRecord>> records;
    private final String keyFieldName;
    private final boolean enablePointLookups;
    protected Schema readerSchema;
    protected final boolean shouldWriteRecordPositions;
    private static ConcurrentHashMap<String, Schema> schemaMap = new ConcurrentHashMap();

    public HoodieDataBlock(List<HoodieRecord> records, boolean shouldWriteRecordPositions, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.FooterMetadataType, String> footer, String keyFieldName) {
        super(header, footer, Option.empty(), Option.empty(), null, false);
        if (shouldWriteRecordPositions) {
            records.sort((o1, o2) -> {
                long v1 = o1.getCurrentPosition();
                long v2 = o2.getCurrentPosition();
                return Long.compare(v1, v2);
            });
            if (HoodieRecordLocation.isPositionValid(records.get(0).getCurrentPosition())) {
                this.addRecordPositionsToHeader(records.stream().map(HoodieRecord::getCurrentPosition).collect(Collectors.toSet()), records.size());
            } else {
                LOG.warn("There are records without valid positions. Skip writing record positions to the data block header.");
            }
        }
        this.records = Option.of(records);
        this.keyFieldName = keyFieldName;
        this.readerSchema = HoodieDataBlock.getWriterSchema(super.getLogBlockHeader());
        this.shouldWriteRecordPositions = shouldWriteRecordPositions;
        this.enablePointLookups = false;
    }

    protected HoodieDataBlock(Option<byte[]> content, Supplier<SeekableDataInputStream> inputStreamSupplier, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Option<Schema> readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> headers, Map<HoodieLogBlock.FooterMetadataType, String> footer, String keyFieldName, boolean enablePointLookups) {
        super(headers, footer, blockContentLocation, content, inputStreamSupplier, readBlockLazily);
        this.shouldWriteRecordPositions = false;
        this.records = Option.empty();
        this.keyFieldName = keyFieldName;
        this.readerSchema = this.containsPartialUpdates() ? HoodieDataBlock.getWriterSchema(super.getLogBlockHeader()) : readerSchema.orElseGet(() -> HoodieDataBlock.getWriterSchema(super.getLogBlockHeader()));
        this.enablePointLookups = enablePointLookups;
    }

    @Override
    public byte[] getContentBytes(HoodieStorage storage) throws IOException {
        Option<byte[]> content = this.getContent();
        ValidationUtils.checkState(content.isPresent() || this.records.isPresent(), "Block is in invalid state");
        if (content.isPresent()) {
            return content.get();
        }
        return this.serializeRecords(this.records.get(), storage);
    }

    public String getKeyFieldName() {
        return this.keyFieldName;
    }

    public boolean containsPartialUpdates() {
        return this.getLogBlockHeader().containsKey((Object)HoodieLogBlock.HeaderMetadataType.IS_PARTIAL) && Boolean.parseBoolean(this.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.IS_PARTIAL));
    }

    protected static Schema getWriterSchema(Map<HoodieLogBlock.HeaderMetadataType, String> logBlockHeader) {
        return new Schema.Parser().parse(logBlockHeader.get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
    }

    public final <T> ClosableIterator<HoodieRecord<T>> getRecordIterator(HoodieRecord.HoodieRecordType type) {
        if (this.records.isPresent()) {
            return HoodieDataBlock.list2Iterator((List)TypeUtils.unsafeCast(this.records.get()));
        }
        try {
            return this.readRecordsFromBlockPayload(type);
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to convert content bytes to records", io);
        }
    }

    public Schema getSchema() {
        return this.readerSchema;
    }

    public final <T> ClosableIterator<HoodieRecord<T>> getRecordIterator(List<String> keys, boolean fullKey, HoodieRecord.HoodieRecordType type) throws IOException {
        boolean fullScan = keys.isEmpty();
        if (this.enablePointLookups && !fullScan) {
            return this.lookupRecords(keys, fullKey);
        }
        ClosableIterator<HoodieRecord<T>> allRecords = this.getRecordIterator(type);
        if (fullScan) {
            return allRecords;
        }
        HashSet<String> keySet = new HashSet<String>(keys);
        return FilteringIterator.getInstance(allRecords, keySet, fullKey, this::getRecordKey);
    }

    public final <T> ClosableIterator<T> getEngineRecordIterator(HoodieReaderContext<T> readerContext) {
        if (this.records.isPresent()) {
            return HoodieDataBlock.list2Iterator((List)TypeUtils.unsafeCast(this.records.get().stream().map(hoodieRecord -> hoodieRecord.getData()).collect(Collectors.toList())));
        }
        try {
            return this.readRecordsFromBlockPayload(readerContext);
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to convert content bytes to records", io);
        }
    }

    public final <T> ClosableIterator<T> getEngineRecordIterator(HoodieReaderContext<T> readerContext, List<String> keys, boolean fullKey) {
        boolean fullScan = keys.isEmpty();
        ClosableIterator<T> allRecords = this.getEngineRecordIterator(readerContext);
        if (fullScan) {
            return allRecords;
        }
        HashSet<String> keySet = new HashSet<String>(keys);
        return FilteringEngineRecordIterator.getInstance(allRecords, keySet, fullKey, record -> Option.of(readerContext.getValue(record, this.readerSchema, this.keyFieldName).toString()));
    }

    protected <T> ClosableIterator<HoodieRecord<T>> readRecordsFromBlockPayload(HoodieRecord.HoodieRecordType type) throws IOException {
        if (this.readBlockLazily && !this.getContent().isPresent()) {
            this.inflate();
        }
        try {
            ClosableIterator<HoodieRecord<T>> closableIterator = this.deserializeRecords(this.getContent().get(), type);
            return closableIterator;
        }
        finally {
            this.deflate();
        }
    }

    protected <T> ClosableIterator<T> readRecordsFromBlockPayload(HoodieReaderContext<T> readerContext) throws IOException {
        if (this.readBlockLazily && !this.getContent().isPresent()) {
            this.inflate();
        }
        try {
            ClosableIterator<T> closableIterator = this.deserializeRecords(readerContext, this.getContent().get());
            return closableIterator;
        }
        finally {
            this.deflate();
        }
    }

    protected <T> ClosableIterator<HoodieRecord<T>> lookupRecords(List<String> keys, boolean fullKey) throws IOException {
        throw new UnsupportedOperationException(String.format("Point lookups are not supported by this Data block type (%s)", new Object[]{this.getBlockType()}));
    }

    protected abstract byte[] serializeRecords(List<HoodieRecord> var1, HoodieStorage var2) throws IOException;

    protected abstract <T> ClosableIterator<HoodieRecord<T>> deserializeRecords(byte[] var1, HoodieRecord.HoodieRecordType var2) throws IOException;

    protected abstract <T> ClosableIterator<T> deserializeRecords(HoodieReaderContext<T> var1, byte[] var2) throws IOException;

    @Override
    public abstract HoodieLogBlock.HoodieLogBlockType getBlockType();

    protected Option<Schema.Field> getKeyField(Schema schema) {
        return Option.ofNullable(schema.getField(this.keyFieldName));
    }

    protected Option<String> getRecordKey(HoodieRecord record) {
        return Option.ofNullable(record.getRecordKey(this.readerSchema, this.keyFieldName));
    }

    protected Schema getSchemaFromHeader() {
        String schemaStr = this.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA);
        schemaMap.computeIfAbsent(schemaStr, schemaString -> new Schema.Parser().parse((String)schemaString));
        return schemaMap.get(schemaStr);
    }

    static <T> ClosableIterator<T> list2Iterator(List<T> list) {
        final Iterator<T> iterator = list.iterator();
        return new ClosableIterator<T>(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    private static class FilteringEngineRecordIterator<T>
    implements ClosableIterator<T> {
        private final ClosableIterator<T> nested;
        private final Set<String> keys;
        private final boolean fullKey;
        private final Function<T, Option<String>> keyExtract;
        private T next;

        private FilteringEngineRecordIterator(ClosableIterator<T> nested, Set<String> keys, boolean fullKey, Function<T, Option<String>> keyExtract) {
            this.nested = nested;
            this.keys = keys;
            this.fullKey = fullKey;
            this.keyExtract = keyExtract;
        }

        public static <T> FilteringEngineRecordIterator<T> getInstance(ClosableIterator<T> nested, Set<String> keys, boolean fullKey, Function<T, Option<String>> keyExtract) {
            return new FilteringEngineRecordIterator<T>(nested, keys, fullKey, keyExtract);
        }

        @Override
        public void close() {
            this.nested.close();
        }

        @Override
        public boolean hasNext() {
            while (this.nested.hasNext()) {
                this.next = this.nested.next();
                String key = this.keyExtract.apply(this.next).orElseGet(() -> {
                    throw new IllegalStateException(String.format("Record without a key (%s)", this.next));
                });
                if (!this.fullKey || !this.keys.contains(key)) {
                    if (this.fullKey) continue;
                    if (!this.keys.stream().anyMatch(key::startsWith)) continue;
                }
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            return this.next;
        }
    }

    private static class FilteringIterator<T>
    implements ClosableIterator<HoodieRecord<T>> {
        private final ClosableIterator<HoodieRecord<T>> nested;
        private final Set<String> keys;
        private final boolean fullKey;
        private final Function<HoodieRecord<T>, Option<String>> keyExtract;
        private HoodieRecord<T> next;

        private FilteringIterator(ClosableIterator<HoodieRecord<T>> nested, Set<String> keys, boolean fullKey, Function<HoodieRecord<T>, Option<String>> keyExtract) {
            this.nested = nested;
            this.keys = keys;
            this.fullKey = fullKey;
            this.keyExtract = keyExtract;
        }

        public static <T> FilteringIterator<T> getInstance(ClosableIterator<HoodieRecord<T>> nested, Set<String> keys, boolean fullKey, Function<HoodieRecord<T>, Option<String>> keyExtract) {
            return new FilteringIterator<T>(nested, keys, fullKey, keyExtract);
        }

        @Override
        public void close() {
            this.nested.close();
        }

        @Override
        public boolean hasNext() {
            while (this.nested.hasNext()) {
                this.next = (HoodieRecord)this.nested.next();
                String key = this.keyExtract.apply(this.next).orElseGet(() -> {
                    throw new IllegalStateException(String.format("Record without a key (%s)", this.next));
                });
                if (!this.fullKey || !this.keys.contains(key)) {
                    if (this.fullKey) continue;
                    if (!this.keys.stream().anyMatch(key::startsWith)) continue;
                }
                return true;
            }
            return false;
        }

        @Override
        public HoodieRecord<T> next() {
            return this.next;
        }
    }
}

