/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.AvroSchemaCache;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;

public class HoodieFileGroupReaderSchemaHandler<T>
implements Closeable {
    protected final Schema dataSchema;
    protected final Schema requestedSchema;
    protected final Schema requiredSchema;
    protected final InternalSchema internalSchema;
    protected final Option<InternalSchema> internalSchemaOpt;
    protected final HoodieTableConfig hoodieTableConfig;
    protected final HoodieReaderContext<T> readerContext;
    protected final TypedProperties properties;
    protected final Option<HoodieRecordMerger> recordMerger;
    protected final boolean hasBootstrapBaseFile;
    protected boolean needsBootstrapMerge;
    protected final boolean needsMORMerge;
    private final AvroSchemaCache avroSchemaCache;

    public HoodieFileGroupReaderSchemaHandler(HoodieReaderContext<T> readerContext, Schema dataSchema, Schema requestedSchema, Option<InternalSchema> internalSchemaOpt, HoodieTableConfig hoodieTableConfig, TypedProperties properties) {
        this.properties = properties;
        this.readerContext = readerContext;
        this.hasBootstrapBaseFile = readerContext.getHasBootstrapBaseFile();
        this.needsMORMerge = readerContext.getHasLogFiles();
        this.recordMerger = readerContext.getRecordMerger();
        this.dataSchema = dataSchema;
        this.requestedSchema = requestedSchema;
        this.hoodieTableConfig = hoodieTableConfig;
        this.requiredSchema = this.prepareRequiredSchema();
        this.internalSchema = this.pruneInternalSchema(this.requiredSchema, internalSchemaOpt);
        this.internalSchemaOpt = this.getInternalSchemaOpt(internalSchemaOpt);
        readerContext.setNeedsBootstrapMerge(this.needsBootstrapMerge);
        this.avroSchemaCache = AvroSchemaCache.getInstance();
    }

    public Schema getDataSchema() {
        return this.dataSchema;
    }

    public Schema getRequestedSchema() {
        return this.requestedSchema;
    }

    public Schema getRequiredSchema() {
        return this.requiredSchema;
    }

    public InternalSchema getInternalSchema() {
        return this.internalSchema;
    }

    public Option<InternalSchema> getInternalSchemaOpt() {
        return this.internalSchemaOpt;
    }

    public Option<UnaryOperator<T>> getOutputConverter() {
        if (!this.requestedSchema.equals(this.requiredSchema)) {
            return Option.of(this.readerContext.projectRecord(this.requiredSchema, this.requestedSchema));
        }
        return Option.empty();
    }

    private InternalSchema pruneInternalSchema(Schema requiredSchema, Option<InternalSchema> internalSchemaOption) {
        if (!internalSchemaOption.isPresent()) {
            return InternalSchema.getEmptyInternalSchema();
        }
        InternalSchema notPruned = internalSchemaOption.get();
        if (notPruned == null || notPruned.isEmptySchema()) {
            return InternalSchema.getEmptyInternalSchema();
        }
        return this.doPruneInternalSchema(requiredSchema, notPruned);
    }

    protected Option<InternalSchema> getInternalSchemaOpt(Option<InternalSchema> internalSchemaOpt) {
        return internalSchemaOpt;
    }

    protected InternalSchema doPruneInternalSchema(Schema requiredSchema, InternalSchema internalSchema) {
        return AvroInternalSchemaConverter.pruneAvroSchemaToInternalSchema(requiredSchema, internalSchema);
    }

    private Schema generateRequiredSchema() {
        if (!this.needsMORMerge) {
            return this.requestedSchema;
        }
        if (this.hoodieTableConfig.getRecordMergeMode() == RecordMergeMode.CUSTOM && !this.recordMerger.get().isProjectionCompatible()) {
            return this.dataSchema;
        }
        ArrayList<Schema.Field> addedFields = new ArrayList<Schema.Field>();
        for (String field : HoodieFileGroupReaderSchemaHandler.getMandatoryFieldsForMerging(this.hoodieTableConfig, this.properties, this.dataSchema, this.recordMerger)) {
            if (AvroSchemaUtils.findNestedField(this.requestedSchema, field).isPresent()) continue;
            Option<Schema.Field> foundFieldOpt = AvroSchemaUtils.findNestedField(this.dataSchema, field);
            if (!foundFieldOpt.isPresent()) {
                throw new IllegalArgumentException("Field: " + field + " does not exist in the table schema");
            }
            Schema.Field foundField = foundFieldOpt.get();
            addedFields.add(foundField);
        }
        if (addedFields.isEmpty()) {
            return this.requestedSchema;
        }
        return AvroSchemaUtils.appendFieldsToSchemaDedupNested(this.requestedSchema, addedFields);
    }

    private static String[] getMandatoryFieldsForMerging(HoodieTableConfig cfg, TypedProperties props, Schema dataSchema, Option<HoodieRecordMerger> recordMerger) {
        String preCombine;
        if (cfg.getRecordMergeMode() == RecordMergeMode.CUSTOM) {
            return recordMerger.get().getMandatoryFieldsForMerging(dataSchema, cfg, props);
        }
        ArrayList<Object> requiredFields = new ArrayList<Object>();
        if (cfg.populateMetaFields()) {
            requiredFields.add(HoodieRecord.RECORD_KEY_METADATA_FIELD);
        } else {
            Option<String[]> fields = cfg.getRecordKeyFields();
            if (fields.isPresent()) {
                requiredFields.addAll(Arrays.asList((Object[])fields.get()));
            }
        }
        if (cfg.getRecordMergeMode() == RecordMergeMode.EVENT_TIME_ORDERING && !StringUtils.isNullOrEmpty(preCombine = cfg.getPreCombineField())) {
            requiredFields.add(preCombine);
        }
        return requiredFields.toArray(new String[0]);
    }

    protected Schema prepareRequiredSchema() {
        Schema preReorderRequiredSchema = this.generateRequiredSchema();
        Pair<List<Schema.Field>, List<Schema.Field>> requiredFields = HoodieFileGroupReaderSchemaHandler.getDataAndMetaCols(preReorderRequiredSchema);
        this.needsBootstrapMerge = this.hasBootstrapBaseFile && !requiredFields.getLeft().isEmpty() && !requiredFields.getRight().isEmpty();
        return this.needsBootstrapMerge ? this.createSchemaFromFields(Stream.concat(requiredFields.getLeft().stream(), requiredFields.getRight().stream()).collect(Collectors.toList())) : preReorderRequiredSchema;
    }

    public Pair<List<Schema.Field>, List<Schema.Field>> getBootstrapRequiredFields() {
        return HoodieFileGroupReaderSchemaHandler.getDataAndMetaCols(this.requiredSchema);
    }

    public Pair<List<Schema.Field>, List<Schema.Field>> getBootstrapDataFields() {
        return HoodieFileGroupReaderSchemaHandler.getDataAndMetaCols(this.dataSchema);
    }

    @VisibleForTesting
    static Pair<List<Schema.Field>, List<Schema.Field>> getDataAndMetaCols(Schema schema) {
        Map<Boolean, List<Schema.Field>> fieldsByMeta = schema.getFields().stream().filter(f -> !Objects.equals(f.name(), "_tmp_metadata_row_index")).collect(Collectors.partitioningBy(f -> HoodieRecord.HOODIE_META_COLUMNS_WITH_OPERATION.contains(f.name())));
        return Pair.of(fieldsByMeta.getOrDefault(true, Collections.emptyList()), fieldsByMeta.getOrDefault(false, Collections.emptyList()));
    }

    public Schema createSchemaFromFields(List<Schema.Field> fields) {
        for (int i = 0; i < fields.size(); ++i) {
            Schema.Field curr = fields.get(i);
            fields.set(i, new Schema.Field(curr.name(), curr.schema(), curr.doc(), curr.defaultVal()));
        }
        return AvroSchemaUtils.createNewSchemaFromFieldsWithReference(this.dataSchema, fields);
    }

    public Integer encodeAvroSchema(Schema schema) {
        return this.avroSchemaCache.cacheSchema(schema);
    }

    @Nullable
    public Schema decodeAvroSchema(Object versionId) {
        return this.avroSchemaCache.getSchema((Integer)versionId).orElse(null);
    }

    @Override
    public void close() {
        this.avroSchemaCache.close();
    }
}

