/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.BinaryUtil;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.MetadataNotFoundException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.io.hadoop.OrcReaderIterator;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;

public class OrcUtils
extends FileFormatUtils {
    @Override
    public ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage storage, StoragePath filePath) {
        return this.getHoodieKeyIterator(storage, filePath, Option.empty());
    }

    @Override
    public List<Pair<HoodieKey, Long>> fetchRecordKeysWithPositions(HoodieStorage storage, StoragePath filePath) {
        return this.fetchRecordKeysWithPositions(storage, filePath, Option.empty());
    }

    @Override
    public List<Pair<HoodieKey, Long>> fetchRecordKeysWithPositions(HoodieStorage storage, StoragePath filePath, Option<BaseKeyGenerator> keyGeneratorOpt) {
        try {
            if (!storage.exists(filePath)) {
                return Collections.emptyList();
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read from ORC file:" + filePath, e);
        }
        ArrayList<Pair<HoodieKey, Long>> hoodieKeysAndPositions = new ArrayList<Pair<HoodieKey, Long>>();
        long position = 0L;
        try (ClosableIterator<HoodieKey> iterator = this.getHoodieKeyIterator(storage, filePath, keyGeneratorOpt);){
            while (iterator.hasNext()) {
                hoodieKeysAndPositions.add(Pair.of(iterator.next(), position));
                ++position;
            }
        }
        return hoodieKeysAndPositions;
    }

    @Override
    public ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage storage, StoragePath filePath, Option<BaseKeyGenerator> keyGeneratorOpt) {
        try {
            Configuration conf = storage.getConf().unwrapCopyAs(Configuration.class);
            conf.addResource(HadoopFSUtils.getFs(filePath.toString(), conf).getConf());
            Reader reader = OrcFile.createReader((Path)HadoopFSUtils.convertToHadoopPath(filePath), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            Schema readSchema = HoodieAvroUtils.getRecordKeyPartitionPathSchema();
            TypeDescription orcSchema = AvroOrcUtils.createOrcSchema(readSchema);
            RecordReader recordReader = reader.rows(new Reader.Options(conf).schema(orcSchema));
            List fieldNames = orcSchema.getFieldNames();
            int keyCol = -1;
            int partitionCol = -1;
            for (int i = 0; i < fieldNames.size(); ++i) {
                if (((String)fieldNames.get(i)).equals(HoodieRecord.RECORD_KEY_METADATA_FIELD)) {
                    keyCol = i;
                }
                if (!((String)fieldNames.get(i)).equals(HoodieRecord.PARTITION_PATH_METADATA_FIELD)) continue;
                partitionCol = i;
            }
            if (keyCol == -1 || partitionCol == -1) {
                throw new HoodieException(String.format("Couldn't find row keys or partition path in %s.", filePath));
            }
            return FileFormatUtils.HoodieKeyIterator.getInstance(new OrcReaderIterator<GenericRecord>(recordReader, readSchema, orcSchema), keyGeneratorOpt);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to open reader from ORC file:" + filePath, e);
        }
    }

    @Override
    public List<GenericRecord> readAvroRecords(HoodieStorage storage, StoragePath filePath) {
        Schema avroSchema;
        try (Reader reader = OrcFile.createReader((Path)HadoopFSUtils.convertToHadoopPath(filePath), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)storage.getConf().unwrapAs(Configuration.class)));){
            avroSchema = AvroOrcUtils.createAvroSchema(reader.getSchema());
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to read Avro records from an ORC file:" + filePath, io);
        }
        return this.readAvroRecords(storage, filePath, avroSchema);
    }

    @Override
    public List<GenericRecord> readAvroRecords(HoodieStorage storage, StoragePath filePath, Schema avroSchema) {
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        try (Reader reader = OrcFile.createReader((Path)HadoopFSUtils.convertToHadoopPath(filePath), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)storage.getConf().unwrapAs(Configuration.class)));){
            TypeDescription orcSchema = reader.getSchema();
            try (RecordReader recordReader = reader.rows(new Reader.Options(storage.getConf().unwrapAs(Configuration.class)).schema(orcSchema));){
                OrcReaderIterator iterator = new OrcReaderIterator(recordReader, avroSchema, orcSchema);
                while (iterator.hasNext()) {
                    GenericRecord record = (GenericRecord)iterator.next();
                    records.add(record);
                }
            }
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to create an ORC reader for ORC file:" + filePath, io);
        }
        return records;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Set<Pair<String, Long>> filterRowKeys(HoodieStorage storage, StoragePath filePath, Set<String> filter) throws HoodieIOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> readFooter(HoodieStorage storage, boolean required, StoragePath filePath, String ... footerNames) {
        try (Reader reader = OrcFile.createReader((Path)HadoopFSUtils.convertToHadoopPath(filePath), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)storage.getConf().unwrapAs(Configuration.class)));){
            HashMap<String, String> footerVals = new HashMap<String, String>();
            List metadataItemList = reader.getFileTail().getFooter().getMetadataList();
            Map<String, String> metadata = metadataItemList.stream().collect(Collectors.toMap(OrcProto.UserMetadataItem::getName, metadataItem -> metadataItem.getValue().toStringUtf8()));
            for (String footerName : footerNames) {
                if (metadata.containsKey(footerName)) {
                    footerVals.put(footerName, metadata.get(footerName));
                    continue;
                }
                if (!required) continue;
                throw new MetadataNotFoundException("Could not find index in ORC footer. Looked for key " + footerName + " in " + filePath);
            }
            HashMap<String, String> hashMap = footerVals;
            return hashMap;
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to read footer for ORC file:" + filePath, io);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Schema readAvroSchema(HoodieStorage storage, StoragePath filePath) {
        try (Reader reader = OrcFile.createReader((Path)HadoopFSUtils.convertToHadoopPath(filePath), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)storage.getConf().unwrapAs(Configuration.class)));){
            if (reader.hasMetadataValue("orc.avro.schema")) {
                ByteBuffer metadataValue = reader.getMetadataValue("orc.avro.schema");
                byte[] bytes = BinaryUtil.toBytes(metadataValue);
                Schema schema = new Schema.Parser().parse(new String(bytes));
                return schema;
            }
            TypeDescription orcSchema = reader.getSchema();
            Schema schema = AvroOrcUtils.createAvroSchema(orcSchema);
            return schema;
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to get Avro schema for ORC file:" + filePath, io);
        }
    }

    @Override
    public List<HoodieColumnRangeMetadata<Comparable>> readColumnStatsFromMetadata(HoodieStorage storage, StoragePath filePath, List<String> columnList) {
        throw new UnsupportedOperationException("Reading column statistics from metadata is not supported for ORC format yet");
    }

    @Override
    public HoodieFileFormat getFormat() {
        return HoodieFileFormat.ORC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getRowCount(HoodieStorage storage, StoragePath filePath) {
        try (Reader reader = OrcFile.createReader((Path)HadoopFSUtils.convertToHadoopPath(filePath), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)storage.getConf().unwrapAs(Configuration.class)));){
            long l = reader.getNumberOfRows();
            return l;
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to get row count for ORC file:" + filePath, io);
        }
    }

    @Override
    public void writeMetaFile(HoodieStorage storage, StoragePath filePath, Properties props) throws IOException {
        Schema schema = HoodieAvroUtils.getRecordKeySchema();
        OrcFile.WriterOptions writerOptions = OrcFile.writerOptions((Configuration)storage.getConf().unwrapAs(Configuration.class)).fileSystem((FileSystem)storage.getFileSystem()).setSchema(AvroOrcUtils.createOrcSchema(schema));
        try (Writer writer = OrcFile.createWriter((Path)HadoopFSUtils.convertToHadoopPath(filePath), (OrcFile.WriterOptions)writerOptions);){
            for (String key : props.stringPropertyNames()) {
                writer.addUserMetadata(key, ByteBuffer.wrap(StringUtils.getUTF8Bytes(props.getProperty(key))));
            }
        }
    }

    @Override
    public byte[] serializeRecordsToLogBlock(HoodieStorage storage, List<HoodieRecord> records, Schema writerSchema, Schema readerSchema, String keyFieldName, Map<String, String> paramsMap) throws IOException {
        throw new UnsupportedOperationException("Hudi log blocks do not support ORC format yet");
    }
}

