/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.avro;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.hadoop.HoodieColumnProjectionUtils;
import org.apache.hudi.hadoop.utils.HoodieRealtimeRecordReaderUtils;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;

public class HoodieAvroParquetReader
extends RecordReader<Void, ArrayWritable> {
    private final ParquetRecordReader<GenericData.Record> parquetRecordReader;
    private Schema baseSchema;

    public HoodieAvroParquetReader(InputSplit inputSplit, Configuration conf) throws IOException {
        ParquetMetadata fileFooter = ParquetFileReader.readFooter(conf, ((ParquetInputSplit)inputSplit).getPath(), ParquetMetadataConverter.NO_FILTER);
        MessageType messageType = fileFooter.getFileMetaData().getSchema();
        this.baseSchema = new AvroSchemaConverter(conf).convert(messageType);
        List<String> readColNames = Arrays.asList(HoodieColumnProjectionUtils.getReadColumnNames(conf));
        if (!readColNames.isEmpty()) {
            Schema filterSchema = HoodieAvroUtils.generateProjectionSchema(this.baseSchema, readColNames);
            AvroReadSupport.setAvroReadSchema(conf, filterSchema);
            AvroReadSupport.setRequestedProjection(conf, filterSchema);
        }
        this.parquetRecordReader = new ParquetRecordReader(new AvroReadSupport(), ParquetInputFormat.getFilter(conf));
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.parquetRecordReader.initialize(split, context);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.parquetRecordReader.nextKeyValue();
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return this.parquetRecordReader.getCurrentKey();
    }

    public ArrayWritable getCurrentValue() throws IOException, InterruptedException {
        GenericRecord record = this.parquetRecordReader.getCurrentValue();
        return (ArrayWritable)HoodieRealtimeRecordReaderUtils.avroToArrayWritable(record, this.baseSchema, true);
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.parquetRecordReader.getProgress();
    }

    public void close() throws IOException {
        this.parquetRecordReader.close();
    }
}

