/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.MetricRegistry;
import java.lang.management.ManagementFactory;
import java.rmi.server.ExportException;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.management.MBeanServer;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.JmxReporterServer;
import org.apache.hudi.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMetricsReporter
extends MetricsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(JmxMetricsReporter.class);
    private final MetricRegistry registry;
    private JmxReporterServer jmxReporterServer;

    public JmxMetricsReporter(HoodieMetricsConfig config, MetricRegistry registry) {
        try {
            this.registry = registry;
            String host = config.getJmxHost();
            String portsConfig = config.getJmxPort();
            if (host == null || portsConfig == null) {
                throw new HoodieException(String.format("Jmx cannot be initialized with host[%s] and port[%s].", host, portsConfig));
            }
            int[] ports = this.getPortRangeFromString(portsConfig);
            this.initializeJmxReporterServer(host, ports);
            boolean successfullyStartedServer = this.isServerCreated();
            if (!successfullyStartedServer) {
                throw new HoodieException("Could not start JMX server on any configured port. Ports: " + portsConfig + ". Maybe require port range for multiple hoodie tables");
            }
            LOG.info("Configured JMXReporter with {port:" + portsConfig + "}");
        }
        catch (Exception e) {
            String msg = "Jmx initialize failed: ";
            LOG.error(msg, (Throwable)e);
            throw new HoodieException(msg, e);
        }
    }

    private boolean isServerCreated() {
        return this.jmxReporterServer != null;
    }

    private void initializeJmxReporterServer(String host, int[] ports) {
        for (int port : ports) {
            try {
                this.jmxReporterServer = this.createJmxReport(host, port);
                LOG.info("Started JMX server on port " + port + ".");
                break;
            }
            catch (Exception e) {
                if (e.getCause() instanceof ExportException) {
                    LOG.info("Skip for initializing jmx port " + port + " because of already in use");
                    continue;
                }
                LOG.info("Failed to initialize jmx port " + port + ". " + e.getMessage());
            }
        }
    }

    @Override
    public void start() {
        if (this.isServerCreated()) {
            this.jmxReporterServer.start();
        } else {
            LOG.error("Cannot start as the jmxReporter is null.");
        }
    }

    @Override
    public void report() {
    }

    @Override
    public void stop() {
        Objects.requireNonNull(this.jmxReporterServer, "jmxReporterServer is not running.");
        try {
            this.jmxReporterServer.stop();
        }
        catch (Exception e) {
            throw new HoodieException("Stop jmxReporterServer fail", e);
        }
    }

    private JmxReporterServer createJmxReport(String host, int port) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        return JmxReporterServer.forRegistry(this.registry).host(host).port(port).registerWith(mBeanServer).build();
    }

    private int[] getPortRangeFromString(String portsConfig) {
        int end;
        int start;
        String range = portsConfig.trim();
        int dashIdx = range.indexOf(45);
        if (dashIdx == -1) {
            start = Integer.parseInt(range);
            end = Integer.parseInt(range);
        } else {
            start = Integer.parseInt(range.substring(0, dashIdx));
            end = Integer.parseInt(range.substring(dashIdx + 1));
        }
        return IntStream.rangeClosed(start, end).filter(port -> 0 <= port && port <= 65535).toArray();
    }
}

