/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.util.concurrent.CompletableFuture;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncRpcRetryingCaller;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.Timer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AsyncMasterRequestRpcRetryingCaller<T>
extends AsyncRpcRetryingCaller<T> {
    private final Callable<T> callable;

    public AsyncMasterRequestRpcRetryingCaller(Timer retryTimer, AsyncConnectionImpl conn, Callable<T> callable, int priority, long pauseNs, long pauseForCQTBENs, int maxRetries, long operationTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt) {
        super(retryTimer, conn, priority, pauseNs, pauseForCQTBENs, maxRetries, operationTimeoutNs, rpcTimeoutNs, startLogErrorsCnt);
        this.callable = callable;
    }

    private void clearMasterStubCacheOnError(MasterProtos.MasterService.Interface stub, Throwable error) {
        if (ClientExceptionsUtil.isConnectionException(error) || error instanceof ServerNotRunningYetException) {
            this.conn.clearMasterStubCache(stub);
        }
    }

    @Override
    protected void doCall() {
        FutureUtils.addListener(this.conn.getMasterStub(), (stub, error) -> {
            if (error != null) {
                this.onError((Throwable)error, () -> "Get async master stub failed", err -> {});
                return;
            }
            this.resetCallTimeout();
            FutureUtils.addListener(this.callable.call(this.controller, (MasterProtos.MasterService.Interface)stub), (result, error2) -> {
                if (error2 != null) {
                    this.onError((Throwable)error2, () -> "Call to master failed", err -> this.clearMasterStubCacheOnError((MasterProtos.MasterService.Interface)stub, (Throwable)error2));
                    return;
                }
                this.future.complete(result);
            });
        });
    }

    @FunctionalInterface
    public static interface Callable<T> {
        public CompletableFuture<T> call(HBaseRpcController var1, MasterProtos.MasterService.Interface var2);
    }
}

