/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.RegionLocations;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hudi.org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReversedScannerCallable
extends ScannerCallable {
    private byte[] locationSearchKey;

    public ReversedScannerCallable(ClusterConnection connection, TableName tableName, Scan scan, ScanMetrics scanMetrics, RpcControllerFactory rpcFactory, int replicaId) {
        super(connection, tableName, scan, scanMetrics, rpcFactory, replicaId);
    }

    @Override
    public void throwable(Throwable t, boolean retrying) {
        if (this.location != null && this.locationSearchKey != null) {
            this.getConnection().updateCachedLocations(this.getTableName(), this.location.getRegionInfo().getRegionName(), this.locationSearchKey, t, this.location.getServerName());
        }
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        if (reload && this.getTableName() != null && !this.getTableName().equals(TableName.META_TABLE_NAME) && this.getConnection().isTableDisabled(this.getTableName())) {
            throw new TableNotEnabledException(this.getTableName().getNameAsString() + " is disabled.");
        }
        if (!this.instantiated || reload) {
            if (this.scan.includeStartRow() && !ConnectionUtils.isEmptyStartRow(this.getRow())) {
                RegionLocations rl = this.getRegionLocationsForPrepare(this.getRow());
                this.location = this.getLocationForReplica(rl);
                this.locationSearchKey = this.getRow();
            } else {
                byte[] locateStartRow = ConnectionUtils.createCloseRowBefore(this.getRow());
                Pair<HRegionLocation, byte[]> lastRegionAndKey = this.locateLastRegionInRange(locateStartRow, this.getRow());
                this.location = lastRegionAndKey.getFirst();
                this.locationSearchKey = lastRegionAndKey.getSecond();
            }
            if (this.location == null || this.location.getServerName() == null) {
                throw new IOException("Failed to find location, tableName=" + this.getTableName() + ", row=" + Bytes.toStringBinary(this.getRow()) + ", reload=" + reload);
            }
            this.setStub(this.getConnection().getClient(this.getLocation().getServerName()));
            this.checkIfRegionServerIsRemote();
            this.instantiated = true;
        }
        if (reload) {
            ConnectionUtils.incRPCRetriesMetrics(this.scanMetrics, this.isRegionServerRemote);
        }
    }

    private Pair<HRegionLocation, byte[]> locateLastRegionInRange(byte[] startKey, byte[] endKey) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals(endKey, HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo(startKey, endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(startKey) + " > " + Bytes.toStringBinary(endKey));
        }
        HRegionLocation lastRegion = null;
        byte[] lastFoundKey = null;
        byte[] currentKey = startKey;
        do {
            RegionLocations rl;
            if (!(regionLocation = this.getLocationForReplica(rl = this.getRegionLocationsForPrepare(currentKey))).getRegionInfo().containsRow(currentKey)) {
                throw new DoNotRetryIOException("Does hbase:meta exist hole? Locating row " + Bytes.toStringBinary(currentKey) + " returns incorrect region " + regionLocation.getRegionInfo());
            }
            lastFoundKey = currentKey;
            lastRegion = regionLocation;
        } while (!Bytes.equals(currentKey = regionLocation.getRegionInfo().getEndKey(), HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo(currentKey, endKey) < 0));
        return new Pair<HRegionLocation, byte[]>(lastRegion, lastFoundKey);
    }

    @Override
    public ScannerCallable getScannerCallableForReplica(int id) {
        ReversedScannerCallable r = new ReversedScannerCallable(this.getConnection(), this.getTableName(), this.getScan(), this.scanMetrics, this.rpcControllerFactory, id);
        r.setCaching(this.getCaching());
        return r;
    }
}

