/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.Tag;
import org.apache.hudi.org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hudi.org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomFilter;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomFilterFactory;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.Option;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.OptionGroup;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.PosixParser;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
@InterfaceStability.Evolving
public class HFilePrettyPrinter
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(HFilePrettyPrinter.class);
    private Options options = new Options();
    private boolean verbose;
    private boolean printValue;
    private boolean printKey;
    private boolean shouldPrintMeta;
    private boolean printBlockIndex;
    private boolean printBlockHeaders;
    private boolean printStats;
    private boolean checkRow;
    private boolean checkFamily;
    private boolean isSeekToRow = false;
    private boolean checkMobIntegrity = false;
    private Map<String, List<Path>> mobFileLocations;
    private static final int FOUND_MOB_FILES_CACHE_CAPACITY = 50;
    private static final int MISSING_MOB_FILES_CACHE_CAPACITY = 20;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private byte[] row = null;
    private List<Path> files = new ArrayList<Path>();
    private int count;
    private static final String FOUR_SPACES = "    ";

    public HFilePrettyPrinter() {
        this.init();
    }

    public HFilePrettyPrinter(Configuration conf) {
        super(conf);
        this.init();
    }

    private void init() {
        this.options.addOption("v", "verbose", false, "Verbose output; emits file and meta data delimiters");
        this.options.addOption("p", "printkv", false, "Print key/value pairs");
        this.options.addOption("e", "printkey", false, "Print keys");
        this.options.addOption("m", "printmeta", false, "Print meta data of file");
        this.options.addOption("b", "printblocks", false, "Print block index meta data");
        this.options.addOption("h", "printblockheaders", false, "Print block headers for each block.");
        this.options.addOption("k", "checkrow", false, "Enable row order check; looks for out-of-order keys");
        this.options.addOption("a", "checkfamily", false, "Enable family check");
        this.options.addOption("w", "seekToRow", true, "Seek to this row and print all the kvs for this row only");
        this.options.addOption("s", "stats", false, "Print statistics");
        this.options.addOption("i", "checkMobIntegrity", false, "Print all cells whose mob files are missing");
        OptionGroup files = new OptionGroup();
        files.addOption(new Option("f", "file", true, "File to scan. Pass full-path; e.g. hdfs://a:9000/hbase/hbase:meta/12/34"));
        files.addOption(new Option("r", "region", true, "Region to scan. Pass region name; e.g. 'hbase:meta,,1'"));
        this.options.addOptionGroup(files);
    }

    public void setPrintStreams(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    public boolean parseOptions(String[] args) throws ParseException, IOException {
        if (args.length == 0) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("hfile", this.options, true);
            return false;
        }
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.options, args);
        this.verbose = cmd.hasOption("v");
        this.printValue = cmd.hasOption("p");
        this.printKey = cmd.hasOption("e") || this.printValue;
        this.shouldPrintMeta = cmd.hasOption("m");
        this.printBlockIndex = cmd.hasOption("b");
        this.printBlockHeaders = cmd.hasOption("h");
        this.printStats = cmd.hasOption("s");
        this.checkRow = cmd.hasOption("k");
        this.checkFamily = cmd.hasOption("a");
        this.checkMobIntegrity = cmd.hasOption("i");
        if (cmd.hasOption("f")) {
            this.files.add(new Path(cmd.getOptionValue("f")));
        }
        if (cmd.hasOption("w")) {
            String key = cmd.getOptionValue("w");
            if (key != null && key.length() != 0) {
                this.row = Bytes.toBytesBinary(key);
                this.isSeekToRow = true;
            } else {
                this.err.println("Invalid row is specified.");
                System.exit(-1);
            }
        }
        if (cmd.hasOption("r")) {
            String regionName = cmd.getOptionValue("r");
            byte[] rn = Bytes.toBytes(regionName);
            byte[][] hri = HRegionInfo.parseRegionName(rn);
            Path rootDir = CommonFSUtils.getRootDir(this.getConf());
            Path tableDir = CommonFSUtils.getTableDir(rootDir, TableName.valueOf(hri[0]));
            String enc = HRegionInfo.encodeRegionName(rn);
            Path regionDir = new Path(tableDir, enc);
            if (this.verbose) {
                this.out.println("region dir -> " + regionDir);
            }
            List<Path> regionFiles = HFile.getStoreFiles(FileSystem.get((Configuration)this.getConf()), regionDir);
            if (this.verbose) {
                this.out.println("Number of region files found -> " + regionFiles.size());
            }
            if (this.verbose) {
                int i = 1;
                for (Path p : regionFiles) {
                    if (!this.verbose) continue;
                    this.out.println("Found file[" + i++ + "] -> " + p);
                }
            }
            this.files.addAll(regionFiles);
        }
        if (this.checkMobIntegrity) {
            if (this.verbose) {
                System.out.println("checkMobIntegrity is enabled");
            }
            this.mobFileLocations = new HashMap<String, List<Path>>();
        }
        cmd.getArgList().forEach(file -> this.files.add(new Path(file)));
        return true;
    }

    public int run(String[] args) {
        if (this.getConf() == null) {
            throw new RuntimeException("A Configuration instance must be provided.");
        }
        try {
            CommonFSUtils.setFsDefault(this.getConf(), CommonFSUtils.getRootDir(this.getConf()));
            if (!this.parseOptions(args)) {
                return 1;
            }
        }
        catch (IOException ex) {
            LOG.error("Error parsing command-line options", (Throwable)ex);
            return 1;
        }
        catch (ParseException ex) {
            LOG.error("Error parsing command-line options", (Throwable)ex);
            return 1;
        }
        for (Path fileName : this.files) {
            try {
                int exitCode = this.processFile(fileName, false);
                if (exitCode == 0) continue;
                return exitCode;
            }
            catch (IOException ex) {
                LOG.error("Error reading " + fileName, (Throwable)ex);
                return -2;
            }
        }
        if (this.verbose || this.printKey) {
            this.out.println("Scanned kv count -> " + this.count);
        }
        return 0;
    }

    public int processFile(Path file, boolean checkRootDir) throws IOException {
        FileSystem fs;
        if (this.verbose) {
            this.out.println("Scanning -> " + file);
        }
        if (checkRootDir) {
            FileSystem rootFS;
            String qualifiedFile;
            Path rootPath = CommonFSUtils.getRootDir(this.getConf());
            String rootString = rootPath + "/";
            if (!file.toString().startsWith(rootString) && !(qualifiedFile = (rootFS = rootPath.getFileSystem(this.getConf())).getUri().toString() + file.toString()).startsWith(rootString)) {
                this.err.println("ERROR, file (" + file + ") is not in HBase's root directory (" + rootString + ")");
                return -2;
            }
        }
        if (!(fs = file.getFileSystem(this.getConf())).exists(file)) {
            this.err.println("ERROR, file doesnt exist: " + file);
            return -2;
        }
        HFile.Reader reader = HFile.createReader(fs, file, CacheConfig.DISABLED, true, this.getConf());
        HFileInfo fileInfo = reader.getHFileInfo();
        KeyValueStatsCollector fileStats = null;
        if (this.verbose || this.printKey || this.checkRow || this.checkFamily || this.printStats || this.checkMobIntegrity) {
            HFileScanner scanner = reader.getScanner(false, false, false);
            fileStats = new KeyValueStatsCollector();
            boolean shouldScanKeysValues = this.isSeekToRow && !Bytes.equals(this.row, reader.getFirstRowKey().orElse(null)) ? scanner.seekTo(PrivateCellUtil.createFirstOnRow(this.row)) != -1 : scanner.seekTo();
            if (shouldScanKeysValues) {
                this.scanKeysValues(file, fileStats, scanner, this.row);
            }
        }
        if (this.shouldPrintMeta) {
            this.printMeta(reader, fileInfo);
        }
        if (this.printBlockIndex) {
            this.out.println("Block Index:");
            this.out.println(reader.getDataBlockIndexReader());
        }
        if (this.printBlockHeaders) {
            HFileBlock block;
            this.out.println("Block Headers:");
            FSDataInputStreamWrapper fsdis = new FSDataInputStreamWrapper(fs, file);
            long fileSize = fs.getFileStatus(file).getLen();
            FixedFileTrailer trailer = FixedFileTrailer.readFromStream(fsdis.getStream(false), fileSize);
            long max = trailer.getLastDataBlockOffset();
            for (long offset = trailer.getFirstDataBlockOffset(); offset <= max; offset += (long)block.getOnDiskSizeWithHeader()) {
                block = reader.readBlock(offset, -1L, false, false, false, false, null, null);
                this.out.println(block);
            }
        }
        if (this.printStats) {
            fileStats.finish();
            this.out.println("Stats:\n" + fileStats);
        }
        reader.close();
        return 0;
    }

    private void scanKeysValues(Path file, KeyValueStatsCollector fileStats, HFileScanner scanner, byte[] row) throws IOException {
        Cell pCell = null;
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        LinkedHashSet<String> foundMobFiles = new LinkedHashSet<String>(50);
        LinkedHashSet<String> missingMobFiles = new LinkedHashSet<String>(20);
        do {
            Cell cell = scanner.getCell();
            if (row != null && row.length != 0) {
                int result = CellComparator.getInstance().compareRows(cell, row, 0, row.length);
                if (result > 0) break;
                if (result < 0) continue;
            }
            if (this.printStats) {
                fileStats.collect(cell);
            }
            if (this.printKey) {
                this.out.print("K: " + cell);
                if (this.printValue) {
                    this.out.print(" V: " + Bytes.toStringBinary(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
                    int i = 0;
                    List<Tag> tags = PrivateCellUtil.getTags(cell);
                    for (Tag tag : tags) {
                        this.out.print(String.format(" T[%d]: %s", i++, tag.toString()));
                    }
                }
                this.out.println();
            }
            if (this.checkRow && pCell != null && CellComparator.getInstance().compareRows(pCell, cell) > 0) {
                this.err.println("WARNING, previous row is greater then current row\n\tfilename -> " + file + "\n\tprevious -> " + CellUtil.getCellKeyAsString(pCell) + "\n\tcurrent  -> " + CellUtil.getCellKeyAsString(cell));
            }
            if (this.checkFamily) {
                String fam = Bytes.toString(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
                if (!file.toString().contains(fam)) {
                    this.err.println("WARNING, filename does not match kv family,\n\tfilename -> " + file + "\n\tkeyvalue -> " + CellUtil.getCellKeyAsString(cell));
                }
                if (pCell != null && CellComparator.getInstance().compareFamilies(pCell, cell) != 0) {
                    this.err.println("WARNING, previous kv has different family compared to current key\n\tfilename -> " + file + "\n\tprevious -> " + CellUtil.getCellKeyAsString(pCell) + "\n\tcurrent  -> " + CellUtil.getCellKeyAsString(cell));
                }
            }
            if (this.checkMobIntegrity && MobUtils.isMobReferenceCell(cell)) {
                Tag tnTag = MobUtils.getTableNameTag(cell);
                if (tnTag == null) {
                    System.err.println("ERROR, wrong tag format in mob reference cell " + CellUtil.getCellKeyAsString(cell));
                } else if (!MobUtils.hasValidMobRefCellValue(cell)) {
                    System.err.println("ERROR, wrong value format in mob reference cell " + CellUtil.getCellKeyAsString(cell));
                } else {
                    String mobFileName;
                    TableName tn = TableName.valueOf(Tag.cloneValue(tnTag));
                    boolean exist = this.mobFileExists(fs, tn, mobFileName = MobUtils.getMobFileName(cell), Bytes.toString(CellUtil.cloneFamily(cell)), foundMobFiles, missingMobFiles);
                    if (!exist) {
                        System.err.println("ERROR, the mob file [" + mobFileName + "] is missing referenced by cell " + CellUtil.getCellKeyAsString(cell));
                    }
                }
            }
            pCell = cell;
            ++this.count;
        } while (scanner.next());
    }

    private boolean mobFileExists(FileSystem fs, TableName tn, String mobFileName, String family, Set<String> foundMobFiles, Set<String> missingMobFiles) throws IOException {
        if (foundMobFiles.contains(mobFileName)) {
            return true;
        }
        if (missingMobFiles.contains(mobFileName)) {
            return false;
        }
        String tableName = tn.getNameAsString();
        List<Path> locations = this.mobFileLocations.get(tableName);
        if (locations == null) {
            locations = new ArrayList<Path>(2);
            locations.add(MobUtils.getMobFamilyPath(this.getConf(), tn, family));
            locations.add(HFileArchiveUtil.getStoreArchivePath(this.getConf(), tn, MobUtils.getMobRegionInfo(tn).getEncodedName(), family));
            this.mobFileLocations.put(tn.getNameAsString(), locations);
        }
        boolean exist = false;
        for (Path location : locations) {
            Path mobFilePath = new Path(location, mobFileName);
            if (!fs.exists(mobFilePath)) continue;
            exist = true;
            break;
        }
        if (exist) {
            this.evictMobFilesIfNecessary(foundMobFiles, 50);
            foundMobFiles.add(mobFileName);
        } else {
            this.evictMobFilesIfNecessary(missingMobFiles, 20);
            missingMobFiles.add(mobFileName);
        }
        return exist;
    }

    private void evictMobFilesIfNecessary(Set<String> mobFileNames, int limit) {
        if (mobFileNames.size() < limit) {
            return;
        }
        int evict = limit / 2;
        Iterator<String> fileNamesItr = mobFileNames.iterator();
        for (int index = 0; index < evict && fileNamesItr.hasNext(); ++index) {
            fileNamesItr.next();
            fileNamesItr.remove();
        }
    }

    private static String asSeparateLines(String keyValueStr) {
        return keyValueStr.replaceAll(", ([a-zA-Z]+=)", ",\n    $1");
    }

    private void printMeta(HFile.Reader reader, Map<byte[], byte[]> fileInfo) throws IOException {
        this.out.println("Block index size as per heapsize: " + reader.indexSize());
        this.out.println(HFilePrettyPrinter.asSeparateLines(reader.toString()));
        this.out.println("Trailer:\n    " + HFilePrettyPrinter.asSeparateLines(reader.getTrailer().toString()));
        this.out.println("Fileinfo:");
        for (Map.Entry<byte[], byte[]> e : fileInfo.entrySet()) {
            this.out.print(FOUR_SPACES + Bytes.toString(e.getKey()) + " = ");
            if (Bytes.equals(e.getKey(), HStoreFile.MAX_SEQ_ID_KEY) || Bytes.equals(e.getKey(), HStoreFile.DELETE_FAMILY_COUNT) || Bytes.equals(e.getKey(), HStoreFile.EARLIEST_PUT_TS) || Bytes.equals(e.getKey(), HFileWriterImpl.MAX_MEMSTORE_TS_KEY) || Bytes.equals(e.getKey(), HFileInfo.CREATE_TIME_TS) || Bytes.equals(e.getKey(), HStoreFile.BULKLOAD_TIME_KEY)) {
                this.out.println(Bytes.toLong(e.getValue()));
                continue;
            }
            if (Bytes.equals(e.getKey(), HStoreFile.TIMERANGE_KEY)) {
                TimeRangeTracker timeRangeTracker = TimeRangeTracker.parseFrom(e.getValue());
                this.out.println(timeRangeTracker.getMin() + "...." + timeRangeTracker.getMax());
                continue;
            }
            if (Bytes.equals(e.getKey(), HFileInfo.AVG_KEY_LEN) || Bytes.equals(e.getKey(), HFileInfo.AVG_VALUE_LEN) || Bytes.equals(e.getKey(), HFileWriterImpl.KEY_VALUE_VERSION) || Bytes.equals(e.getKey(), HFileInfo.MAX_TAGS_LEN)) {
                this.out.println(Bytes.toInt(e.getValue()));
                continue;
            }
            if (Bytes.equals(e.getKey(), HStoreFile.MAJOR_COMPACTION_KEY) || Bytes.equals(e.getKey(), HFileInfo.TAGS_COMPRESSED) || Bytes.equals(e.getKey(), HStoreFile.EXCLUDE_FROM_MINOR_COMPACTION_KEY)) {
                this.out.println(Bytes.toBoolean(e.getValue()));
                continue;
            }
            if (Bytes.equals(e.getKey(), HFileInfo.LASTKEY)) {
                this.out.println(new KeyValue.KeyOnlyKeyValue(e.getValue()).toString());
                continue;
            }
            this.out.println(Bytes.toStringBinary(e.getValue()));
        }
        try {
            this.out.println("Mid-key: " + reader.midKey().map(CellUtil::getCellKeyAsString));
        }
        catch (Exception e) {
            this.out.println("Unable to retrieve the midkey");
        }
        DataInput bloomMeta = reader.getGeneralBloomFilterMetadata();
        BloomFilter bloomFilter = null;
        if (bloomMeta != null) {
            bloomFilter = BloomFilterFactory.createFromMeta(bloomMeta, reader);
        }
        this.out.println("Bloom filter:");
        if (bloomFilter != null) {
            this.out.println(FOUR_SPACES + bloomFilter.toString().replaceAll("; ", "\n    "));
        } else {
            this.out.println("    Not present");
        }
        bloomMeta = reader.getDeleteBloomFilterMetadata();
        bloomFilter = null;
        if (bloomMeta != null) {
            bloomFilter = BloomFilterFactory.createFromMeta(bloomMeta, reader);
        }
        this.out.println("Delete Family Bloom filter:");
        if (bloomFilter != null) {
            this.out.println(FOUR_SPACES + bloomFilter.toString().replaceAll("; ", "\n    "));
        } else {
            this.out.println("    Not present");
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hfile.block.cache.size", 0.0f);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new HFilePrettyPrinter(), (String[])args);
        System.exit(ret);
    }

    private static class SimpleReporter
    extends ScheduledReporter {
        private final PrintStream output;
        private final Locale locale;
        private final DateFormat dateFormat;

        public static Builder forRegistry(MetricRegistry registry) {
            return new Builder(registry);
        }

        private SimpleReporter(MetricRegistry registry, PrintStream output, Locale locale, TimeZone timeZone, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
            super(registry, "simple-reporter", filter, rateUnit, durationUnit);
            this.output = output;
            this.locale = locale;
            this.dateFormat = DateFormat.getDateTimeInstance(3, 2, locale);
            this.dateFormat.setTimeZone(timeZone);
        }

        public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
            if (!histograms.isEmpty()) {
                for (Map.Entry<String, Histogram> entry : histograms.entrySet()) {
                    this.output.print("   " + StringUtils.substringAfterLast((String)entry.getKey(), (String)"."));
                    this.output.println(':');
                    this.printHistogram(entry.getValue());
                }
                this.output.println();
            }
            this.output.println();
            this.output.flush();
        }

        private void printHistogram(Histogram histogram) {
            Snapshot snapshot = histogram.getSnapshot();
            this.output.printf(this.locale, "               min = %d%n", snapshot.getMin());
            this.output.printf(this.locale, "               max = %d%n", snapshot.getMax());
            this.output.printf(this.locale, "              mean = %2.2f%n", snapshot.getMean());
            this.output.printf(this.locale, "            stddev = %2.2f%n", snapshot.getStdDev());
            this.output.printf(this.locale, "            median = %2.2f%n", snapshot.getMedian());
            this.output.printf(this.locale, "              75%% <= %2.2f%n", snapshot.get75thPercentile());
            this.output.printf(this.locale, "              95%% <= %2.2f%n", snapshot.get95thPercentile());
            this.output.printf(this.locale, "              98%% <= %2.2f%n", snapshot.get98thPercentile());
            this.output.printf(this.locale, "              99%% <= %2.2f%n", snapshot.get99thPercentile());
            this.output.printf(this.locale, "            99.9%% <= %2.2f%n", snapshot.get999thPercentile());
            this.output.printf(this.locale, "             count = %d%n", histogram.getCount());
        }

        public static class Builder {
            private final MetricRegistry registry;
            private PrintStream output;
            private Locale locale;
            private TimeZone timeZone;
            private TimeUnit rateUnit;
            private TimeUnit durationUnit;
            private MetricFilter filter;

            private Builder(MetricRegistry registry) {
                this.registry = registry;
                this.output = System.out;
                this.locale = Locale.getDefault();
                this.timeZone = TimeZone.getDefault();
                this.rateUnit = TimeUnit.SECONDS;
                this.durationUnit = TimeUnit.MILLISECONDS;
                this.filter = MetricFilter.ALL;
            }

            public Builder outputTo(PrintStream output) {
                this.output = output;
                return this;
            }

            public Builder filter(MetricFilter filter) {
                this.filter = filter;
                return this;
            }

            public SimpleReporter build() {
                return new SimpleReporter(this.registry, this.output, this.locale, this.timeZone, this.rateUnit, this.durationUnit, this.filter);
            }
        }
    }

    private static class KeyValueStatsCollector {
        private final MetricRegistry metricsRegistry = new MetricRegistry();
        private final ByteArrayOutputStream metricsOutput = new ByteArrayOutputStream();
        private final SimpleReporter simpleReporter = SimpleReporter.forRegistry(this.metricsRegistry).outputTo(new PrintStream(this.metricsOutput)).filter(MetricFilter.ALL).build();
        Histogram keyLen = this.metricsRegistry.histogram(MetricRegistry.name(HFilePrettyPrinter.class, (String[])new String[]{"Key length"}));
        Histogram valLen = this.metricsRegistry.histogram(MetricRegistry.name(HFilePrettyPrinter.class, (String[])new String[]{"Val length"}));
        Histogram rowSizeBytes = this.metricsRegistry.histogram(MetricRegistry.name(HFilePrettyPrinter.class, (String[])new String[]{"Row size (bytes)"}));
        Histogram rowSizeCols = this.metricsRegistry.histogram(MetricRegistry.name(HFilePrettyPrinter.class, (String[])new String[]{"Row size (columns)"}));
        long curRowBytes = 0L;
        long curRowCols = 0L;
        byte[] biggestRow = null;
        private Cell prevCell = null;
        private long maxRowBytes = 0L;
        private long curRowKeyLength;

        private KeyValueStatsCollector() {
        }

        public void collect(Cell cell) {
            this.valLen.update(cell.getValueLength());
            if (this.prevCell != null && CellComparator.getInstance().compareRows(this.prevCell, cell) != 0) {
                this.collectRow();
            }
            this.curRowBytes += (long)cell.getSerializedSize();
            this.curRowKeyLength = KeyValueUtil.keyLength(cell);
            ++this.curRowCols;
            this.prevCell = cell;
        }

        private void collectRow() {
            this.rowSizeBytes.update(this.curRowBytes);
            this.rowSizeCols.update(this.curRowCols);
            this.keyLen.update(this.curRowKeyLength);
            if (this.curRowBytes > this.maxRowBytes && this.prevCell != null) {
                this.biggestRow = CellUtil.cloneRow(this.prevCell);
                this.maxRowBytes = this.curRowBytes;
            }
            this.curRowBytes = 0L;
            this.curRowCols = 0L;
        }

        public void finish() {
            if (this.curRowCols > 0L) {
                this.collectRow();
            }
        }

        public String toString() {
            if (this.prevCell == null) {
                return "no data available for statistics";
            }
            this.simpleReporter.stop();
            this.simpleReporter.report();
            return this.metricsOutput.toString() + "Key of biggest row: " + Bytes.toStringBinary(this.biggestRow);
        }
    }
}

