/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BucketCacheStats
extends CacheStats {
    private final LongAdder ioHitCount = new LongAdder();
    private final LongAdder ioHitTime = new LongAdder();
    private static final long NANO_TIME = TimeUnit.MILLISECONDS.toNanos(1L);
    private long lastLogTime = EnvironmentEdgeManager.currentTime();
    private LongAdder allocationFailCount = new LongAdder();

    BucketCacheStats() {
        super("BucketCache");
        this.allocationFailCount.reset();
    }

    @Override
    public String toString() {
        return super.toString() + ", ioHitsPerSecond=" + this.getIOHitsPerSecond() + ", ioTimePerHit=" + this.getIOTimePerHit() + ", allocationFailCount=" + this.getAllocationFailCount();
    }

    public void ioHit(long time) {
        this.ioHitCount.increment();
        this.ioHitTime.add(time);
    }

    public long getIOHitsPerSecond() {
        long now = EnvironmentEdgeManager.currentTime();
        long took = (now - this.lastLogTime) / 1000L;
        this.lastLogTime = now;
        return took == 0L ? 0L : this.ioHitCount.sum() / took;
    }

    public double getIOTimePerHit() {
        long time = this.ioHitTime.sum() / NANO_TIME;
        long count = this.ioHitCount.sum();
        return (float)time / (float)count;
    }

    public void reset() {
        this.ioHitCount.reset();
        this.ioHitTime.reset();
        this.allocationFailCount.reset();
    }

    public long getAllocationFailCount() {
        return this.allocationFailCount.sum();
    }

    public void allocationFailed() {
        this.allocationFailCount.increment();
    }
}

