/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.quotas;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.NoopQuotaLimiter;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaLimiterFactory;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="FindBugs seems confused; says globalLimiter and lastUpdate are mostly synchronized...but to me it looks like they are totally synchronized")
public class QuotaState {
    protected long lastUpdate = 0L;
    protected long lastQuery = 0L;
    protected QuotaLimiter globalLimiter = NoopQuotaLimiter.get();

    public QuotaState() {
        this(0L);
    }

    public QuotaState(long updateTs) {
        this.lastUpdate = updateTs;
    }

    public synchronized long getLastUpdate() {
        return this.lastUpdate;
    }

    public synchronized long getLastQuery() {
        return this.lastQuery;
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("QuotaState(ts=" + this.getLastUpdate());
        if (this.isBypass()) {
            builder.append(" bypass");
        } else if (this.globalLimiter != NoopQuotaLimiter.get()) {
            builder.append(" " + this.globalLimiter);
        }
        builder.append(')');
        return builder.toString();
    }

    public synchronized boolean isBypass() {
        return this.globalLimiter == NoopQuotaLimiter.get();
    }

    public synchronized void setQuotas(QuotaProtos.Quotas quotas) {
        this.globalLimiter = quotas.hasThrottle() ? QuotaLimiterFactory.fromThrottle(quotas.getThrottle()) : NoopQuotaLimiter.get();
    }

    public synchronized void update(QuotaState other) {
        this.globalLimiter = this.globalLimiter == NoopQuotaLimiter.get() ? other.globalLimiter : (other.globalLimiter == NoopQuotaLimiter.get() ? NoopQuotaLimiter.get() : QuotaLimiterFactory.update(this.globalLimiter, other.globalLimiter));
        this.lastUpdate = other.lastUpdate;
    }

    public synchronized QuotaLimiter getGlobalLimiter() {
        this.lastQuery = EnvironmentEdgeManager.currentTime();
        return this.globalLimiter;
    }

    synchronized QuotaLimiter getGlobalLimiterWithoutUpdatingLastQuery() {
        return this.globalLimiter;
    }
}

