/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.quotas.policies;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.policies.NoWritesViolationPolicyEnforcement;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NoWritesCompactionsViolationPolicyEnforcement
extends NoWritesViolationPolicyEnforcement {
    private static final Logger LOG = LoggerFactory.getLogger(NoWritesCompactionsViolationPolicyEnforcement.class);
    private AtomicBoolean disableCompactions = new AtomicBoolean(false);

    @Override
    public synchronized void enable() {
        boolean ret = this.disableCompactions.compareAndSet(false, true);
        if (!ret && LOG.isTraceEnabled()) {
            LOG.trace("Compactions were already disabled upon enabling the policy");
        }
    }

    @Override
    public synchronized void disable() {
        boolean ret = this.disableCompactions.compareAndSet(true, false);
        if (!ret && LOG.isTraceEnabled()) {
            LOG.trace("Compactions were already enabled upon disabling the policy");
        }
    }

    @Override
    public String getPolicyName() {
        return SpaceViolationPolicy.NO_WRITES_COMPACTIONS.name();
    }

    @Override
    public boolean areCompactionsDisabled() {
        return this.disableCompactions.get();
    }
}

