/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.CSLMImmutableSegment;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.CellArrayMap;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreCompactionStrategy;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hudi.org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CellArrayImmutableSegment
extends ImmutableSegment {
    public static final long DEEP_OVERHEAD_CAM = DEEP_OVERHEAD + (long)ClassSize.CELL_ARRAY_MAP;

    protected CellArrayImmutableSegment(CellComparator comparator, MemStoreSegmentsIterator iterator, MemStoreLAB memStoreLAB, int numOfCells, MemStoreCompactionStrategy.Action action) {
        super(null, comparator, memStoreLAB);
        this.incMemStoreSize(0L, DEEP_OVERHEAD_CAM, 0L, 0);
        this.initializeCellSet(numOfCells, iterator, action);
    }

    protected CellArrayImmutableSegment(CSLMImmutableSegment segment, MemStoreSizing mss, MemStoreCompactionStrategy.Action action) {
        super(segment);
        long indexOverhead = DEEP_OVERHEAD_CAM - CSLMImmutableSegment.DEEP_OVERHEAD_CSLM;
        this.incMemStoreSize(0L, indexOverhead, 0L, 0);
        mss.incMemStoreSize(0L, indexOverhead, 0L, 0);
        int numOfCells = segment.getCellsCount();
        this.reinitializeCellSet(numOfCells, segment.getScanner(Long.MAX_VALUE), segment.getCellSet(), action);
        long newSegmentSizeDelta = (long)numOfCells * (this.indexEntrySize() - (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY);
        this.incMemStoreSize(0L, newSegmentSizeDelta, 0L, 0);
        mss.incMemStoreSize(0L, newSegmentSizeDelta, 0L, 0);
    }

    @Override
    protected long indexEntrySize() {
        return ClassSize.CELL_ARRAY_MAP_ENTRY;
    }

    @Override
    protected boolean canBeFlattened() {
        return false;
    }

    private void initializeCellSet(int numOfCells, MemStoreSegmentsIterator iterator, MemStoreCompactionStrategy.Action action) {
        boolean merge = action == MemStoreCompactionStrategy.Action.MERGE || action == MemStoreCompactionStrategy.Action.MERGE_COUNT_UNIQUE_KEYS;
        Cell[] cells = new Cell[numOfCells];
        int i = 0;
        int numUniqueKeys = 0;
        Cell prev = null;
        while (iterator.hasNext()) {
            Cell c = (Cell)iterator.next();
            cells[i] = merge ? c : this.maybeCloneWithAllocator(c, false);
            this.updateMetaInfo(cells[i], true, null);
            if (action == MemStoreCompactionStrategy.Action.MERGE_COUNT_UNIQUE_KEYS) {
                if (prev != null) {
                    if (!CellUtil.matchingRowColumnBytes(prev, c)) {
                        ++numUniqueKeys;
                    }
                } else {
                    ++numUniqueKeys;
                }
            }
            prev = c;
            ++i;
        }
        if (action == MemStoreCompactionStrategy.Action.COMPACT) {
            numUniqueKeys = numOfCells;
        } else if (action != MemStoreCompactionStrategy.Action.MERGE_COUNT_UNIQUE_KEYS) {
            numUniqueKeys = -1;
        }
        CellArrayMap cam = new CellArrayMap(this.getComparator(), cells, 0, i, false);
        this.setCellSet(null, new CellSet(cam, numUniqueKeys));
    }

    private void reinitializeCellSet(int numOfCells, KeyValueScanner segmentScanner, CellSet oldCellSet, MemStoreCompactionStrategy.Action action) {
        Cell[] cells = new Cell[numOfCells];
        int idx = 0;
        int numUniqueKeys = 0;
        Cell prev = null;
        try {
            Cell curCell;
            while ((curCell = segmentScanner.next()) != null) {
                cells[idx++] = curCell;
                if (action == MemStoreCompactionStrategy.Action.FLATTEN_COUNT_UNIQUE_KEYS) {
                    if (prev != null) {
                        if (!CellUtil.matchingRowColumn(prev, curCell)) {
                            ++numUniqueKeys;
                        }
                    } else {
                        ++numUniqueKeys;
                    }
                }
                prev = curCell;
            }
        }
        catch (IOException ie) {
            throw new IllegalStateException(ie);
        }
        finally {
            segmentScanner.close();
        }
        if (action != MemStoreCompactionStrategy.Action.FLATTEN_COUNT_UNIQUE_KEYS) {
            numUniqueKeys = -1;
        }
        CellArrayMap cam = new CellArrayMap(this.getComparator(), cells, 0, idx, false);
        this.setCellSet(oldCellSet, new CellSet(cam, numUniqueKeys));
    }
}

