/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.AsyncProtobufLogWriter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.SecureAsyncProtobufLogWriter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogWriter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.SecureWALCellCodec;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hudi.org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.EncryptionTest;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class SecureProtobufLogReader
extends ProtobufLogReader {
    private static final Logger LOG = LoggerFactory.getLogger(SecureProtobufLogReader.class);
    private Decryptor decryptor = null;
    private static List<String> writerClsNames = new ArrayList<String>();

    @Override
    public List<String> getWriterClsNames() {
        return writerClsNames;
    }

    @Override
    protected ProtobufLogReader.WALHdrContext readHeader(WALProtos.WALHeader.Builder builder, FSDataInputStream stream) throws IOException {
        ProtobufLogReader.WALHdrContext hdrCtxt = super.readHeader(builder, stream);
        ProtobufLogReader.WALHdrResult result = hdrCtxt.getResult();
        if (result == ProtobufLogReader.WALHdrResult.SUCCESS && builder.hasEncryptionKey()) {
            Cipher cipher;
            EncryptionTest.testKeyProvider(this.conf);
            EncryptionTest.testCipherProvider(this.conf);
            byte[] keyBytes = builder.getEncryptionKey().toByteArray();
            Key key = null;
            String walKeyName = this.conf.get("hbase.crypto.wal.key.name");
            if (walKeyName != null) {
                try {
                    key = EncryptionUtil.unwrapWALKey(this.conf, walKeyName, keyBytes);
                }
                catch (KeyException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unable to unwrap key with WAL key '" + walKeyName + "'");
                    }
                    key = null;
                }
            }
            if (key == null) {
                String masterKeyName = this.conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName());
                try {
                    key = EncryptionUtil.unwrapWALKey(this.conf, masterKeyName, keyBytes);
                }
                catch (KeyException e) {
                    String alternateKeyName;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unable to unwrap key with current master key '" + masterKeyName + "'");
                    }
                    if ((alternateKeyName = this.conf.get("hbase.crypto.master.alternate.key.name")) != null) {
                        try {
                            key = EncryptionUtil.unwrapWALKey(this.conf, alternateKeyName, keyBytes);
                        }
                        catch (KeyException ex) {
                            throw new IOException(ex);
                        }
                    }
                    throw new IOException(e);
                }
            }
            if ((cipher = Encryption.getCipher(this.conf, key.getAlgorithm())) == null) {
                throw new IOException("Cipher '" + key.getAlgorithm() + "' is not available");
            }
            this.decryptor = cipher.getDecryptor();
            this.decryptor.setKey(key);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Initialized secure protobuf WAL: cipher=" + cipher.getName());
            }
        }
        return hdrCtxt;
    }

    @Override
    protected void initAfterCompression(String cellCodecClsName) throws IOException {
        if (this.decryptor != null && cellCodecClsName.equals(SecureWALCellCodec.class.getName())) {
            WALCellCodec codec = SecureWALCellCodec.getCodec(this.conf, this.decryptor);
            this.cellDecoder = codec.getDecoder((InputStream)this.inputStream);
            this.compressionContext = null;
            this.byteStringUncompressor = WALCellCodec.getNoneUncompressor();
            this.hasCompression = false;
        } else {
            super.initAfterCompression(cellCodecClsName);
        }
    }

    static {
        writerClsNames.add(ProtobufLogWriter.class.getSimpleName());
        writerClsNames.add(SecureProtobufLogWriter.class.getSimpleName());
        writerClsNames.add(AsyncProtobufLogWriter.class.getSimpleName());
        writerClsNames.add(SecureAsyncProtobufLogWriter.class.getSimpleName());
    }
}

