/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.tool;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class WriteSinkCoprocessor
implements RegionCoprocessor,
RegionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(WriteSinkCoprocessor.class);
    private final AtomicLong ops = new AtomicLong();
    private String regionName;

    @Override
    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    @Override
    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        this.regionName = e.getEnvironment().getRegion().getRegionInfo().getRegionNameAsString();
    }

    @Override
    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (this.ops.incrementAndGet() % 20000L == 0L) {
            LOG.info("Wrote " + this.ops.get() + " times in region " + this.regionName);
        }
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SUCCESS));
        }
        c.bypass();
    }
}

