/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.commons.io.IOUtils;
import org.apache.hudi.org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.client.Admin;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.master.RackManager;
import org.apache.hudi.org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hadoop.hbase.util.MoveWithAck;
import org.apache.hudi.org.apache.hadoop.hbase.util.MoveWithoutAck;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class RegionMover
extends AbstractHBaseTool
implements Closeable {
    public static final String MOVE_RETRIES_MAX_KEY = "hbase.move.retries.max";
    public static final String MOVE_WAIT_MAX_KEY = "hbase.move.wait.max";
    public static final String SERVERSTART_WAIT_MAX_KEY = "hbase.serverstart.wait.max";
    public static final int DEFAULT_MOVE_RETRIES_MAX = 5;
    public static final int DEFAULT_MOVE_WAIT_MAX = 60;
    public static final int DEFAULT_SERVERSTART_WAIT_MAX = 180;
    private static final Logger LOG = LoggerFactory.getLogger(RegionMover.class);
    private RegionMoverBuilder rmbuilder;
    private boolean ack = true;
    private int maxthreads = 1;
    private int timeout;
    private String loadUnload;
    private String hostname;
    private String filename;
    private String excludeFile;
    private String designatedFile;
    private int port;
    private Connection conn;
    private Admin admin;
    private RackManager rackManager;

    private RegionMover(RegionMoverBuilder builder) throws IOException {
        this.hostname = builder.hostname;
        this.filename = builder.filename;
        this.excludeFile = builder.excludeFile;
        this.designatedFile = builder.designatedFile;
        this.maxthreads = builder.maxthreads;
        this.ack = builder.ack;
        this.port = builder.port;
        this.timeout = builder.timeout;
        this.setConf(builder.conf);
        this.conn = ConnectionFactory.createConnection(this.conf);
        this.admin = this.conn.getAdmin();
        this.rackManager = builder.rackManager == null ? new RackManager(this.conf) : builder.rackManager;
    }

    private RegionMover() {
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.admin, e -> LOG.warn("failed to close admin", (Throwable)e));
        IOUtils.closeQuietly((Closeable)this.conn, e -> LOG.warn("failed to close conn", (Throwable)e));
    }

    public boolean load() throws ExecutionException, InterruptedException, TimeoutException {
        Future<Boolean> loadTask;
        ExecutorService loadPool = Executors.newFixedThreadPool(1);
        boolean isMetaMoved = this.waitTaskToFinish(loadPool, loadTask = loadPool.submit(this.getMetaRegionMovePlan()), "loading");
        if (!isMetaMoved) {
            return false;
        }
        loadPool = Executors.newFixedThreadPool(1);
        loadTask = loadPool.submit(this.getNonMetaRegionsMovePlan());
        return this.waitTaskToFinish(loadPool, loadTask, "loading");
    }

    private Callable<Boolean> getMetaRegionMovePlan() {
        return this.getRegionsMovePlan(true);
    }

    private Callable<Boolean> getNonMetaRegionsMovePlan() {
        return this.getRegionsMovePlan(false);
    }

    private Callable<Boolean> getRegionsMovePlan(boolean moveMetaRegion) {
        return () -> {
            try {
                List<RegionInfo> regionsToMove = this.readRegionsFromFile(this.filename);
                if (regionsToMove.isEmpty()) {
                    LOG.info("No regions to load.Exiting");
                    return true;
                }
                Optional<RegionInfo> metaRegion = this.getMetaRegionInfoIfToBeMoved(regionsToMove);
                if (moveMetaRegion) {
                    if (metaRegion.isPresent()) {
                        this.loadRegions(Collections.singletonList(metaRegion.get()));
                    }
                } else {
                    metaRegion.ifPresent(regionsToMove::remove);
                    this.loadRegions(regionsToMove);
                }
            }
            catch (Exception e) {
                LOG.error("Error while loading regions to " + this.hostname, (Throwable)e);
                return false;
            }
            return true;
        };
    }

    private Optional<RegionInfo> getMetaRegionInfoIfToBeMoved(List<RegionInfo> regionsToMove) {
        return regionsToMove.stream().filter(RegionInfo::isMetaRegion).findFirst();
    }

    private void loadRegions(List<RegionInfo> regionsToMove) throws Exception {
        ServerName server = this.getTargetServer();
        List<RegionInfo> movedRegions = Collections.synchronizedList(new ArrayList());
        LOG.info("Moving " + regionsToMove.size() + " regions to " + server + " using " + this.maxthreads + " threads.Ack mode:" + this.ack);
        ExecutorService moveRegionsPool = Executors.newFixedThreadPool(this.maxthreads);
        ArrayList<Future<Boolean>> taskList = new ArrayList<Future<Boolean>>();
        int counter = 0;
        while (counter < regionsToMove.size()) {
            Future<Boolean> task;
            RegionInfo region = regionsToMove.get(counter);
            ServerName currentServer = MoveWithAck.getServerNameForRegion(region, this.admin, this.conn);
            if (currentServer == null) {
                LOG.warn("Could not get server for Region:" + region.getRegionNameAsString() + " moving on");
                ++counter;
                continue;
            }
            if (server.equals(currentServer)) {
                LOG.info("Region " + region.getRegionNameAsString() + " is already on target server=" + server);
                ++counter;
                continue;
            }
            if (this.ack) {
                task = moveRegionsPool.submit(new MoveWithAck(this.conn, region, currentServer, server, movedRegions));
                taskList.add(task);
            } else {
                task = moveRegionsPool.submit(new MoveWithoutAck(this.admin, region, currentServer, server, movedRegions));
                taskList.add(task);
            }
            ++counter;
        }
        moveRegionsPool.shutdown();
        long timeoutInSeconds = (long)regionsToMove.size() * this.admin.getConfiguration().getLong(MOVE_WAIT_MAX_KEY, 60L);
        this.waitMoveTasksToFinish(moveRegionsPool, taskList, timeoutInSeconds);
    }

    public boolean unload() throws InterruptedException, ExecutionException, TimeoutException {
        return this.unloadRegions(false);
    }

    public boolean unloadFromRack() throws InterruptedException, ExecutionException, TimeoutException {
        return this.unloadRegions(true);
    }

    private boolean unloadRegions(boolean unloadFromRack) throws InterruptedException, ExecutionException, TimeoutException {
        this.deleteFile(this.filename);
        ExecutorService unloadPool = Executors.newFixedThreadPool(1);
        Future<Boolean> unloadTask = unloadPool.submit(() -> {
            List<RegionInfo> movedRegions = Collections.synchronizedList(new ArrayList());
            try {
                HashSet<ServerName> decommissionedRS;
                ArrayList<ServerName> regionServers = new ArrayList<ServerName>();
                regionServers.addAll(this.admin.getRegionServers());
                ServerName server = this.stripServer(regionServers, this.hostname, this.port);
                if (server == null) {
                    LOG.info("Could not find server '{}:{}' in the set of region servers. giving up.", (Object)this.hostname, (Object)this.port);
                    LOG.debug("List of region servers: {}", regionServers);
                    Boolean bl = false;
                    return bl;
                }
                this.includeExcludeRegionServers(this.designatedFile, regionServers, true);
                this.includeExcludeRegionServers(this.excludeFile, regionServers, false);
                if (unloadFromRack) {
                    String sourceRack = this.rackManager.getRack(server);
                    List<String> racks = this.rackManager.getRack(regionServers);
                    Iterator iterator = regionServers.iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        iterator.next();
                        if (racks.size() > i && racks.get(i) != null && racks.get(i).equals(sourceRack)) {
                            iterator.remove();
                        }
                        ++i;
                    }
                }
                if (CollectionUtils.isNotEmpty(decommissionedRS = new HashSet<ServerName>(this.admin.listDecommissionedRegionServers()))) {
                    regionServers.removeIf(decommissionedRS::contains);
                    LOG.debug("Excluded RegionServers from unloading regions to because they are marked as decommissioned. Servers: {}", decommissionedRS);
                }
                this.stripMaster(regionServers);
                if (regionServers.isEmpty()) {
                    LOG.warn("No Regions were moved - no servers available");
                    Boolean bl = false;
                    return bl;
                }
                this.unloadRegions(server, regionServers, movedRegions);
            }
            catch (Exception e) {
                LOG.error("Error while unloading regions ", (Throwable)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                if (movedRegions != null) {
                    this.writeFile(this.filename, movedRegions);
                }
            }
            return true;
        });
        return this.waitTaskToFinish(unloadPool, unloadTask, "unloading");
    }

    private void unloadRegions(ServerName server, List<ServerName> regionServers, List<RegionInfo> movedRegions) throws Exception {
        while (true) {
            List<RegionInfo> regionsToMove = this.admin.getRegions(server);
            regionsToMove.removeAll(movedRegions);
            if (regionsToMove.isEmpty()) break;
            LOG.info("Moving {} regions from {} to {} servers using {} threads .Ack Mode: {}", new Object[]{regionsToMove.size(), this.hostname, regionServers.size(), this.maxthreads, this.ack});
            Optional<RegionInfo> metaRegion = this.getMetaRegionInfoIfToBeMoved(regionsToMove);
            if (metaRegion.isPresent()) {
                RegionInfo meta = metaRegion.get();
                this.submitRegionMovesWhileUnloading(server, regionServers, movedRegions, Collections.singletonList(meta));
                regionsToMove.remove(meta);
            }
            this.submitRegionMovesWhileUnloading(server, regionServers, movedRegions, regionsToMove);
        }
        LOG.info("No Regions to move....Quitting now");
    }

    private void submitRegionMovesWhileUnloading(ServerName server, List<ServerName> regionServers, List<RegionInfo> movedRegions, List<RegionInfo> regionsToMove) throws Exception {
        ExecutorService moveRegionsPool = Executors.newFixedThreadPool(this.maxthreads);
        ArrayList<Future<Boolean>> taskList = new ArrayList<Future<Boolean>>();
        int serverIndex = 0;
        for (RegionInfo regionToMove : regionsToMove) {
            Future<Boolean> task;
            if (this.ack) {
                task = moveRegionsPool.submit(new MoveWithAck(this.conn, regionToMove, server, regionServers.get(serverIndex), movedRegions));
                taskList.add(task);
            } else {
                task = moveRegionsPool.submit(new MoveWithoutAck(this.admin, regionToMove, server, regionServers.get(serverIndex), movedRegions));
                taskList.add(task);
            }
            serverIndex = (serverIndex + 1) % regionServers.size();
        }
        moveRegionsPool.shutdown();
        long timeoutInSeconds = (long)regionsToMove.size() * this.admin.getConfiguration().getLong(MOVE_WAIT_MAX_KEY, 60L);
        this.waitMoveTasksToFinish(moveRegionsPool, taskList, timeoutInSeconds);
    }

    private boolean waitTaskToFinish(ExecutorService pool, Future<Boolean> task, String operation) throws TimeoutException, InterruptedException, ExecutionException {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(this.timeout, TimeUnit.SECONDS)) {
                LOG.warn("Timed out before finishing the " + operation + " operation. Timeout: " + this.timeout + "sec");
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        try {
            return task.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while " + operation + " Regions on " + this.hostname, (Throwable)e);
            throw e;
        }
        catch (ExecutionException e) {
            LOG.error("Error while " + operation + " regions on RegionServer " + this.hostname, (Throwable)e);
            throw e;
        }
    }

    private void waitMoveTasksToFinish(ExecutorService moveRegionsPool, List<Future<Boolean>> taskList, long timeoutInSeconds) throws Exception {
        try {
            if (!moveRegionsPool.awaitTermination(timeoutInSeconds, TimeUnit.SECONDS)) {
                moveRegionsPool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            moveRegionsPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        for (Future<Boolean> future : taskList) {
            try {
                if (future.get(5L, TimeUnit.SECONDS).booleanValue()) continue;
                LOG.error("Was Not able to move region....Exiting Now");
                throw new Exception("Could not move region Exception");
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for Thread to Complete " + e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (ExecutionException e) {
                boolean ignoreFailure = this.ignoreRegionMoveFailure(e);
                if (ignoreFailure) {
                    LOG.debug("Ignore region move failure, it might have been split/merged.", (Throwable)e);
                    continue;
                }
                LOG.error("Got Exception From Thread While moving region {}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
            catch (CancellationException e) {
                LOG.error("Thread for moving region cancelled. Timeout for cancellation:" + timeoutInSeconds + "secs", (Throwable)e);
                throw e;
            }
        }
    }

    private boolean ignoreRegionMoveFailure(ExecutionException e) {
        boolean ignoreFailure = false;
        if (e.getCause() instanceof UnknownRegionException) {
            ignoreFailure = true;
        } else if (e.getCause() instanceof DoNotRetryRegionException && e.getCause().getMessage() != null && e.getCause().getMessage().contains("Unexpected state for state=SPLIT,")) {
            ignoreFailure = true;
        }
        return ignoreFailure;
    }

    private ServerName getTargetServer() throws Exception {
        ServerName server = null;
        int maxWaitInSeconds = this.admin.getConfiguration().getInt(SERVERSTART_WAIT_MAX_KEY, 180);
        long maxWait = EnvironmentEdgeManager.currentTime() + (long)(maxWaitInSeconds * 1000);
        while (EnvironmentEdgeManager.currentTime() < maxWait) {
            try {
                ArrayList<ServerName> regionServers = new ArrayList<ServerName>();
                regionServers.addAll(this.admin.getRegionServers());
                server = this.stripServer(regionServers, this.hostname, this.port);
                if (server != null) break;
                LOG.warn("Server " + this.hostname + ":" + this.port + " is not up yet, waiting");
            }
            catch (IOException e) {
                LOG.warn("Could not get list of region servers", (Throwable)e);
            }
            Thread.sleep(500L);
        }
        if (server == null) {
            LOG.error("Server " + this.hostname + ":" + this.port + " is not up. Giving up.");
            throw new Exception("Server " + this.hostname + ":" + this.port + " to load regions not online");
        }
        return server;
    }

    private List<RegionInfo> readRegionsFromFile(String filename) throws IOException {
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>();
        File f = new File(filename);
        if (!f.exists()) {
            return regions;
        }
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));){
            int numRegions = dis.readInt();
            for (int index = 0; index < numRegions; ++index) {
                regions.add(RegionInfo.parseFromOrNull(Bytes.readByteArray(dis)));
            }
        }
        catch (IOException e) {
            LOG.error("Error while reading regions from file:" + filename, (Throwable)e);
            throw e;
        }
        return regions;
    }

    private void writeFile(String filename, List<RegionInfo> movedRegions) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));){
            dos.writeInt(movedRegions.size());
            for (RegionInfo region : movedRegions) {
                Bytes.writeByteArray(dos, RegionInfo.toByteArray(region));
            }
        }
        catch (IOException e) {
            LOG.error("ERROR: Was Not able to write regions moved to output file but moved " + movedRegions.size() + " regions", (Throwable)e);
            throw e;
        }
    }

    private void deleteFile(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            f.delete();
        }
    }

    private List<String> readServersFromFile(String filename) throws IOException {
        ArrayList<String> servers = new ArrayList<String>();
        if (filename != null) {
            try {
                Files.readAllLines(Paths.get(filename, new String[0])).stream().map(String::trim).filter(((Predicate<String>)String::isEmpty).negate()).map(String::toLowerCase).forEach(servers::add);
            }
            catch (IOException e) {
                LOG.error("Exception while reading servers from file,", (Throwable)e);
                throw e;
            }
        }
        return servers;
    }

    private void includeExcludeRegionServers(String fileName, List<ServerName> regionServers, boolean isInclude) throws IOException {
        if (fileName != null) {
            List<String> servers = this.readServersFromFile(fileName);
            if (servers.isEmpty()) {
                LOG.warn("No servers provided in the file: {}." + fileName);
                return;
            }
            Iterator<ServerName> i = regionServers.iterator();
            while (i.hasNext()) {
                String rs = i.next().getServerName();
                String rsPort = rs.split(",")[0].toLowerCase() + ":" + rs.split(",")[1];
                if (isInclude == servers.contains(rsPort)) continue;
                i.remove();
            }
        }
    }

    private void stripMaster(List<ServerName> regionServers) throws IOException {
        ServerName master = this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.MASTER)).getMasterName();
        this.stripServer(regionServers, master.getHostname(), master.getPort());
    }

    private ServerName stripServer(List<ServerName> regionServers, String hostname, int port) {
        Iterator<ServerName> iter = regionServers.iterator();
        while (iter.hasNext()) {
            ServerName server = iter.next();
            if (!server.getAddress().getHostname().equalsIgnoreCase(hostname) || server.getAddress().getPort() != port) continue;
            iter.remove();
            return server;
        }
        return null;
    }

    @Override
    protected void addOptions() {
        this.addRequiredOptWithArg("r", "regionserverhost", "region server <hostname>|<hostname:port>");
        this.addRequiredOptWithArg("o", "operation", "Expected: load/unload/unload_from_rack");
        this.addOptWithArg("m", "maxthreads", "Define the maximum number of threads to use to unload and reload the regions");
        this.addOptWithArg("x", "excludefile", "File with <hostname:port> per line to exclude as unload targets; default excludes only target host; useful for rack decommisioning.");
        this.addOptWithArg("d", "designatedfile", "File with <hostname:port> per line as unload targets;default is all online hosts");
        this.addOptWithArg("f", "filename", "File to save regions list into unloading, or read from loading; default /tmp/<usernamehostname:port>");
        this.addOptNoArg("n", "noack", "Turn on No-Ack mode(default: false) which won't check if region is online on target RegionServer, hence best effort. This is more performant in unloading and loading but might lead to region being unavailable for some time till master reassigns it in case the move failed");
        this.addOptWithArg("t", "timeout", "timeout in seconds after which the tool will exit irrespective of whether it finished or not;default Integer.MAX_VALUE");
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        String hostname = cmd.getOptionValue("r");
        this.rmbuilder = new RegionMoverBuilder(hostname);
        if (cmd.hasOption('m')) {
            this.rmbuilder.maxthreads(Integer.parseInt(cmd.getOptionValue('m')));
        }
        if (cmd.hasOption('n')) {
            this.rmbuilder.ack(false);
        }
        if (cmd.hasOption('f')) {
            this.rmbuilder.filename(cmd.getOptionValue('f'));
        }
        if (cmd.hasOption('x')) {
            this.rmbuilder.excludeFile(cmd.getOptionValue('x'));
        }
        if (cmd.hasOption('d')) {
            this.rmbuilder.designatedFile(cmd.getOptionValue('d'));
        }
        if (cmd.hasOption('t')) {
            this.rmbuilder.timeout(Integer.parseInt(cmd.getOptionValue('t')));
        }
        this.loadUnload = cmd.getOptionValue("o").toLowerCase(Locale.ROOT);
    }

    @Override
    protected int doWork() throws Exception {
        boolean success;
        try (RegionMover rm = this.rmbuilder.build();){
            if (this.loadUnload.equalsIgnoreCase("load")) {
                success = rm.load();
            } else if (this.loadUnload.equalsIgnoreCase("unload")) {
                success = rm.unload();
            } else if (this.loadUnload.equalsIgnoreCase("unload_from_rack")) {
                success = rm.unloadFromRack();
            } else {
                this.printUsage();
                success = false;
            }
        }
        return success ? 0 : 1;
    }

    public static void main(String[] args) {
        try (RegionMover mover = new RegionMover();){
            mover.doStaticMain(args);
        }
    }

    public static class RegionMoverBuilder {
        private boolean ack = true;
        private int maxthreads = 1;
        private int timeout = Integer.MAX_VALUE;
        private String hostname;
        private String filename;
        private String excludeFile = null;
        private String designatedFile = null;
        private String defaultDir = System.getProperty("java.io.tmpdir");
        @InterfaceAudience.Private
        final int port;
        private final Configuration conf;
        private RackManager rackManager;

        public RegionMoverBuilder(String hostname) {
            this(hostname, RegionMoverBuilder.createConf());
        }

        private static Configuration createConf() {
            Configuration conf = HBaseConfiguration.create();
            conf.setInt("hbase.client.prefetch.limit", 1);
            conf.setInt("hbase.client.pause", 500);
            conf.setInt("hbase.client.retries.number", 100);
            return conf;
        }

        public RegionMoverBuilder(String hostname, Configuration conf) {
            String[] splitHostname = hostname.toLowerCase().split(":");
            this.hostname = splitHostname[0];
            this.port = splitHostname.length == 2 ? Integer.parseInt(splitHostname[1]) : conf.getInt("hbase.regionserver.port", 16020);
            this.filename = this.defaultDir + File.separator + System.getProperty("user.name") + this.hostname + ":" + Integer.toString(this.port);
            this.conf = conf;
        }

        public RegionMoverBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public RegionMoverBuilder maxthreads(int threads) {
            this.maxthreads = threads;
            return this;
        }

        public RegionMoverBuilder excludeFile(String excludefile) {
            this.excludeFile = excludefile;
            return this;
        }

        public RegionMoverBuilder designatedFile(String designatedFile) {
            this.designatedFile = designatedFile;
            return this;
        }

        public RegionMoverBuilder ack(boolean ack) {
            this.ack = ack;
            return this;
        }

        public RegionMoverBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        @InterfaceAudience.Private
        public RegionMoverBuilder rackManager(RackManager rackManager) {
            this.rackManager = rackManager;
            return this;
        }

        public RegionMover build() throws IOException {
            return new RegionMover(this);
        }
    }
}

