/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.openjdk.jol.vm;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hudi.org.openjdk.jol.util.ClassUtils;

public class ContendedSupport {
    private static final Class<? extends Annotation> SUN_MISC_CONTENDED;
    private static final Class<? extends Annotation> JDK_INTERNAL_CONTENDED;
    static volatile boolean shown;

    public static boolean isContended(AnnotatedElement el) {
        if (ContendedSupport.getSunMiscContended(el) != null) {
            return true;
        }
        return ContendedSupport.getJdkInternalContended(el) != null;
    }

    public static String contendedGroup(AnnotatedElement el) {
        Object smAnn = ContendedSupport.getSunMiscContended(el);
        if (smAnn != null) {
            return ContendedSupport.pullValue(SUN_MISC_CONTENDED, smAnn);
        }
        Object intAnn = ContendedSupport.getJdkInternalContended(el);
        if (intAnn != null) {
            return ContendedSupport.pullValue(JDK_INTERNAL_CONTENDED, intAnn);
        }
        return null;
    }

    private static Object getSunMiscContended(AnnotatedElement el) {
        if (SUN_MISC_CONTENDED == null) {
            return null;
        }
        return el.getAnnotation(SUN_MISC_CONTENDED);
    }

    private static Object getJdkInternalContended(AnnotatedElement el) {
        if (JDK_INTERNAL_CONTENDED == null) {
            return null;
        }
        return el.getAnnotation(JDK_INTERNAL_CONTENDED);
    }

    private static String pullValue(Class<? extends Annotation> klass, Object ann) {
        try {
            Method meth = klass.getMethod("value", new Class[0]);
            return (String)meth.invoke(ann, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            ContendedSupport.printErrorOnce(e);
            return "";
        }
    }

    static void printErrorOnce(Throwable err) {
        if (shown) {
            return;
        }
        shown = true;
        System.out.println("Error while accessing @Contended value: " + err.getMessage());
        System.out.println();
    }

    static {
        Class<?> intContended;
        Class<?> smContended;
        try {
            smContended = ClassUtils.loadSystemClass("sun.misc.Contended");
        }
        catch (ClassNotFoundException e) {
            smContended = null;
        }
        SUN_MISC_CONTENDED = smContended;
        try {
            intContended = ClassUtils.loadSystemClass("jdk.internal.vm.annotation.Contended");
        }
        catch (ClassNotFoundException e) {
            intContended = null;
        }
        JDK_INTERNAL_CONTENDED = intContended;
    }
}

