/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.storage;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathFilter;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.storage.StorageSchemes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPIClass(maturity=ApiMaturityLevel.EVOLVING)
public abstract class HoodieStorage
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(HoodieStorage.class);
    protected final StorageConfiguration<?> storageConf;

    public HoodieStorage(StorageConfiguration<?> storageConf) {
        this.storageConf = storageConf;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract HoodieStorage newInstance(StoragePath var1, StorageConfiguration<?> var2);

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract String getScheme();

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract int getDefaultBlockSize(StoragePath var1);

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract int getDefaultBufferSize();

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract short getDefaultReplication(StoragePath var1);

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract URI getUri();

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract OutputStream create(StoragePath var1, boolean var2) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract OutputStream create(StoragePath var1, boolean var2, Integer var3, Short var4, Long var5) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract InputStream open(StoragePath var1) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract SeekableDataInputStream openSeekable(StoragePath var1, int var2, boolean var3) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract OutputStream append(StoragePath var1) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract boolean exists(StoragePath var1) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract StoragePathInfo getPathInfo(StoragePath var1) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract boolean createDirectory(StoragePath var1) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract List<StoragePathInfo> listDirectEntries(StoragePath var1) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract List<StoragePathInfo> listFiles(StoragePath var1) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract List<StoragePathInfo> listDirectEntries(StoragePath var1, StoragePathFilter var2) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract void setModificationTime(StoragePath var1, long var2) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract List<StoragePathInfo> globEntries(StoragePath var1, StoragePathFilter var2) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract boolean rename(StoragePath var1, StoragePath var2) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract boolean deleteDirectory(StoragePath var1) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract boolean deleteFile(StoragePath var1) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract Object getFileSystem();

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract HoodieStorage getRawStorage();

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public final StorageConfiguration<?> getConf() {
        return this.storageConf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public final void createImmutableFileInPath(StoragePath path, Option<byte[]> content) throws HoodieIOException {
        OutputStream fsout = null;
        StoragePath tmpPath = null;
        boolean needTempFile = this.needCreateTempFile();
        try {
            if (!content.isPresent()) {
                fsout = this.create(path, false);
            }
            if (content.isPresent() && needTempFile) {
                StoragePath parent = path.getParent();
                tmpPath = new StoragePath(parent, path.getName() + "." + UUID.randomUUID());
                fsout = this.create(tmpPath, false);
                fsout.write(content.get());
            }
            if (content.isPresent() && !needTempFile) {
                fsout = this.create(path, false);
                fsout.write(content.get());
            }
        }
        catch (IOException e) {
            try {
                String errorMsg = "Failed to create file " + (tmpPath != null ? tmpPath : path);
                throw new HoodieIOException(errorMsg, e);
            }
            catch (Throwable throwable) {
                try {
                    if (null != fsout) {
                        fsout.close();
                    }
                }
                catch (IOException e2) {
                    String errorMsg = "Failed to close file " + (needTempFile ? tmpPath : path);
                    throw new HoodieIOException(errorMsg, e2);
                }
                boolean renameSuccess2 = false;
                try {
                    if (null == tmpPath) throw throwable;
                    renameSuccess2 = this.rename(tmpPath, path);
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new HoodieIOException("Failed to rename " + tmpPath + " to the target " + path, e3);
                }
                finally {
                    if (!renameSuccess2 && null != tmpPath) {
                        try {
                            this.deleteFile(tmpPath);
                            LOG.warn("Fail to rename " + tmpPath + " to " + path + ", target file exists: " + this.exists(path));
                        }
                        catch (IOException e4) {
                            throw new HoodieIOException("Failed to delete tmp file " + tmpPath, e4);
                        }
                    }
                }
            }
        }
        try {
            if (null != fsout) {
                fsout.close();
            }
        }
        catch (IOException e) {
            String errorMsg = "Failed to close file " + (needTempFile ? tmpPath : path);
            throw new HoodieIOException(errorMsg, e);
        }
        boolean renameSuccess = false;
        try {
            if (null == tmpPath) return;
            renameSuccess = this.rename(tmpPath, path);
            return;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to rename " + tmpPath + " to the target " + path, e);
        }
        finally {
            if (!renameSuccess && null != tmpPath) {
                try {
                    this.deleteFile(tmpPath);
                    LOG.warn("Fail to rename " + tmpPath + " to " + path + ", target file exists: " + this.exists(path));
                }
                catch (IOException e) {
                    throw new HoodieIOException("Failed to delete tmp file " + tmpPath, e);
                }
            }
        }
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public final boolean needCreateTempFile() {
        return StorageSchemes.HDFS.getScheme().equals(this.getScheme());
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public OutputStream create(StoragePath path) throws IOException {
        return this.create(path, true);
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public boolean createNewFile(StoragePath path) throws IOException {
        if (this.exists(path)) {
            return false;
        }
        this.create(path, false).close();
        return true;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public SeekableDataInputStream openSeekable(StoragePath path, boolean wrapStream) throws IOException {
        return this.openSeekable(path, this.getDefaultBlockSize(path), wrapStream);
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public List<StoragePathInfo> listDirectEntries(List<StoragePath> pathList) throws IOException {
        ArrayList<StoragePathInfo> result = new ArrayList<StoragePathInfo>();
        for (StoragePath path : pathList) {
            result.addAll(this.listDirectEntries(path));
        }
        return result;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public List<StoragePathInfo> listDirectEntries(List<StoragePath> pathList, StoragePathFilter filter) throws IOException {
        ArrayList<StoragePathInfo> result = new ArrayList<StoragePathInfo>();
        for (StoragePath path : pathList) {
            result.addAll(this.listDirectEntries(path, filter));
        }
        return result;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public List<StoragePathInfo> globEntries(StoragePath pathPattern) throws IOException {
        return this.globEntries(pathPattern, e -> true);
    }
}

