/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.MapUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.ddl.DDLExecutor;
import org.apache.hudi.hive.ddl.HMSDDLExecutor;
import org.apache.hudi.hive.ddl.HiveQueryDDLExecutor;
import org.apache.hudi.hive.ddl.HiveSyncMode;
import org.apache.hudi.hive.ddl.JDBCExecutor;
import org.apache.hudi.hive.util.IMetaStoreClientUtil;
import org.apache.hudi.hive.util.PartitionFilterGenerator;
import org.apache.hudi.sync.common.HoodieSyncClient;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.model.FieldSchema;
import org.apache.hudi.sync.common.model.Partition;
import org.apache.hudi.sync.common.util.TableUtils;
import org.apache.parquet.schema.MessageType;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieHiveSyncClient
extends HoodieSyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieHiveSyncClient.class);
    protected final HiveSyncConfig config;
    private final String databaseName;
    DDLExecutor ddlExecutor;
    private IMetaStoreClient client;

    public HoodieHiveSyncClient(HiveSyncConfig config) {
        super((HoodieSyncConfig)config);
        this.config = config;
        this.databaseName = config.getStringOrDefault(HoodieSyncConfig.META_SYNC_DATABASE_NAME);
        try {
            this.client = IMetaStoreClientUtil.getMSC(config.getHiveConf());
            if (!StringUtils.isNullOrEmpty((String)config.getString(HiveSyncConfigHolder.HIVE_SYNC_MODE))) {
                HiveSyncMode syncMode = HiveSyncMode.of(config.getString(HiveSyncConfigHolder.HIVE_SYNC_MODE));
                switch (syncMode) {
                    case HMS: {
                        this.ddlExecutor = new HMSDDLExecutor(config, this.client);
                        break;
                    }
                    case HIVEQL: {
                        this.ddlExecutor = new HiveQueryDDLExecutor(config, this.client);
                        break;
                    }
                    case JDBC: {
                        this.ddlExecutor = new JDBCExecutor(config);
                        break;
                    }
                    default: {
                        throw new HoodieHiveSyncException("Invalid sync mode given " + config.getString(HiveSyncConfigHolder.HIVE_SYNC_MODE));
                    }
                }
            } else {
                this.ddlExecutor = config.getBoolean(HiveSyncConfigHolder.HIVE_USE_JDBC) != false ? new JDBCExecutor(config) : new HiveQueryDDLExecutor(config, this.client);
            }
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to create HiveMetaStoreClient", e);
        }
    }

    public void addPartitionsToTable(String tableName, List<String> partitionsToAdd) {
        this.ddlExecutor.addPartitionsToTable(tableName, partitionsToAdd);
    }

    public void updatePartitionsToTable(String tableName, List<String> changedPartitions) {
        this.ddlExecutor.updatePartitionsToTable(tableName, changedPartitions);
    }

    public void dropPartitions(String tableName, List<String> partitionsToDrop) {
        this.ddlExecutor.dropPartitionsToTable(tableName, partitionsToDrop);
    }

    public boolean updateTableProperties(String tableName, Map<String, String> tableProperties) {
        if (MapUtils.isNullOrEmpty(tableProperties)) {
            return false;
        }
        try {
            Table table = this.client.getTable(this.databaseName, tableName);
            Map remoteTableProperties = table.getParameters();
            if (MapUtils.containsAll((Map)remoteTableProperties, tableProperties)) {
                return false;
            }
            for (Map.Entry<String, String> entry : tableProperties.entrySet()) {
                table.putToParameters(entry.getKey(), entry.getValue());
            }
            this.client.alter_table(this.databaseName, tableName, table);
            return true;
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to update table properties for table: " + tableName, e);
        }
    }

    public boolean updateSerdeProperties(String tableName, Map<String, String> serdeProperties, boolean useRealtimeFormat) {
        if (MapUtils.isNullOrEmpty(serdeProperties)) {
            return false;
        }
        try {
            String outputFormatClassName;
            boolean shouldUpdate;
            String serdeInfoName;
            serdeProperties.putIfAbsent("serialization.format", "1");
            Table table = this.client.getTable(this.databaseName, tableName);
            StorageDescriptor storageDescriptor = table.getSd();
            SerDeInfo remoteSerdeInfo = storageDescriptor.getSerdeInfo();
            if (remoteSerdeInfo == null) {
                serdeInfoName = null;
                shouldUpdate = true;
            } else {
                serdeInfoName = remoteSerdeInfo.getName();
                Map remoteSerdeProperties = remoteSerdeInfo.getParameters();
                shouldUpdate = !MapUtils.containsAll((Map)remoteSerdeProperties, serdeProperties);
            }
            HoodieFileFormat baseFileFormat = HoodieFileFormat.valueOf((String)this.config.getStringOrDefault(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT).toUpperCase());
            String inputFormatClassName = HoodieInputFormatUtils.getInputFormatClassName((HoodieFileFormat)baseFileFormat, (boolean)useRealtimeFormat, (boolean)this.config.getBooleanOrDefault(HiveSyncConfigHolder.HIVE_USE_PRE_APACHE_INPUT_FORMAT));
            if (!inputFormatClassName.equals(storageDescriptor.getInputFormat())) {
                shouldUpdate = true;
            }
            if (!(outputFormatClassName = HoodieInputFormatUtils.getOutputFormatClassName((HoodieFileFormat)baseFileFormat)).equals(storageDescriptor.getOutputFormat())) {
                shouldUpdate = true;
            }
            if (!shouldUpdate) {
                LOG.debug("Table " + tableName + " serdeProperties and formatClass already up to date, skip update.");
                return false;
            }
            storageDescriptor.setInputFormat(inputFormatClassName);
            storageDescriptor.setOutputFormat(outputFormatClassName);
            storageDescriptor.setSerdeInfo(new SerDeInfo(serdeInfoName, HoodieInputFormatUtils.getSerDeClassName((HoodieFileFormat)baseFileFormat), serdeProperties));
            this.client.alter_table(this.databaseName, tableName, table);
            return true;
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to update table serde info for table: " + tableName, e);
        }
    }

    public void updateTableSchema(String tableName, MessageType newSchema) {
        this.ddlExecutor.updateTableDefinition(tableName, newSchema);
    }

    public List<Partition> getAllPartitions(String tableName) {
        try {
            return this.client.listPartitions(this.databaseName, tableName, (short)-1).stream().map(p -> new Partition(p.getValues(), p.getSd().getLocation())).collect(Collectors.toList());
        }
        catch (TException e) {
            throw new HoodieHiveSyncException("Failed to get all partitions for table " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    public List<Partition> getPartitionsFromList(String tableName, List<String> partitions) {
        String filter = null;
        try {
            List partitionKeys = this.config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).stream().map(String::toLowerCase).collect(Collectors.toList());
            List<FieldSchema> partitionFields = this.getMetastoreFieldSchemas(tableName).stream().filter(f -> partitionKeys.contains(f.getName())).collect(Collectors.toList());
            filter = this.generatePushDownFilter(partitions, partitionFields);
            return this.client.listPartitionsByFilter(this.databaseName, tableName, filter, (short)-1).stream().map(p -> new Partition(p.getValues(), p.getSd().getLocation())).collect(Collectors.toList());
        }
        catch (TException e) {
            throw new HoodieHiveSyncException("Failed to get partitions for table " + TableUtils.tableId((String)this.databaseName, (String)tableName) + " with filter " + filter, e);
        }
    }

    public String generatePushDownFilter(List<String> writtenPartitions, List<FieldSchema> partitionFields) {
        return new PartitionFilterGenerator().generatePushDownFilter(writtenPartitions, partitionFields, this.config);
    }

    public void createTable(String tableName, MessageType storageSchema, String inputFormatClass, String outputFormatClass, String serdeClass, Map<String, String> serdeProperties, Map<String, String> tableProperties) {
        this.ddlExecutor.createTable(tableName, storageSchema, inputFormatClass, outputFormatClass, serdeClass, serdeProperties, tableProperties);
    }

    public Map<String, String> getMetastoreSchema(String tableName) {
        if (!this.tableExists(tableName)) {
            throw new IllegalArgumentException("Failed to get schema for table " + tableName + " does not exist");
        }
        return this.ddlExecutor.getTableSchema(tableName);
    }

    public boolean tableExists(String tableName) {
        try {
            return this.client.tableExists(this.databaseName, tableName);
        }
        catch (TException e) {
            throw new HoodieHiveSyncException("Failed to check if table exists " + tableName, e);
        }
    }

    public boolean databaseExists(String databaseName) {
        try {
            this.client.getDatabase(databaseName);
            return true;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            return false;
        }
        catch (TException e) {
            throw new HoodieHiveSyncException("Failed to check if database exists " + databaseName, e);
        }
    }

    public void createDatabase(String databaseName) {
        this.ddlExecutor.createDatabase(databaseName);
    }

    public Option<String> getLastCommitTimeSynced(String tableName) {
        try {
            Table table = this.client.getTable(this.databaseName, tableName);
            return Option.ofNullable(table.getParameters().getOrDefault("last_commit_time_sync", null));
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get the last commit time synced from the table " + tableName, e);
        }
    }

    public Option<String> getLastCommitCompletionTimeSynced(String tableName) {
        try {
            Table table = this.client.getTable(this.databaseName, tableName);
            return Option.ofNullable(table.getParameters().getOrDefault("last_commit_completion_time_sync", null));
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get the last commit completion time synced from the table " + tableName, e);
        }
    }

    public Option<String> getLastReplicatedTime(String tableName) {
        try {
            Table table = this.client.getTable(this.databaseName, tableName);
            return Option.ofNullable(table.getParameters().getOrDefault("last_replication_timestamp", null));
        }
        catch (NoSuchObjectException e) {
            LOG.warn("the said table not found in hms " + TableUtils.tableId((String)this.databaseName, (String)tableName));
            return Option.empty();
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get the last replicated time from the table " + tableName, e);
        }
    }

    public void updateLastReplicatedTimeStamp(String tableName, String timeStamp) {
        if (this.getActiveTimeline().getInstantsAsStream().noneMatch(i -> i.getTimestamp().equals(timeStamp))) {
            throw new HoodieHiveSyncException("Not a valid completed timestamp " + timeStamp + " for table " + tableName);
        }
        try {
            Table table = this.client.getTable(this.databaseName, tableName);
            table.putToParameters("last_replication_timestamp", timeStamp);
            this.client.alter_table(this.databaseName, tableName, table);
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to update last replicated time to " + timeStamp + " for " + tableName, e);
        }
    }

    public void deleteLastReplicatedTimeStamp(String tableName) {
        try {
            Table table = this.client.getTable(this.databaseName, tableName);
            String timestamp = (String)table.getParameters().remove("last_replication_timestamp");
            this.client.alter_table(this.databaseName, tableName, table);
            if (timestamp != null) {
                LOG.info("deleted last replicated timestamp " + timestamp + " for table " + tableName);
            }
        }
        catch (NoSuchObjectException table) {
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to delete last replicated timestamp for " + tableName, e);
        }
    }

    public void close() {
        try {
            this.ddlExecutor.close();
            if (this.client != null) {
                Hive.closeCurrent();
                this.client = null;
            }
        }
        catch (Exception e) {
            LOG.error("Could not close connection ", (Throwable)e);
        }
    }

    public void updateLastCommitTimeSynced(String tableName) {
        HoodieTimeline activeTimeline = this.getActiveTimeline();
        Option lastCommitSynced = activeTimeline.lastInstant().map(HoodieInstant::getTimestamp);
        Option lastCommitCompletionSynced = activeTimeline.getInstantsOrderedByStateTransitionTime().skip(activeTimeline.countInstants() - 1).findFirst().map(i -> Option.of((Object)i.getStateTransitionTime())).orElse(Option.empty());
        if (lastCommitSynced.isPresent()) {
            try {
                Table table = this.client.getTable(this.databaseName, tableName);
                String basePath = this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH);
                StorageDescriptor sd = table.getSd();
                sd.setLocation(basePath);
                SerDeInfo serdeInfo = sd.getSerdeInfo();
                serdeInfo.putToParameters("path", basePath);
                table.putToParameters("last_commit_time_sync", (String)lastCommitSynced.get());
                table.putToParameters("last_commit_completion_time_sync", (String)lastCommitCompletionSynced.get());
                this.client.alter_table(this.databaseName, tableName, table);
            }
            catch (Exception e) {
                throw new HoodieHiveSyncException("Failed to get update last commit time synced to " + lastCommitSynced, e);
            }
        }
    }

    public List<FieldSchema> getMetastoreFieldSchemas(String tableName) {
        try {
            return this.client.getSchema(this.databaseName, tableName).stream().map(f -> new FieldSchema(f.getName(), f.getType(), f.getComment())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get field schemas from metastore for table : " + tableName, e);
        }
    }

    public List<FieldSchema> getStorageFieldSchemas() {
        try {
            return new TableSchemaResolver(this.metaClient).getTableAvroSchema(false).getFields().stream().map(f -> new FieldSchema(f.name(), f.schema().getType().getName(), f.doc())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get field schemas from storage : ", e);
        }
    }

    public boolean updateTableComments(String tableName, List<FieldSchema> fromMetastore, List<FieldSchema> fromStorage) {
        Map<String, FieldSchema> metastoreMap = fromMetastore.stream().collect(Collectors.toMap(f -> f.getName().toLowerCase(Locale.ROOT), f -> f));
        Map<String, FieldSchema> storageMap = fromStorage.stream().collect(Collectors.toMap(f -> f.getName().toLowerCase(Locale.ROOT), f -> f));
        HashMap<String, Pair<String, String>> alterComments = new HashMap<String, Pair<String, String>>();
        metastoreMap.forEach((name, metastoreFieldSchema) -> {
            boolean updated;
            if (storageMap.containsKey(name) && (updated = metastoreFieldSchema.updateComment((FieldSchema)storageMap.get(name)))) {
                alterComments.put((String)name, (Pair<String, String>)Pair.of((Object)metastoreFieldSchema.getType(), (Object)metastoreFieldSchema.getCommentOrEmpty()));
            }
        });
        if (alterComments.isEmpty()) {
            LOG.info(String.format("No comment difference of %s ", tableName));
            return false;
        }
        this.ddlExecutor.updateTableComments(tableName, alterComments);
        return true;
    }

    @VisibleForTesting
    StorageDescriptor getMetastoreStorageDescriptor(String tableName) throws TException {
        return this.client.getTable(this.databaseName, tableName).getSd();
    }
}

