/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.ExpressionVisitor;
import org.apache.hudi.expression.Literal;
import org.apache.hudi.expression.NameReference;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.util.FilterGenVisitor;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.model.FieldSchema;
import org.apache.hudi.sync.common.model.Partition;
import org.apache.hudi.sync.common.model.PartitionValueExtractor;

public class PartitionFilterGenerator {
    private static final Set<String> SUPPORT_TYPES = new HashSet<String>(){
        {
            this.add("int");
            this.add("bigint");
            this.add("date");
            this.add("string");
        }
    };
    private static final String UNSUPPORTED_TYPE_ERROR = "The value type: %s doesn't support to be pushed down to HMS, acceptable types: " + String.join((CharSequence)",", SUPPORT_TYPES);

    private Literal buildLiteralExpression(String fieldValue, String fieldType) {
        switch (fieldType.toLowerCase(Locale.ROOT)) {
            case "int": {
                return new Literal((Object)Integer.parseInt(fieldValue), (Type)Types.IntType.get());
            }
            case "bigint": {
                return new Literal((Object)Long.parseLong(fieldValue), (Type)Types.LongType.get());
            }
            case "date": {
                return new Literal((Object)fieldValue, (Type)Types.DateType.get());
            }
            case "string": {
                return new Literal((Object)fieldValue, (Type)Types.StringType.get());
            }
            case "boolean": {
                return new Literal((Object)Boolean.parseBoolean(fieldValue), (Type)Types.BooleanType.get());
            }
        }
        throw new IllegalArgumentException(String.format(UNSUPPORTED_TYPE_ERROR, fieldType));
    }

    private Expression buildPartitionExpression(List<Partition> partitions, List<FieldSchema> partitionFields) {
        return partitions.stream().map(partition -> {
            List partitionValues = partition.getValues();
            Object root = null;
            for (int i = 0; i < partitionFields.size(); ++i) {
                FieldSchema field = (FieldSchema)partitionFields.get(i);
                Predicates.BinaryComparison exp = Predicates.eq((Expression)new NameReference(field.getName()), (Expression)this.buildLiteralExpression((String)partitionValues.get(i), field.getType()));
                root = root != null ? Predicates.and((Expression)root, (Expression)exp) : exp;
            }
            return root;
        }).reduce(null, (result, expr) -> {
            if (result == null) {
                return expr;
            }
            return Predicates.or((Expression)result, (Expression)expr);
        });
    }

    private List<Pair<FieldSchema, String[]>> extractFieldValues(List<Partition> partitions, List<FieldSchema> partitionFields) {
        return IntStream.range(0, partitionFields.size()).mapToObj(i -> {
            HashSet values = new HashSet();
            for (int j = 0; j < partitions.size(); ++j) {
                values.add(((Partition)partitions.get(j)).getValues().get(i));
            }
            return Pair.of(partitionFields.get(i), (Object)values.toArray(new String[0]));
        }).collect(Collectors.toList());
    }

    private Expression buildMinMaxPartitionExpression(List<Partition> partitions, List<FieldSchema> partitionFields) {
        return (Expression)this.extractFieldValues(partitions, partitionFields).stream().map(fieldWithValues -> {
            FieldSchema fieldSchema = (FieldSchema)fieldWithValues.getKey();
            if (!SUPPORT_TYPES.contains(fieldSchema.getType())) {
                return null;
            }
            String[] values = (String[])fieldWithValues.getValue();
            if (values.length == 1) {
                return Predicates.eq((Expression)new NameReference(fieldSchema.getName()), (Expression)this.buildLiteralExpression(values[0], fieldSchema.getType()));
            }
            Arrays.sort(values, new ValueComparator(fieldSchema.getType()));
            return Predicates.and((Expression)Predicates.gteq((Expression)new NameReference(fieldSchema.getName()), (Expression)this.buildLiteralExpression(values[0], fieldSchema.getType())), (Expression)Predicates.lteq((Expression)new NameReference(fieldSchema.getName()), (Expression)this.buildLiteralExpression(values[values.length - 1], fieldSchema.getType())));
        }).filter(Objects::nonNull).reduce(null, (result, expr) -> {
            if (result == null) {
                return expr;
            }
            return Predicates.and((Expression)result, (Expression)expr);
        });
    }

    public String generatePushDownFilter(List<String> writtenPartitions, List<FieldSchema> partitionFields, HiveSyncConfig config) {
        PartitionValueExtractor partitionValueExtractor = (PartitionValueExtractor)ReflectionUtils.loadClass((String)config.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS));
        List<Partition> partitions = writtenPartitions.stream().map(s -> {
            List values = partitionValueExtractor.extractPartitionValuesInPath(s);
            if (values.size() != partitionFields.size()) {
                throw new HoodieHiveSyncException("Partition fields and values should be same length, but got partitionFields: " + partitionFields + " with values: " + values);
            }
            return new Partition(values, null);
        }).collect(Collectors.toList());
        int estimateSize = partitionFields.size() * partitions.size();
        Expression filter = estimateSize > config.getIntOrDefault(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_MAX_SIZE) ? this.buildMinMaxPartitionExpression(partitions, partitionFields) : this.buildPartitionExpression(partitions, partitionFields);
        if (filter != null) {
            return this.generateFilterString(filter);
        }
        return "";
    }

    protected String generateFilterString(Expression filter) {
        return (String)filter.accept((ExpressionVisitor)new FilterGenVisitor());
    }

    private class ValueComparator
    implements Comparator<String> {
        private final String valueType;

        public ValueComparator(String type) {
            this.valueType = type;
        }

        @Override
        public int compare(String s1, String s2) {
            switch (this.valueType.toLowerCase(Locale.ROOT)) {
                case "int": {
                    int i1 = Integer.parseInt(s1);
                    int i2 = Integer.parseInt(s2);
                    return i1 - i2;
                }
                case "bigint": {
                    long l1 = Long.parseLong(s1);
                    long l2 = Long.parseLong(s2);
                    return Long.signum(l1 - l2);
                }
                case "date": 
                case "string": {
                    return s1.compareTo(s2);
                }
            }
            throw new IllegalArgumentException(String.format(UNSUPPORTED_TYPE_ERROR, this.valueType));
        }
    }
}

