/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.testutils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.minicluster.ZookeeperTestService;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HoodieHiveSyncClient;
import org.apache.hudi.hive.ddl.HiveQueryDDLExecutor;
import org.apache.hudi.hive.testutils.HiveTestService;
import org.apache.hudi.hive.util.IMetaStoreClientUtil;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

public class HiveSyncFunctionalTestHarness {
    private static transient Configuration hadoopConf;
    private static transient HiveTestService hiveTestService;
    private static transient ZookeeperTestService zookeeperTestService;
    protected boolean initialized = false;
    @TempDir
    protected Path tempDir;

    public String basePath() {
        return this.tempDir.toAbsolutePath().toString();
    }

    public Configuration hadoopConf() {
        return hadoopConf;
    }

    public FileSystem fs() throws IOException {
        return FileSystem.get((Configuration)hadoopConf);
    }

    public HiveTestService hiveService() {
        return hiveTestService;
    }

    public HiveConf hiveConf() {
        return hiveTestService.getHiveServer().getHiveConf();
    }

    public StorageConfiguration<Configuration> storageConf() {
        return HadoopFSUtils.getStorageConf((Configuration)this.hiveConf());
    }

    public ZookeeperTestService zkService() {
        return zookeeperTestService;
    }

    public HiveSyncConfig hiveSyncConf() throws IOException {
        Properties props = new Properties();
        props.setProperty(HiveSyncConfigHolder.HIVE_URL.key(), hiveTestService.getJdbcHive2Url());
        props.setProperty(HiveSyncConfigHolder.HIVE_USER.key(), "");
        props.setProperty(HiveSyncConfigHolder.HIVE_PASS.key(), "");
        props.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), "hivesynctestdb");
        props.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), "hivesynctesttable");
        props.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), Files.createDirectories(this.tempDir.resolve("hivesynctestcase-" + Instant.now().toEpochMilli()), new FileAttribute[0]).toUri().toString());
        props.setProperty(HiveSyncConfigHolder.HIVE_USE_PRE_APACHE_INPUT_FORMAT.key(), "false");
        props.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "datestr");
        return new HiveSyncConfig(props, (Configuration)this.hiveConf());
    }

    public HoodieHiveSyncClient hiveClient(HiveSyncConfig hiveSyncConfig) throws IOException {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.newTableBuilder().setTableType(HoodieTableType.COPY_ON_WRITE).setTableName(hiveSyncConfig.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME)).setPayloadClass(HoodieAvroPayload.class).initTable(HadoopFSUtils.getStorageConfWithCopy((Configuration)hadoopConf), hiveSyncConfig.getString(HoodieSyncConfig.META_SYNC_BASE_PATH));
        return new HoodieHiveSyncClient(hiveSyncConfig, metaClient);
    }

    public void dropTables(String database, String ... tables) throws IOException, HiveException, MetaException {
        HiveSyncConfig hiveSyncConfig = this.hiveSyncConf();
        hiveSyncConfig.setValue(HoodieSyncConfig.META_SYNC_DATABASE_NAME, database);
        for (String table : tables) {
            hiveSyncConfig.setValue(HoodieSyncConfig.META_SYNC_TABLE_NAME, table);
            new HiveQueryDDLExecutor(hiveSyncConfig, IMetaStoreClientUtil.getMSC((HiveConf)hiveSyncConfig.getHiveConf())).runSQL("drop table if exists " + table);
        }
    }

    public void dropDatabases(String ... databases) throws IOException, HiveException, MetaException {
        HiveSyncConfig hiveSyncConfig = this.hiveSyncConf();
        for (String database : databases) {
            hiveSyncConfig.setValue(HoodieSyncConfig.META_SYNC_DATABASE_NAME, database);
            new HiveQueryDDLExecutor(hiveSyncConfig, IMetaStoreClientUtil.getMSC((HiveConf)hiveSyncConfig.getHiveConf())).runSQL("drop database if exists " + database);
        }
    }

    @BeforeEach
    public synchronized void runBeforeEach() throws IOException, InterruptedException {
        boolean bl = this.initialized = hiveTestService != null && zookeeperTestService != null;
        if (!this.initialized) {
            hadoopConf = new Configuration();
            zookeeperTestService = new ZookeeperTestService(hadoopConf);
            zookeeperTestService.start();
            hiveTestService = new HiveTestService(hadoopConf);
            hiveTestService.start();
        }
    }

    @AfterAll
    public static synchronized void cleanUpAfterAll() {
        if (hiveTestService != null) {
            hiveTestService.stop();
            hiveTestService = null;
        }
        if (zookeeperTestService != null) {
            zookeeperTestService.stop();
            zookeeperTestService = null;
        }
        if (hadoopConf != null) {
            hadoopConf.clear();
            hadoopConf = null;
        }
    }
}

