/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSyncTableStrategy;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.FileCreateUtilsLegacy;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.testutils.NetworkTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.hive.HoodieHiveSyncClient;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.MultiPartKeysValueExtractor;
import org.apache.hudi.hive.NonPartitionedExtractor;
import org.apache.hudi.hive.ddl.HMSDDLExecutor;
import org.apache.hudi.hive.ddl.HiveSyncMode;
import org.apache.hudi.hive.testutils.HiveTestUtil;
import org.apache.hudi.hive.util.IMetaStoreClientUtil;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.model.FieldSchema;
import org.apache.hudi.sync.common.model.Partition;
import org.apache.hudi.sync.common.model.PartitionEvent;
import org.apache.parquet.schema.MessageType;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHiveSyncTool {
    private static final List<Object> SYNC_MODES = Arrays.asList("hiveql", "hms", "jdbc");
    private HiveSyncTool hiveSyncTool;
    private HoodieHiveSyncClient hiveClient;

    private static Iterable<Object> syncMode() {
        return SYNC_MODES;
    }

    private static Iterable<Object[]> syncModeAndEnablePushDown() {
        ArrayList<Object[]> opts = new ArrayList<Object[]>();
        for (Object mode : SYNC_MODES) {
            opts.add(new Object[]{mode, "true"});
            opts.add(new Object[]{mode, "false"});
        }
        return opts;
    }

    private static Iterable<Object[]> syncModeAndSchemaFromCommitMetadata() {
        ArrayList<Object[]> opts = new ArrayList<Object[]>();
        for (Object mode : SYNC_MODES) {
            opts.add(new Object[]{true, mode, "true"});
            opts.add(new Object[]{false, mode, "true"});
            opts.add(new Object[]{true, mode, "false"});
            opts.add(new Object[]{false, mode, "false"});
        }
        return opts;
    }

    private static Iterable<Object[]> syncModeAndStrategy() {
        ArrayList<Object[]> opts = new ArrayList<Object[]>();
        for (Object mode : SYNC_MODES) {
            opts.add(new Object[]{mode, HoodieSyncTableStrategy.ALL});
            opts.add(new Object[]{mode, HoodieSyncTableStrategy.RO});
            opts.add(new Object[]{mode, HoodieSyncTableStrategy.RT});
        }
        return opts;
    }

    @AfterAll
    public static void cleanUpClass() throws IOException {
        HiveTestUtil.shutdown();
    }

    private static Iterable<Object[]> syncModeAndSchemaFromCommitMetadataAndManagedTable() {
        ArrayList<Object[]> opts = new ArrayList<Object[]>();
        for (Object mode : SYNC_MODES) {
            opts.add(new Object[]{true, true, mode, "true"});
            opts.add(new Object[]{false, false, mode, "true"});
            opts.add(new Object[]{true, true, mode, "false"});
            opts.add(new Object[]{false, false, mode, "false"});
        }
        return opts;
    }

    private static Iterable<Object[]> syncDataSourceTableParams() {
        ArrayList<Object[]> opts = new ArrayList<Object[]>();
        for (Object mode : SYNC_MODES) {
            opts.add(new Object[]{true, true, mode, "true"});
            opts.add(new Object[]{false, false, mode, "true"});
            opts.add(new Object[]{true, true, mode, "false"});
            opts.add(new Object[]{false, false, mode, "false"});
        }
        return opts;
    }

    @BeforeEach
    public void setUp() throws Exception {
        HiveTestUtil.setUp((Option<TypedProperties>)Option.empty(), true);
    }

    @AfterEach
    public void teardown() throws Exception {
        HiveTestUtil.clear();
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndSchemaFromCommitMetadata"})
    public void testUpdateBasePath(boolean useSchemaFromCommitMetadata, String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 1, useSchemaFromCommitMetadata);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        IMetaStoreClient client = IMetaStoreClientUtil.getMSC((HiveConf)HiveTestUtil.getHiveConf());
        Option<String> locationOption = this.getMetastoreLocation(client, "testdb", "test1");
        Assertions.assertTrue((boolean)locationOption.isPresent(), (String)"The location of Table test1 is not present in metastore");
        String oldLocation = (String)locationOption.get();
        HiveTestUtil.fileSystem.delete(new Path(HiveTestUtil.basePath), true);
        HiveTestUtil.basePath = Files.createTempDirectory("hivesynctest" + Instant.now().toEpochMilli(), new FileAttribute[0]).toUri().toString();
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), HiveTestUtil.basePath);
        HiveTestUtil.createCOWTable(instantTime, 1, useSchemaFromCommitMetadata);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        client.reconnect();
        Option<String> newLocationOption = this.getMetastoreLocation(client, "testdb", "test1");
        Assertions.assertTrue((boolean)newLocationOption.isPresent(), (String)"The location of Table test1 is not present in metastore");
        String newLocation = (String)newLocationOption.get();
        Assertions.assertNotEquals((Object)oldLocation, (Object)newLocation, (String)"Update base path failed");
        client.close();
    }

    public Option<String> getMetastoreLocation(IMetaStoreClient client, String databaseName, String tableName) {
        try {
            Table table = client.getTable(databaseName, tableName);
            StorageDescriptor sd = table.getSd();
            return Option.ofNullable((Object)sd.getLocation());
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get the metastore location from the table " + tableName, (Throwable)e);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testSyncAllPartition() throws Exception {
        HiveTestUtil.createCOWTable("100", 1, true);
        HiveTestUtil.addCOWPartition("2010/02/01", true, true, "101");
        HiveTestUtil.addCOWPartition("2010/02/02", true, true, "102");
        HiveTestUtil.addCOWPartition("2010/02/03", true, true, "103");
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)4, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        HiveTestUtil.ddlExecutor.runSQL("ALTER TABLE `test1` DROP PARTITION (`datestr`='2010-02-03')");
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)3, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_INCREMENTAL.key(), "false");
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)4, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testDropUpperCasePartitionWithHMS() throws Exception {
        HiveTestUtil.hiveSyncConfig.setValue(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "DATESTR");
        HiveTestUtil.createCOWTable("100", 1, true);
        HiveTestUtil.addCOWPartition("2010/02/01", true, true, "101");
        HiveTestUtil.addCOWPartition("2010/02/02", true, true, "102");
        HiveTestUtil.addCOWPartition("2010/02/03", true, true, "103");
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)4, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        try (HMSDDLExecutor hmsExecutor = new HMSDDLExecutor(HiveTestUtil.hiveSyncConfig, IMetaStoreClientUtil.getMSC((HiveConf)HiveTestUtil.hiveSyncConfig.getHiveConf()));){
            hmsExecutor.dropPartitionsToTable("test1", Collections.singletonList("2010/02/03"));
        }
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)3, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        HiveTestUtil.ddlExecutor.runSQL("ALTER TABLE `test1` DROP PARTITION (`datestr`='2010-02-02')");
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)2, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndSchemaFromCommitMetadata"})
    public void testBasicSync(boolean useSchemaFromCommitMetadata, String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, useSchemaFromCommitMetadata);
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)(this.hiveClient.getStorageSchema().getColumns().size() + 1), (String)"Hive Schema should match the table schema + partition field");
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)instantTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        List<String> newPartition = Arrays.asList("2050/01/01", "2040/02/01");
        this.hiveClient.addPartitionsToTable("test1", Collections.emptyList());
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"No new partition should be added");
        this.hiveClient.addPartitionsToTable("test1", newPartition);
        FileCreateUtilsLegacy.createPartitionMetaFile((String)HiveTestUtil.basePath, (String)"2050/01/01");
        FileCreateUtilsLegacy.createPartitionMetaFile((String)HiveTestUtil.basePath, (String)"2040/02/01");
        Assertions.assertEquals((int)7, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"New partition should be added");
        this.hiveClient.updatePartitionsToTable("test1", Collections.emptyList());
        Assertions.assertEquals((int)7, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Partition count should remain the same");
        this.hiveClient.updatePartitionsToTable("test1", newPartition);
        List hivePartitions = this.hiveClient.getAllPartitions("test1");
        Set relativePartitionPaths = hivePartitions.stream().map(p -> HadoopFSUtils.getRelativePartitionPath((Path)new Path(HiveTestUtil.basePath), (Path)new Path(p.getStorageLocation()))).collect(Collectors.toSet());
        Assertions.assertEquals((int)7, (int)hivePartitions.size(), (String)"Partition count should remain the same");
        Assertions.assertEquals((int)hivePartitions.size(), (int)relativePartitionPaths.size());
        Assertions.assertTrue((boolean)relativePartitionPaths.containsAll(newPartition));
        HiveTestUtil.ddlExecutor.runSQL("ALTER TABLE `test1` PARTITION (`datestr`='2050-01-01') SET LOCATION '" + FSUtils.constructAbsolutePath((String)HiveTestUtil.basePath, (String)"2050/1/1").toString() + "'");
        hivePartitions = this.hiveClient.getAllPartitions("test1");
        List writtenPartitionsSince = this.hiveClient.getWrittenPartitionsSince(Option.empty(), Option.empty());
        List partitionEvents = this.hiveClient.getPartitionEvents(hivePartitions, writtenPartitionsSince, Collections.emptySet());
        Assertions.assertEquals((int)1, (int)partitionEvents.size(), (String)"There should be only one partition event");
        Assertions.assertEquals((Object)PartitionEvent.PartitionEventType.UPDATE, (Object)((PartitionEvent)partitionEvents.iterator().next()).eventType, (String)"The one partition event must of type UPDATE");
        String dummyBasePath = new Path(HiveTestUtil.basePath).getParent().toString() + "/dummy_basepath";
        HiveTestUtil.ddlExecutor.runSQL("ALTER TABLE `test1` ADD PARTITION (`datestr`='xyz') LOCATION '" + dummyBasePath + "/xyz'");
        this.reSyncHiveTable();
        List tablePartitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((int)8, (int)tablePartitions.size(), (String)"The two partitions we wrote should be added to hive");
        Assertions.assertEquals((Object)instantTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be 100");
        hivePartitions = this.hiveClient.getAllPartitions("test1");
        List allPartitionPathsOnStorage = this.hiveClient.getAllPartitionPathsOnStorage().stream().sorted().collect(Collectors.toList());
        String dropPartition = (String)allPartitionPathsOnStorage.remove(0);
        allPartitionPathsOnStorage.add("2050/01/02");
        partitionEvents = this.hiveClient.getPartitionEvents(hivePartitions, allPartitionPathsOnStorage);
        Assertions.assertEquals((int)3, (int)partitionEvents.size(), (String)"There should be only one partition event");
        Assertions.assertEquals((Object)"2050/01/02", (Object)partitionEvents.stream().filter((Predicate<PartitionEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testBasicSync$1(org.apache.hudi.sync.common.model.PartitionEvent ), (Lorg/apache/hudi/sync/common/model/PartitionEvent;)Z)()).findFirst().get().storagePartition, (String)"There should be only one partition event of type ADD");
        Assertions.assertEquals((Object)"2050/01/01", (Object)partitionEvents.stream().filter((Predicate<PartitionEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testBasicSync$2(org.apache.hudi.sync.common.model.PartitionEvent ), (Lorg/apache/hudi/sync/common/model/PartitionEvent;)Z)()).findFirst().get().storagePartition, (String)"There should be only one partition event of type UPDATE");
        Assertions.assertEquals((Object)dropPartition, (Object)partitionEvents.stream().filter((Predicate<PartitionEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testBasicSync$3(org.apache.hudi.sync.common.model.PartitionEvent ), (Lorg/apache/hudi/sync/common/model/PartitionEvent;)Z)()).findFirst().get().storagePartition, (String)"There should be only one partition event of type DROP");
        HiveTestUtil.createCOWTable("200", 6, useSchemaFromCommitMetadata);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        tablePartitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((Object)Option.of((Object)"200"), (Object)this.hiveClient.getLastCommitTimeSynced("test1"));
        Assertions.assertEquals((int)7, (int)tablePartitions.size());
        HiveTestUtil.commitToTable("300", 1, useSchemaFromCommitMetadata);
        HiveTestUtil.removeCommitFromActiveTimeline("200", "commit");
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        tablePartitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((Object)Option.of((Object)"300"), (Object)this.hiveClient.getLastCommitTimeSynced("test1"));
        Assertions.assertEquals((int)7, (int)tablePartitions.size());
        HiveTestUtil.addRollbackInstantToTable("400", "350");
        HiveTestUtil.commitToTable("500", 7, useSchemaFromCommitMetadata);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        tablePartitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((Object)Option.of((Object)"500"), (Object)this.hiveClient.getLastCommitTimeSynced("test1"));
        Assertions.assertEquals((int)8, (int)tablePartitions.size());
        HiveTestUtil.commitToTable("600", 8, useSchemaFromCommitMetadata);
        HiveTestUtil.commitToTable("700", 1, useSchemaFromCommitMetadata);
        HiveTestUtil.commitToTable("800", 1, useSchemaFromCommitMetadata);
        HiveTestUtil.removeCommitFromActiveTimeline("300", "commit");
        HiveTestUtil.removeCommitFromActiveTimeline("500", "commit");
        HiveTestUtil.removeCommitFromActiveTimeline("600", "commit");
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(this.hiveClient.config.getHadoopConf()), (String)HiveTestUtil.basePath);
        Assertions.assertEquals(Arrays.asList("400", "700", "800"), metaClient.getActiveTimeline().getInstants().stream().map(HoodieInstant::requestedTime).sorted().collect(Collectors.toList()));
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        tablePartitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((Object)Option.of((Object)"800"), (Object)this.hiveClient.getLastCommitTimeSynced("test1"));
        Assertions.assertEquals((int)9, (int)tablePartitions.size());
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testSyncDataBase(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, true);
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), "testdb");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE.key(), "false");
        this.reInitHiveSyncClient();
        Assertions.assertThrows(Exception.class, this::reSyncHiveTable);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE.key(), "true");
        this.reInitHiveSyncClient();
        Assertions.assertDoesNotThrow(this::reSyncHiveTable);
        Assertions.assertTrue((boolean)this.hiveClient.databaseExists("testdb"), (String)"DataBases testdb should exist after sync completes");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE.key(), "false");
        this.reInitHiveSyncClient();
        Assertions.assertDoesNotThrow(this::reSyncHiveTable);
        Assertions.assertTrue((boolean)this.hiveClient.databaseExists("testdb"), (String)"DataBases testdb should exist after sync completes");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE.key(), "true");
        Assertions.assertDoesNotThrow(this::reSyncHiveTable);
        Assertions.assertTrue((boolean)this.hiveClient.databaseExists("testdb"), (String)"DataBases testdb should exist after sync completes");
    }

    @ParameterizedTest
    @MethodSource(value={"syncDataSourceTableParams"})
    public void testSyncCOWTableWithProperties(boolean useSchemaFromCommitMetadata, boolean syncAsDataSourceTable, String syncMode, String enablePushDown) throws Exception {
        HashMap<String, String> serdeProperties = new HashMap<String, String>(){
            {
                this.put("path", HiveTestUtil.basePath);
            }
        };
        HashMap<String, String> tableProperties = new HashMap<String, String>(){
            {
                this.put("tp_0", "p0");
                this.put("tp_1", "p1");
            }
        };
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_AS_DATA_SOURCE_TABLE.key(), String.valueOf(syncAsDataSourceTable));
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_TABLE_SERDE_PROPERTIES.key(), ConfigUtils.configToString((Map)serdeProperties));
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_TABLE_PROPERTIES.key(), ConfigUtils.configToString((Map)tableProperties));
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, useSchemaFromCommitMetadata);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        SessionState.start((HiveConf)HiveTestUtil.getHiveConf());
        Driver hiveDriver = new Driver(HiveTestUtil.getHiveConf());
        String dbTableName = "testdb.test1";
        hiveDriver.run("SHOW TBLPROPERTIES " + dbTableName);
        ArrayList results = new ArrayList();
        hiveDriver.getResults(results);
        String tblPropertiesWithoutDdlTime = String.join((CharSequence)"\n", results.subList(0, results.size() - 1));
        String sparkTableProperties = this.getSparkTableProperties(syncAsDataSourceTable, useSchemaFromCommitMetadata);
        Assertions.assertEquals((Object)("EXTERNAL\tTRUE\nlast_commit_completion_time_sync\t" + this.getLastCommitCompletionTimeSynced() + "\nlast_commit_time_sync\t100\n" + sparkTableProperties + "tp_0\tp0\ntp_1\tp1"), (Object)tblPropertiesWithoutDdlTime);
        Assertions.assertTrue((boolean)((String)results.get(results.size() - 1)).startsWith("transient_lastDdlTime"));
        results.clear();
        hiveDriver.run("SHOW CREATE TABLE " + dbTableName);
        hiveDriver.getResults(results);
        String ddl = String.join((CharSequence)"\n", results);
        Assertions.assertTrue((boolean)ddl.contains(String.format("ROW FORMAT SERDE \n  '%s'", ParquetHiveSerDe.class.getName())));
        Assertions.assertTrue((boolean)ddl.contains("'path'='" + HiveTestUtil.basePath + "'"));
        if (syncAsDataSourceTable) {
            Assertions.assertTrue((boolean)ddl.contains("'hoodie.query.as.ro.table'='false'"));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSyncCOWTableWithCreateManagedTable(boolean createManagedTable) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), HiveSyncMode.HMS.name());
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_CREATE_MANAGED_TABLE.key(), Boolean.toString(createManagedTable));
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, true);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        SessionState.start((HiveConf)HiveTestUtil.getHiveConf());
        Driver hiveDriver = new Driver(HiveTestUtil.getHiveConf());
        hiveDriver.run(String.format("SHOW TBLPROPERTIES %s.%s", "testdb", "test1"));
        ArrayList results = new ArrayList();
        hiveDriver.getResults(results);
        Assertions.assertEquals((Object)String.format("%slast_commit_completion_time_sync\t%s\nlast_commit_time_sync\t%s\n%s", createManagedTable ? "" : "EXTERNAL\tTRUE\n", this.getLastCommitCompletionTimeSynced(), instantTime, this.getSparkTableProperties(true, true)), (Object)String.format("%s\n", String.join((CharSequence)"\n", results.subList(0, results.size() - 1))));
    }

    private String getSparkTableProperties(boolean syncAsDataSourceTable, boolean useSchemaFromCommitMetadata) {
        if (syncAsDataSourceTable) {
            if (useSchemaFromCommitMetadata) {
                return "spark.sql.sources.provider\thudi\nspark.sql.sources.schema.numPartCols\t1\nspark.sql.sources.schema.numParts\t1\nspark.sql.sources.schema.part.0\t{\"type\":\"struct\",\"fields\":[{\"name\":\"_hoodie_commit_time\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_commit_seqno\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_record_key\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_partition_path\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_file_name\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"name\",\"type\":\"string\",\"nullable\":false,\"metadata\":{}},{\"name\":\"favorite_number\",\"type\":\"integer\",\"nullable\":false,\"metadata\":{}},{\"name\":\"favorite_color\",\"type\":\"string\",\"nullable\":false,\"metadata\":{}},{\"name\":\"datestr\",\"type\":\"string\",\"nullable\":false,\"metadata\":{}}]}\nspark.sql.sources.schema.partCol.0\tdatestr\n";
            }
            return "spark.sql.sources.provider\thudi\nspark.sql.sources.schema.numPartCols\t1\nspark.sql.sources.schema.numParts\t1\nspark.sql.sources.schema.part.0\t{\"type\":\"struct\",\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"nullable\":false,\"metadata\":{}},{\"name\":\"favorite_number\",\"type\":\"integer\",\"nullable\":false,\"metadata\":{}},{\"name\":\"favorite_color\",\"type\":\"string\",\"nullable\":false,\"metadata\":{}}]}\n{\"name\":\"datestr\",\"type\":\"string\",\"nullable\":false,\"metadata\":{}}]}\nspark.sql.sources.schema.partCol.0\tdatestr\n";
        }
        return "";
    }

    @ParameterizedTest
    @MethodSource(value={"syncDataSourceTableParams"})
    public void testSyncMORTableWithProperties(boolean useSchemaFromCommitMetadata, boolean syncAsDataSourceTable, String syncMode, String enablePushDown) throws Exception {
        HashMap<String, String> serdeProperties = new HashMap<String, String>(){
            {
                this.put("path", HiveTestUtil.basePath);
            }
        };
        HashMap<String, String> tableProperties = new HashMap<String, String>(){
            {
                this.put("tp_0", "p0");
                this.put("tp_1", "p1");
            }
        };
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_AS_DATA_SOURCE_TABLE.key(), String.valueOf(syncAsDataSourceTable));
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_TABLE_SERDE_PROPERTIES.key(), ConfigUtils.configToString((Map)serdeProperties));
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_TABLE_PROPERTIES.key(), ConfigUtils.configToString((Map)tableProperties));
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String instantTime = "100";
        String deltaCommitTime = "101";
        HiveTestUtil.createMORTable(instantTime, deltaCommitTime, 5, true, useSchemaFromCommitMetadata);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        String roTableName = "test1_ro";
        String rtTableName = "test1_rt";
        String[] tableNames = new String[]{roTableName, rtTableName};
        String[] readAsOptimizedResults = new String[]{"true", "false"};
        SessionState.start((HiveConf)HiveTestUtil.getHiveConf());
        Driver hiveDriver = new Driver(HiveTestUtil.getHiveConf());
        String sparkTableProperties = this.getSparkTableProperties(syncAsDataSourceTable, useSchemaFromCommitMetadata);
        for (int i = 0; i < 2; ++i) {
            String dbTableName = "testdb." + tableNames[i];
            String readAsOptimized = readAsOptimizedResults[i];
            hiveDriver.run("SHOW TBLPROPERTIES " + dbTableName);
            ArrayList results = new ArrayList();
            hiveDriver.getResults(results);
            String tblPropertiesWithoutDdlTime = String.join((CharSequence)"\n", results.subList(0, results.size() - 1));
            Assertions.assertEquals((Object)("EXTERNAL\tTRUE\nlast_commit_completion_time_sync\t" + this.getLastCommitCompletionTimeSynced() + "\nlast_commit_time_sync\t101\n" + sparkTableProperties + "tp_0\tp0\ntp_1\tp1"), (Object)tblPropertiesWithoutDdlTime);
            Assertions.assertTrue((boolean)((String)results.get(results.size() - 1)).startsWith("transient_lastDdlTime"));
            results.clear();
            hiveDriver.run("SHOW CREATE TABLE " + dbTableName);
            hiveDriver.getResults(results);
            String ddl = String.join((CharSequence)"\n", results);
            Assertions.assertTrue((boolean)ddl.contains(String.format("ROW FORMAT SERDE \n  '%s'", ParquetHiveSerDe.class.getName())));
            Assertions.assertTrue((boolean)ddl.contains("'path'='" + HiveTestUtil.basePath + "'"));
            Assertions.assertTrue((boolean)ddl.toLowerCase().contains("create external table"));
            if (!syncAsDataSourceTable) continue;
            Assertions.assertTrue((boolean)ddl.contains("'hoodie.query.as.ro.table'='" + readAsOptimized + "'"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndSchemaFromCommitMetadataAndManagedTable"})
    public void testSyncManagedTable(boolean useSchemaFromCommitMetadata, boolean isManagedTable, String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_CREATE_MANAGED_TABLE.key(), String.valueOf(isManagedTable));
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, useSchemaFromCommitMetadata);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        SessionState.start((HiveConf)HiveTestUtil.getHiveConf());
        Driver hiveDriver = new Driver(HiveTestUtil.getHiveConf());
        String dbTableName = "testdb.test1";
        hiveDriver.run("SHOW TBLPROPERTIES " + dbTableName);
        ArrayList results = new ArrayList();
        hiveDriver.run("SHOW CREATE TABLE " + dbTableName);
        hiveDriver.getResults(results);
        String ddl = String.join((CharSequence)"\n", results).toLowerCase();
        if (isManagedTable) {
            Assertions.assertTrue((boolean)ddl.contains("create table"));
        } else {
            Assertions.assertTrue((boolean)ddl.contains("create external table"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndEnablePushDown"})
    public void testSyncWithSchema(String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String commitTime = "100";
        HiveTestUtil.createCOWTableWithSchema(commitTime, "/complex.schema.avsc");
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)1, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)commitTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndEnablePushDown"})
    public void testSyncIncremental(String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String commitTime1 = "100";
        HiveTestUtil.createCOWTable(commitTime1, 5, true);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)commitTime1, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "101";
        HiveTestUtil.addCOWPartitions(1, true, true, dateTime, commitTime2);
        this.reSyncHiveTable();
        List writtenPartitionsSince = this.hiveClient.getWrittenPartitionsSince(Option.of((Object)commitTime1), Option.of((Object)commitTime1));
        Assertions.assertEquals((int)1, (int)writtenPartitionsSince.size(), (String)"We should have one partition written after 100 commit");
        List hivePartitions = this.hiveClient.getAllPartitions("test1");
        List partitionEvents = this.hiveClient.getPartitionEvents(hivePartitions, writtenPartitionsSince, Collections.emptySet());
        Assertions.assertEquals((int)1, (int)partitionEvents.size(), (String)"There should be only one partition event");
        Assertions.assertEquals((Object)PartitionEvent.PartitionEventType.ADD, (Object)((PartitionEvent)partitionEvents.iterator().next()).eventType, (String)"The one partition event must of type ADD");
        this.reSyncHiveTable();
        Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"The one partition we wrote should be added to hive");
        Assertions.assertEquals((Object)commitTime2, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be 101");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndEnablePushDown"})
    public void testSyncIncrementalWithSchemaEvolution(String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String commitTime1 = "100";
        HiveTestUtil.createCOWTable(commitTime1, 5, true);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        int fields = this.hiveClient.getMetastoreSchema("test1").size();
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "101";
        HiveTestUtil.addCOWPartitions(1, false, true, dateTime, commitTime2);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)(fields + 3), (int)this.hiveClient.getMetastoreSchema("test1").size(), (String)"Hive Schema has evolved and should not be 3 more field");
        Assertions.assertEquals((Object)"BIGINT", this.hiveClient.getMetastoreSchema("test1").get("favorite_number"), (String)"Hive Schema has evolved - Field favorite_number has evolved from int to long");
        Assertions.assertTrue((boolean)this.hiveClient.getMetastoreSchema("test1").containsKey("favorite_movie"), (String)"Hive Schema has evolved - Field favorite_movie was added");
        Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"The one partition we wrote should be added to hive");
        Assertions.assertEquals((Object)commitTime2, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be 101");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndEnablePushDown"})
    public void testRecreateCOWTableOnBasePathChange(String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String commitTime1 = "100";
        HiveTestUtil.createCOWTable(commitTime1, 5, true);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        String commitTime2 = "105";
        HiveTestUtil.basePath = Files.createTempDirectory("hivesynctest_new" + Instant.now().toEpochMilli(), new FileAttribute[0]).toUri().toString();
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), HiveTestUtil.basePath);
        HiveTestUtil.createCOWTable(commitTime2, 2, true);
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime3 = "110";
        HiveTestUtil.addCOWPartitions(2, false, true, dateTime, commitTime3);
        this.reInitHiveSyncClient();
        Assertions.assertNotEquals((Object)this.hiveClient.getBasePath(), (Object)this.hiveClient.getTableLocation("test1"), (String)"new table location should match hoodie basepath");
        this.reSyncHiveTable();
        Assertions.assertEquals((int)4, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"the 4 partitions from new base path should be present for hive");
        Assertions.assertEquals((Object)commitTime3, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be 110");
        Assertions.assertEquals((Object)this.hiveClient.getBasePath(), (Object)this.hiveClient.getTableLocation("test1"), (String)"new table location should match hoodie basepath");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndEnablePushDown"})
    void testRecreateCOWTableWithSchemaEvolution(String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.RECREATE_HIVE_TABLE_ON_ERROR.key(), "true");
        HiveTestUtil.hiveSyncProps.setProperty(HoodieMetricsConfig.TURN_METRICS_ON.key(), "true");
        HiveTestUtil.hiveSyncProps.setProperty(HoodieCommonConfig.BASE_PATH.key(), HiveTestUtil.basePath);
        HiveTestUtil.hiveSyncProps.setProperty(HoodieMetricsConfig.METRICS_REPORTER_TYPE_VALUE.key(), MetricsReporterType.INMEMORY.name());
        String commitTime1 = "100";
        HiveTestUtil.createCOWTable(commitTime1, 5, true);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        int fields = this.hiveClient.getMetastoreSchema("test1").size();
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        DateTimeFormatter dtfOut = DateTimeFormatter.ofPattern("yyyy/MM/dd");
        List<String> partitions = Arrays.asList(dateTime.format(dtfOut));
        String commitTime2 = "101";
        HiveTestUtil.addCOWPartitions(partitions, "/complex-schema-evolved.avsc", "/complex-schema-evolved.data", true, commitTime2);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)(fields + 3), (int)this.hiveClient.getMetastoreSchema("test1").size(), (String)"Hive Schema has evolved and should not be 3 more field");
        Assertions.assertEquals((Object)"STRING", this.hiveClient.getMetastoreSchema("test1").get("favorite_number"), (String)"Hive Schema has evolved - Field favorite_number has evolved from int to string");
        Assertions.assertTrue((boolean)this.hiveClient.getMetastoreSchema("test1").containsKey("favorite_movie"), (String)"Hive Schema has evolved - Field favorite_movie was added");
        Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"The one partition we wrote should be added to hive");
        Assertions.assertEquals((Object)commitTime2, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be 101");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndEnablePushDown"})
    void testRecreateCOWTableWithPartitionEvolution(String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.RECREATE_HIVE_TABLE_ON_ERROR.key(), "true");
        String commitTime1 = "100";
        HiveTestUtil.createCOWTable(commitTime1, 0, true);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "datestr");
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "101";
        HiveTestUtil.addCOWPartitions(1, false, true, dateTime, commitTime2);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((Object)commitTime2, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be 101");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testUpdateTableComments(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String commitTime = "100";
        HiveTestUtil.createCOWTableWithSchema(commitTime, "/simple-test.avsc");
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        HashMap<String, ImmutablePair> alterCommentSchema = new HashMap<String, ImmutablePair>();
        Schema schema = SchemaTestUtil.getSchemaFromResource(HiveTestUtil.class, (String)"/simple-test.avsc");
        Schema commentedSchema = SchemaTestUtil.getSchemaFromResource(HiveTestUtil.class, (String)"/simple-test-doced.avsc");
        Map<String, String> fieldsNameAndDoc = commentedSchema.getFields().stream().collect(Collectors.toMap(field -> field.name().toLowerCase(Locale.ROOT), field -> StringUtils.isNullOrEmpty((String)field.doc()) ? "" : field.doc()));
        for (Schema.Field field2 : schema.getFields()) {
            String name = field2.name().toLowerCase(Locale.ROOT);
            String comment = fieldsNameAndDoc.get(name);
            if (!fieldsNameAndDoc.containsKey(name) || comment.equals(field2.doc())) continue;
            alterCommentSchema.put(name, new ImmutablePair((Object)field2.schema().getType().name(), (Object)comment));
        }
        HiveTestUtil.ddlExecutor.updateTableComments("test1", alterCommentSchema);
        List fieldSchemas = this.hiveClient.getMetastoreFieldSchemas("test1");
        int commentCnt = 0;
        for (FieldSchema fieldSchema : fieldSchemas) {
            if (!StringUtils.nonEmpty((String)fieldSchema.getCommentOrEmpty())) continue;
            ++commentCnt;
        }
        Assertions.assertEquals((int)2, (int)commentCnt, (String)"hive schema field comment numbers should match the avro schema field doc numbers");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testSyncWithCommentedSchema(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_COMMENT.key(), "false");
        String commitTime = "100";
        HiveTestUtil.createCOWTableWithSchema(commitTime, "/simple-test-doced.avsc");
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        List fieldSchemas = this.hiveClient.getMetastoreFieldSchemas("test1");
        int commentCnt = 0;
        for (FieldSchema fieldSchema : fieldSchemas) {
            if (!StringUtils.nonEmpty((String)fieldSchema.getCommentOrEmpty())) continue;
            ++commentCnt;
        }
        Assertions.assertEquals((int)0, (int)commentCnt, (String)"hive schema field comment numbers should match the avro schema field doc numbers");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_COMMENT.key(), "true");
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        fieldSchemas = this.hiveClient.getMetastoreFieldSchemas("test1");
        commentCnt = 0;
        for (FieldSchema fieldSchema : fieldSchemas) {
            if (!StringUtils.nonEmpty((String)fieldSchema.getCommentOrEmpty())) continue;
            ++commentCnt;
        }
        Assertions.assertEquals((int)2, (int)commentCnt, (String)"hive schema field comment numbers should match the avro schema field doc numbers");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndSchemaFromCommitMetadata"})
    public void testSyncMergeOnRead(boolean useSchemaFromCommitMetadata, String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String instantTime = "100";
        String deltaCommitTime = "101";
        HiveTestUtil.createMORTable(instantTime, deltaCommitTime, 5, true, useSchemaFromCommitMetadata);
        String roTableName = "test1_ro";
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists(roTableName), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists(roTableName), (String)("Table " + roTableName + " should exist after sync completes"));
        if (useSchemaFromCommitMetadata) {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(roTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + this.getPartitionFieldSize() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the table schema + partition field");
        } else {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(roTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + this.getPartitionFieldSize()), (String)"Hive Schema should match the table schema + partition field");
        }
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions(roTableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)deltaCommitTime, (Object)this.hiveClient.getLastCommitTimeSynced(roTableName).get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        HiveTestUtil.addCOWPartitions(1, true, useSchemaFromCommitMetadata, dateTime, commitTime2);
        HiveTestUtil.addMORPartitions(1, true, false, useSchemaFromCommitMetadata, dateTime, commitTime2, deltaCommitTime2);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        if (useSchemaFromCommitMetadata) {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(roTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + this.getPartitionFieldSize() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the evolved table schema + partition field");
        } else {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(roTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + this.getPartitionFieldSize()), (String)"Hive Schema should match the evolved table schema + partition field");
        }
        Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions(roTableName).size(), (String)"The 2 partitions we wrote should be added to hive");
        Assertions.assertEquals((Object)deltaCommitTime2, (Object)this.hiveClient.getLastCommitTimeSynced(roTableName).get(), (String)"The last commit that was synced should be 103");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndSchemaFromCommitMetadata"})
    public void testSyncMergeOnReadWithBasePathChange(boolean useSchemaFromCommitMetadata, String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String instantTime = "100";
        String deltaCommitTime = "101";
        HiveTestUtil.createMORTable(instantTime, deltaCommitTime, 5, true, useSchemaFromCommitMetadata);
        String roTableName = "test1_ro";
        String rtTableName = "test1_rt";
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists(roTableName), (String)"Table test1 should not exist initially");
        Assertions.assertFalse((boolean)this.hiveClient.tableExists(rtTableName), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        HiveTestUtil.basePath = Files.createTempDirectory("hivesynctest_new" + Instant.now().toEpochMilli(), new FileAttribute[0]).toUri().toString();
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), HiveTestUtil.basePath);
        String instantTime2 = "102";
        String deltaCommitTime2 = "103";
        HiveTestUtil.createMORTable(instantTime2, deltaCommitTime2, 2, true, useSchemaFromCommitMetadata);
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime3 = "104";
        String deltaCommitTime3 = "105";
        HiveTestUtil.addMORPartitions(2, true, false, useSchemaFromCommitMetadata, dateTime, commitTime3, deltaCommitTime3);
        this.reInitHiveSyncClient();
        Assertions.assertNotEquals((Object)this.hiveClient.getBasePath(), (Object)this.hiveClient.getTableLocation(roTableName), (String)"ro table location should not match hoodie base path before sync");
        Assertions.assertNotEquals((Object)this.hiveClient.getBasePath(), (Object)this.hiveClient.getTableLocation(rtTableName), (String)"rt table location should not match hoodie base path before sync");
        this.reSyncHiveTable();
        Assertions.assertEquals((int)4, (int)this.hiveClient.getAllPartitions(roTableName).size(), (String)"the 4 partitions from new base path should be present for ro table");
        Assertions.assertEquals((int)4, (int)this.hiveClient.getAllPartitions(rtTableName).size(), (String)"the 4 partitions from new base path should be present for rt table");
        Assertions.assertEquals((Object)deltaCommitTime3, (Object)this.hiveClient.getLastCommitTimeSynced(roTableName).get(), (String)"The last commit that was synced should be 103");
        Assertions.assertEquals((Object)deltaCommitTime3, (Object)this.hiveClient.getLastCommitTimeSynced(rtTableName).get(), (String)"The last commit that was synced should be 103");
        Assertions.assertEquals((Object)this.hiveClient.getBasePath(), (Object)this.hiveClient.getTableLocation(roTableName), (String)"ro table location should match hoodie base path after sync");
        Assertions.assertEquals((Object)this.hiveClient.getBasePath(), (Object)this.hiveClient.getTableLocation(rtTableName), (String)"rt table location should match hoodie base path after sync");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndSchemaFromCommitMetadata"})
    public void testSyncMergeOnReadRT(boolean useSchemaFromCommitMetadata, String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String instantTime = "100";
        String deltaCommitTime = "101";
        String snapshotTableName = "test1_rt";
        HiveTestUtil.createMORTable(instantTime, deltaCommitTime, 5, true, useSchemaFromCommitMetadata);
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists(snapshotTableName), (String)"Table test1_rt should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists(snapshotTableName), (String)"Table test1_rt should exist after sync completes");
        if (useSchemaFromCommitMetadata) {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + this.getPartitionFieldSize() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the table schema + partition field");
        } else {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + this.getPartitionFieldSize()), (String)"Hive Schema should match the table schema + partition field");
        }
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions(snapshotTableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)deltaCommitTime, (Object)this.hiveClient.getLastCommitTimeSynced(snapshotTableName).get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        HiveTestUtil.addCOWPartitions(1, true, useSchemaFromCommitMetadata, dateTime, commitTime2);
        HiveTestUtil.addMORPartitions(1, true, false, useSchemaFromCommitMetadata, dateTime, commitTime2, deltaCommitTime2);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        if (useSchemaFromCommitMetadata) {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + this.getPartitionFieldSize() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the evolved table schema + partition field");
        } else {
            Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + this.getPartitionFieldSize()), (String)"Hive Schema should match the evolved table schema + partition field");
        }
        Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions(snapshotTableName).size(), (String)"The 2 partitions we wrote should be added to hive");
        Assertions.assertEquals((Object)deltaCommitTime2, (Object)this.hiveClient.getLastCommitTimeSynced(snapshotTableName).get(), (String)"The last commit that was synced should be 103");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndStrategy"})
    public void testSyncMergeOnReadWithStrategy(String syncMode, HoodieSyncTableStrategy strategy) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_TABLE_STRATEGY.key(), strategy.name());
        String instantTime = "100";
        String deltaCommitTime = "101";
        HiveTestUtil.createMORTable(instantTime, deltaCommitTime, 5, true, true);
        String snapshotTableName = "test1_rt";
        String roTableName = "test1_ro";
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists(roTableName), (String)("Table " + roTableName + " should not exist initially"));
        Assertions.assertFalse((boolean)this.hiveClient.tableExists(snapshotTableName), (String)("Table " + snapshotTableName + " should not exist initially"));
        this.reSyncHiveTable();
        switch (strategy) {
            case RO: {
                Assertions.assertFalse((boolean)this.hiveClient.tableExists(snapshotTableName), (String)("Table " + snapshotTableName + " should not exist initially"));
                Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
                break;
            }
            case RT: {
                Assertions.assertFalse((boolean)this.hiveClient.tableExists(roTableName), (String)("Table " + roTableName + " should not exist initially"));
                Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
                break;
            }
            default: {
                Assertions.assertTrue((boolean)this.hiveClient.tableExists(roTableName), (String)("Table " + roTableName + " should exist after sync completes"));
                Assertions.assertTrue((boolean)this.hiveClient.tableExists(snapshotTableName), (String)("Table " + snapshotTableName + " should exist after sync completes"));
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=HoodieSyncTableStrategy.class, names={"RO", "RT"})
    public void testSyncMergeOnReadWithStrategyWhenTableExist(HoodieSyncTableStrategy strategy) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_TABLE_STRATEGY.key(), strategy.name());
        String instantTime = "100";
        String deltaCommitTime = "101";
        HiveTestUtil.createMORTable(instantTime, deltaCommitTime, 5, true, true);
        this.reInitHiveSyncClient();
        MessageType schema = this.hiveClient.getStorageSchema(true);
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        String initInputFormatClassName = strategy.equals((Object)HoodieSyncTableStrategy.RO) ? HoodieParquetRealtimeInputFormat.class.getName() : HoodieParquetInputFormat.class.getName();
        String outputFormatClassName = HoodieInputFormatUtils.getOutputFormatClassName((HoodieFileFormat)HoodieFileFormat.PARQUET);
        String serDeFormatClassName = HoodieInputFormatUtils.getSerDeClassName((HoodieFileFormat)HoodieFileFormat.PARQUET);
        this.hiveClient.createDatabase("testdb");
        this.hiveClient.createTable("test1", schema, initInputFormatClassName, outputFormatClassName, serDeFormatClassName, new HashMap(), new HashMap());
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist initially");
        String targetInputFormatClassName = strategy.equals((Object)HoodieSyncTableStrategy.RO) ? HoodieParquetInputFormat.class.getName() : HoodieParquetRealtimeInputFormat.class.getName();
        StorageDescriptor storageDescriptor = this.hiveClient.getMetastoreStorageDescriptor("test1");
        Assertions.assertEquals((Object)initInputFormatClassName, (Object)storageDescriptor.getInputFormat(), (String)("Table test1 inputFormat should be " + targetInputFormatClassName));
        Assertions.assertFalse((boolean)storageDescriptor.getSerdeInfo().getParameters().containsKey("hoodie.query.as.ro.table"), (String)"Table test1 serdeInfo parameter hoodie.query.as.ro.table should not exist");
        this.reSyncHiveTable();
        storageDescriptor = this.hiveClient.getMetastoreStorageDescriptor("test1");
        Assertions.assertEquals((Object)targetInputFormatClassName, (Object)storageDescriptor.getInputFormat(), (String)("Table test1 inputFormat should be " + targetInputFormatClassName));
        Assertions.assertEquals(storageDescriptor.getSerdeInfo().getParameters().get("hoodie.query.as.ro.table"), (Object)(strategy.equals((Object)HoodieSyncTableStrategy.RO) ? "true" : "false"), (String)"Table test1 serdeInfo parameter hoodie.query.as.ro.table should be ");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndEnablePushDown"})
    public void testMultiPartitionKeySync(String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, true);
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), MultiPartKeysValueExtractor.class.getCanonicalName());
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "year,month,day");
        HiveTestUtil.getCreatedTablesSet().add("testdb.test1");
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)(this.hiveClient.getStorageSchema().getColumns().size() + 3), (String)"Hive Schema should match the table schema + partition fields");
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)instantTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        String commitTime2 = "101";
        HiveTestUtil.addCOWPartition("2010/01/02", true, true, commitTime2);
        this.reInitHiveSyncClient();
        List writtenPartitionsSince = this.hiveClient.getWrittenPartitionsSince(Option.of((Object)instantTime), Option.of((Object)this.getLastCommitCompletionTimeSynced()));
        Assertions.assertEquals((int)1, (int)writtenPartitionsSince.size(), (String)"We should have one partition written after 100 commit");
        List hivePartitions = this.hiveClient.getAllPartitions("test1");
        List partitionEvents = this.hiveClient.getPartitionEvents(hivePartitions, writtenPartitionsSince, Collections.emptySet());
        Assertions.assertEquals((int)1, (int)partitionEvents.size(), (String)"There should be only one partition event");
        Assertions.assertEquals((Object)PartitionEvent.PartitionEventType.ADD, (Object)((PartitionEvent)partitionEvents.iterator().next()).eventType, (String)"The one partition event must of type ADD");
        this.reSyncHiveTable();
        Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)commitTime2, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be 101");
        String commitTime3 = "102";
        HiveTestUtil.addCOWPartition("2010/02/01", true, true, commitTime3);
        HiveTestUtil.getCreatedTablesSet().add("testdb.test1");
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)(this.hiveClient.getStorageSchema().getColumns().size() + 3), (String)"Hive Schema should match the table schema + partition fields");
        Assertions.assertEquals((int)7, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)commitTime3, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        Assertions.assertEquals((int)1, (int)this.hiveClient.getWrittenPartitionsSince(Option.of((Object)commitTime2), Option.of((Object)this.getLastCommitCompletionTimeSynced())).size());
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndEnablePushDown"})
    public void testDropPartitionKeySync(String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 1, true);
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)(this.hiveClient.getStorageSchema().getColumns().size() + 1), (String)"Hive Schema should match the table schema + partition field");
        Assertions.assertEquals((int)1, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)instantTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        List<String> newPartition = Collections.singletonList("2050/01/01");
        this.hiveClient.addPartitionsToTable("test1", Collections.emptyList());
        Assertions.assertEquals((int)1, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"No new partition should be added");
        this.hiveClient.addPartitionsToTable("test1", newPartition);
        FileCreateUtilsLegacy.createPartitionMetaFile((String)HiveTestUtil.basePath, (String)"2050/01/01");
        Assertions.assertEquals((int)2, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"New partition should be added");
        this.reSyncHiveTable();
        HiveTestUtil.ddlExecutor.runSQL("ALTER TABLE `test1` DROP PARTITION (`datestr`='2050-01-01')");
        List hivePartitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((int)1, (int)hivePartitions.size(), (String)"Table should have 1 partition because of the drop 1 partition");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndEnablePushDown"})
    public void testDropPartition(String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 1, true);
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)(this.hiveClient.getStorageSchema().getColumns().size() + 1), (String)"Hive Schema should match the table schema + partition field");
        List partitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((int)1, (int)partitions.size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)instantTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        String instantTime2 = "101";
        String newPartition = "2010/02/01";
        HiveTestUtil.addCOWPartition(newPartition, true, true, instantTime2);
        HiveTestUtil.getCreatedTablesSet().add("testdb.test1");
        partitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((int)1, (int)partitions.size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)instantTime, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        String partitiontoDelete = ((String)((Partition)partitions.get(0)).getValues().get(0)).replace("-", "/");
        String instantTime3 = "102";
        HiveTestUtil.createReplaceCommit(instantTime3, partitiontoDelete, WriteOperationType.DELETE_PARTITION, true, true);
        String instantTime4 = "103";
        HiveTestUtil.createReplaceCommit(instantTime4, newPartition, WriteOperationType.DELETE_PARTITION, true, true);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        List hivePartitions = this.hiveClient.getAllPartitions("test1");
        Assertions.assertEquals((int)0, (int)hivePartitions.size(), (String)"Table should have no partitions");
        Assertions.assertEquals((Object)instantTime4, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndEnablePushDown"})
    public void testNonPartitionedSync(String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, true);
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), NonPartitionedExtractor.class.getCanonicalName());
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "");
        HiveTestUtil.getCreatedTablesSet().add("testdb.test1");
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)this.hiveClient.getStorageSchema().getColumns().size(), (String)"Hive Schema should match the table schema\uff0cignoring the partition fields");
        Assertions.assertEquals((int)0, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"Table should not have partitions because of the NonPartitionedExtractor");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndEnablePushDown"})
    public void testReadSchemaForMOR(String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        String commitTime = "100";
        String snapshotTableName = "test1_rt";
        HiveTestUtil.createMORTable(commitTime, "", 5, false, true);
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists(snapshotTableName), (String)"Table test1_rt should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists(snapshotTableName), (String)"Table test1_rt should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + this.getPartitionFieldSize() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the table schema + partition field");
        Assertions.assertEquals((int)5, (int)this.hiveClient.getAllPartitions(snapshotTableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        HiveTestUtil.addMORPartitions(1, true, false, true, dateTime, commitTime2, deltaCommitTime2);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getEvolvedSchema().getFields().size() + this.getPartitionFieldSize() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the evolved table schema + partition field");
        Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions(snapshotTableName).size(), (String)"The 1 partition we wrote should be added to hive");
        Assertions.assertEquals((Object)deltaCommitTime2, (Object)this.hiveClient.getLastCommitTimeSynced(snapshotTableName).get(), (String)"The last commit that was synced should be 103");
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndStrategy"})
    void testRecreateMORTableWithSchemaEvolution(String syncMode, HoodieSyncTableStrategy strategy) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_TABLE_STRATEGY.key(), strategy.name());
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.RECREATE_HIVE_TABLE_ON_ERROR.key(), "true");
        String commitTime = "100";
        HiveTestUtil.createMORTable(commitTime, "", 5, false, true);
        this.reInitHiveSyncClient();
        String snapshotTableName = "test1_rt";
        String roTableName = "test1_ro";
        this.reSyncHiveTable();
        switch (strategy) {
            case RO: {
                Assertions.assertFalse((boolean)this.hiveClient.tableExists(snapshotTableName), (String)("Table " + snapshotTableName + " should not exist initially"));
                Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
                break;
            }
            case RT: {
                Assertions.assertFalse((boolean)this.hiveClient.tableExists(roTableName), (String)("Table " + roTableName + " should not exist initially"));
                Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
                break;
            }
            default: {
                Assertions.assertTrue((boolean)this.hiveClient.tableExists(roTableName), (String)("Table " + roTableName + " should exist after sync completes"));
                Assertions.assertTrue((boolean)this.hiveClient.tableExists(snapshotTableName), (String)("Table " + snapshotTableName + " should exist after sync completes"));
            }
        }
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        DateTimeFormatter dtfOut = DateTimeFormatter.ofPattern("yyyy/MM/dd");
        List<String> partitions = Arrays.asList(dateTime.format(dtfOut));
        HiveTestUtil.addMORPartitions(partitions, "/complex-schema-evolved.avsc", "/complex-schema-evolved.data", true, commitTime2, deltaCommitTime2);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        switch (strategy) {
            case RO: {
                Assertions.assertFalse((boolean)this.hiveClient.tableExists(snapshotTableName), (String)("Table " + snapshotTableName + " should not exist initially"));
                Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
                Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)(7 + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the evolved table schema + partition field");
                Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"The 1 partition we wrote should be added to hive");
                Assertions.assertEquals((Object)deltaCommitTime2, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be 103");
                break;
            }
            case RT: {
                Assertions.assertFalse((boolean)this.hiveClient.tableExists(roTableName), (String)("Table " + roTableName + " should not exist initially"));
                Assertions.assertTrue((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
                Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema("test1").size(), (int)(7 + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the evolved table schema + partition field");
                Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions("test1").size(), (String)"The 1 partition we wrote should be added to hive");
                Assertions.assertEquals((Object)deltaCommitTime2, (Object)this.hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be 103");
                break;
            }
            default: {
                Assertions.assertTrue((boolean)this.hiveClient.tableExists(roTableName), (String)("Table " + roTableName + " should exist after sync completes"));
                Assertions.assertTrue((boolean)this.hiveClient.tableExists(snapshotTableName), (String)("Table " + snapshotTableName + " should exist after sync completes"));
                Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(roTableName).size(), (int)(7 + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the evolved table schema + partition field");
                Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions(roTableName).size(), (String)"The 1 partition we wrote should be added to hive");
                Assertions.assertEquals((Object)deltaCommitTime2, (Object)this.hiveClient.getLastCommitTimeSynced(roTableName).get(), (String)"The last commit that was synced should be 103");
                Assertions.assertEquals((int)6, (int)this.hiveClient.getAllPartitions(snapshotTableName).size(), (String)"The 1 partition we wrote should be added to hive");
                Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(7 + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the evolved table schema + partition field");
                Assertions.assertEquals((Object)deltaCommitTime2, (Object)this.hiveClient.getLastCommitTimeSynced(snapshotTableName).get(), (String)"The last commit that was synced should be 103");
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndEnablePushDown"})
    void testRecreateMORTableWithPartitionEvolution(String syncMode, String enablePushDown) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.RECREATE_HIVE_TABLE_ON_ERROR.key(), "true");
        String instantTime = "100";
        String deltaCommitTime = "101";
        String snapshotTableName = "test1_rt";
        HiveTestUtil.createMORTable(instantTime, deltaCommitTime, 0, true, true);
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists(snapshotTableName), (String)"Table test1_rt should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists(snapshotTableName), (String)"Table test1_rt should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the table schema + partition field");
        Assertions.assertEquals((int)0, (int)this.hiveClient.getAllPartitions(snapshotTableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)deltaCommitTime, (Object)this.hiveClient.getLastCommitTimeSynced(snapshotTableName).get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "datestr");
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        HiveTestUtil.addMORPartitions(1, true, false, true, dateTime, commitTime2, deltaCommitTime2);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((Object)deltaCommitTime2, (Object)this.hiveClient.getLastCommitTimeSynced(snapshotTableName).get(), (String)"The last commit that was synced should be 103");
    }

    @ParameterizedTest
    @ValueSource(strings={"hiveql", "hms", "jdbc"})
    void testMORTableWithPartitionEvolutionThrowsException(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), "true");
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.RECREATE_HIVE_TABLE_ON_ERROR.key(), "false");
        String instantTime = "100";
        String deltaCommitTime = "101";
        String snapshotTableName = "test1_rt";
        HiveTestUtil.createMORTable(instantTime, deltaCommitTime, 0, true, true);
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists(snapshotTableName), (String)"Table test1_rt should not exist initially");
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists(snapshotTableName), (String)"Table test1_rt should exist after sync completes");
        Assertions.assertEquals((int)this.hiveClient.getMetastoreSchema(snapshotTableName).size(), (int)(SchemaTestUtil.getSimpleSchema().getFields().size() + HoodieRecord.HOODIE_META_COLUMNS.size()), (String)"Hive Schema should match the table schema + partition field");
        Assertions.assertEquals((int)0, (int)this.hiveClient.getAllPartitions(snapshotTableName).size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)deltaCommitTime, (Object)this.hiveClient.getLastCommitTimeSynced(snapshotTableName).get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "datestr");
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        HiveTestUtil.addMORPartitions(1, true, false, true, dateTime, commitTime2, deltaCommitTime2);
        this.reInitHiveSyncClient();
        Assertions.assertThrows(HoodieException.class, this::reSyncHiveTable, (String)"The sync operation should throw exception due to partition mismatch and table recreation is disabled");
    }

    @Test
    public void testConnectExceptionIgnoreConfigSet() throws IOException, URISyntaxException {
        String instantTime = "100";
        HiveTestUtil.createCOWTable(instantTime, 5, false);
        this.reInitHiveSyncClient();
        HoodieHiveSyncClient prevHiveClient = this.hiveClient;
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_IGNORE_EXCEPTIONS.key(), "true");
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_URL.key(), HiveTestUtil.hiveSyncProps.getString(HiveSyncConfigHolder.HIVE_URL.key()).replace(String.valueOf(HiveTestUtil.hiveTestService.getHiveServerPort()), String.valueOf(NetworkTestUtils.nextFreePort())));
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertNull((Object)this.hiveClient);
        Assertions.assertFalse((boolean)prevHiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
    }

    private void verifyOldParquetFileTest(HoodieHiveSyncClient hiveClient, String emptyCommitTime) throws Exception {
        Assertions.assertTrue((boolean)hiveClient.tableExists("test1"), (String)"Table test1 should exist after sync completes");
        Assertions.assertEquals((int)hiveClient.getMetastoreSchema("test1").size(), (int)(hiveClient.getStorageSchema().getColumns().size() + 1), (String)"Hive Schema should match the table schema + partition field");
        Assertions.assertEquals((int)1, (int)hiveClient.getAllPartitions("test1").size(), (String)"Table partitions should match the number of partitions we wrote");
        Assertions.assertEquals((Object)emptyCommitTime, (Object)hiveClient.getLastCommitTimeSynced("test1").get(), (String)"The last commit that was synced should be updated in the TBLPROPERTIES");
        Schema schema = SchemaTestUtil.getSimpleSchema();
        for (Schema.Field field : schema.getFields()) {
            Assertions.assertEquals((Object)field.schema().getType().getName(), (Object)((String)hiveClient.getMetastoreSchema("test1").get(field.name())).toLowerCase(), (String)String.format("Hive Schema Field %s was added", field));
        }
        Assertions.assertEquals((Object)"string", (Object)((String)hiveClient.getMetastoreSchema("test1").get("datestr")).toLowerCase(), (String)"Hive Schema Field datestr was added");
        Assertions.assertEquals((int)(schema.getFields().size() + 1 + HoodieRecord.HOODIE_META_COLUMNS.size()), (int)hiveClient.getMetastoreSchema("test1").size(), (String)"Hive Schema fields size");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testPickingOlderParquetFileIfLatestIsEmptyCommit(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String commitTime = "100";
        HiveTestUtil.createCOWTable("100", 1, true);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        String emptyCommitTime = "200";
        HiveTestUtil.createCommitFileWithSchema(commitMetadata, "200", true);
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        this.verifyOldParquetFileTest(this.hiveClient, "200");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testNotPickingOlderParquetFileWhenLatestCommitReadFails(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String commitTime = "100";
        HiveTestUtil.createCOWTable("100", 1, true);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "101";
        HiveTestUtil.addCOWPartitions(1, false, true, dateTime, commitTime2);
        String emptyCommitTime = "200";
        HiveTestUtil.createCommitFile(commitMetadata, "200", HiveTestUtil.basePath);
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        HiveSyncTool tool = new HiveSyncTool((Properties)HiveTestUtil.hiveSyncProps, (Configuration)HiveTestUtil.getHiveConf());
        Path fullPath = new Path(HiveTestUtil.basePath + "/" + ".hoodie" + "/" + "timeline" + "/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(this.hiveClient.getActiveTimeline().getInstantsAsStream().filter(inst -> inst.requestedTime().equals(commitTime2)).findFirst().get()));
        Assertions.assertTrue((boolean)HiveTestUtil.fileSystem.delete(fullPath, false));
        try {
            tool.syncHoodieTable();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist at all");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testNotPickingOlderParquetFileWhenLatestCommitReadFailsForExistingTable(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        String commitTime = "100";
        HiveTestUtil.createCOWTable("100", 1, true);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        String emptyCommitTime = "200";
        HiveTestUtil.createCommitFileWithSchema(commitMetadata, "200", true);
        this.reInitHiveSyncClient();
        Assertions.assertFalse((boolean)this.hiveClient.tableExists("test1"), (String)"Table test1 should not exist initially");
        this.reSyncHiveTable();
        this.verifyOldParquetFileTest(this.hiveClient, "200");
        ZonedDateTime dateTime = ZonedDateTime.now().plusDays(6L);
        String commitTime2 = "301";
        HiveTestUtil.addCOWPartitions(1, false, true, dateTime, commitTime2);
        this.reInitHiveSyncClient();
        Path fullPath = new Path(HiveTestUtil.basePath + "/" + ".hoodie" + "/" + "timeline" + "/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(this.hiveClient.getActiveTimeline().getInstantsAsStream().filter(inst -> inst.requestedTime().equals(commitTime2)).findFirst().get()));
        Assertions.assertTrue((boolean)HiveTestUtil.fileSystem.delete(fullPath, false));
        try {
            this.reSyncHiveTable();
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            this.reInitHiveSyncClient();
        }
        this.verifyOldParquetFileTest(this.hiveClient, "200");
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testTypeConverter(String syncMode) throws Exception {
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.createCOWTable("100", 5, true);
        HiveTestUtil.ddlExecutor.runSQL("create database testdb");
        this.reInitHiveSyncClient();
        String tableName = "test1";
        String tableAbsoluteName = String.format(" `%s.%s` ", "testdb", tableName);
        String dropTableSql = String.format("DROP TABLE IF EXISTS %s ", tableAbsoluteName);
        String createTableSqlPrefix = String.format("CREATE TABLE IF NOT EXISTS %s ", tableAbsoluteName);
        String errorMsg = "An error occurred in decimal type converting.";
        HiveTestUtil.ddlExecutor.runSQL(dropTableSql);
        String oneTargetColumnSql = createTableSqlPrefix + "(`decimal_col` DECIMAL(9,8), `bigint_col` BIGINT)";
        HiveTestUtil.ddlExecutor.runSQL(oneTargetColumnSql);
        System.out.println(this.hiveClient.getMetastoreSchema(tableName));
        Assertions.assertTrue((boolean)this.hiveClient.getMetastoreSchema(tableName).containsValue("DECIMAL(9,8)"), (String)errorMsg);
        HiveTestUtil.ddlExecutor.runSQL(dropTableSql);
        String multipleTargetColumnSql = createTableSqlPrefix + "(`decimal_col1` DECIMAL(9,8), `bigint_col` BIGINT, `decimal_col2` DECIMAL(7,4))";
        HiveTestUtil.ddlExecutor.runSQL(multipleTargetColumnSql);
        System.out.println(this.hiveClient.getMetastoreSchema(tableName));
        Assertions.assertTrue((this.hiveClient.getMetastoreSchema(tableName).containsValue("DECIMAL(9,8)") && this.hiveClient.getMetastoreSchema(tableName).containsValue("DECIMAL(7,4)") ? 1 : 0) != 0, (String)errorMsg);
        HiveTestUtil.ddlExecutor.runSQL(dropTableSql);
        String noTargetColumnsSql = createTableSqlPrefix + "(`bigint_col` BIGINT)";
        HiveTestUtil.ddlExecutor.runSQL(noTargetColumnsSql);
        System.out.println(this.hiveClient.getMetastoreSchema(tableName));
        Assertions.assertTrue((this.hiveClient.getMetastoreSchema(tableName).size() == 1 && this.hiveClient.getMetastoreSchema(tableName).containsValue("BIGINT") ? 1 : 0) != 0, (String)errorMsg);
        HiveTestUtil.ddlExecutor.runSQL(dropTableSql);
    }

    @ParameterizedTest
    @MethodSource(value={"syncMode"})
    public void testSyncWithoutDiffs(String syncMode) throws Exception {
        String tableName = "test1_rt";
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_CONDITIONAL_SYNC.key(), "true");
        String commitTime0 = "100";
        String commitTime1 = "101";
        String commitTime2 = "102";
        String commitTime3 = "103";
        String commitTime4 = "104";
        String commitTime5 = "105";
        HiveTestUtil.createMORTable(commitTime0, commitTime1, 2, true, true);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists(tableName));
        Assertions.assertEquals((Object)commitTime1, (Object)this.hiveClient.getLastCommitTimeSynced(tableName).get());
        HiveTestUtil.addMORPartitions(0, true, true, true, ZonedDateTime.now().plusDays(2L), commitTime2, commitTime3);
        this.reSyncHiveTable();
        Assertions.assertEquals((Object)commitTime1, (Object)this.hiveClient.getLastCommitTimeSynced(tableName).get());
        HiveTestUtil.addMORPartitions(0, true, true, true, ZonedDateTime.now().plusDays(2L), commitTime4, commitTime5);
        HiveTestUtil.removeCommitFromActiveTimeline(commitTime0, "commit");
        HiveTestUtil.removeCommitFromActiveTimeline(commitTime1, "deltacommit");
        HiveTestUtil.removeCommitFromActiveTimeline(commitTime2, "commit");
        HiveTestUtil.removeCommitFromActiveTimeline(commitTime3, "deltacommit");
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((Object)commitTime1, (Object)this.hiveClient.getLastCommitTimeSynced(tableName).get());
    }

    @ParameterizedTest
    @MethodSource(value={"syncModeAndEnablePushDown"})
    public void testHiveSyncWithMultiWriter(String syncMode, String enablePushDown) throws Exception {
        String tableName = "test1_rt";
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), syncMode);
        HiveTestUtil.hiveSyncProps.setProperty(HiveSyncConfig.HIVE_SYNC_FILTER_PUSHDOWN_ENABLED.key(), enablePushDown);
        HiveTestUtil.hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_CONDITIONAL_SYNC.key(), "true");
        String commitTime1 = InProcessTimeGenerator.createNewInstantTime((long)1L);
        String commitTime2 = InProcessTimeGenerator.createNewInstantTime((long)2L);
        String commitTime3 = InProcessTimeGenerator.createNewInstantTime((long)3L);
        String commitTime4 = InProcessTimeGenerator.createNewInstantTime((long)4L);
        String commitTime5 = InProcessTimeGenerator.createNewInstantTime((long)5L);
        HiveTestUtil.createMORTable(commitTime4, commitTime5, 2, true, true);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertTrue((boolean)this.hiveClient.tableExists(tableName));
        Assertions.assertEquals((Object)commitTime5, (Object)this.hiveClient.getLastCommitTimeSynced(tableName).get());
        Assertions.assertEquals((Object)this.getLastCommitCompletionTimeSynced(), (Object)this.hiveClient.getLastCommitCompletionTimeSynced(tableName).get());
        Assertions.assertEquals((int)2, (int)this.hiveClient.getAllPartitions(tableName).size());
        HiveTestUtil.addMORPartitions(4, true, true, true, ZonedDateTime.now().plusDays(2L), commitTime2, commitTime3);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        String lastCommitCompletionTimeSynced = this.getLastCommitCompletionTimeSynced();
        Assertions.assertEquals((Object)commitTime5, (Object)this.hiveClient.getLastCommitTimeSynced(tableName).get());
        Assertions.assertEquals((Object)lastCommitCompletionTimeSynced, (Object)this.hiveClient.getLastCommitCompletionTimeSynced(tableName).get());
        Assertions.assertEquals((int)4, (int)this.hiveClient.getAllPartitions(tableName).size());
        List partitions = this.hiveClient.getAllPartitions(tableName);
        String partitiontoDelete = ((String)((Partition)partitions.get(0)).getValues().get(0)).replace("-", "/");
        HiveTestUtil.createReplaceCommit(commitTime1, partitiontoDelete, WriteOperationType.DELETE_PARTITION, true, true);
        this.reInitHiveSyncClient();
        this.reSyncHiveTable();
        Assertions.assertEquals((Object)this.getLastCommitCompletionTimeSynced(), (Object)this.hiveClient.getLastCommitCompletionTimeSynced(tableName).get());
        Assertions.assertEquals((Object)commitTime5, (Object)this.hiveClient.getLastCommitTimeSynced(tableName).get());
        Assertions.assertEquals((int)3, (int)this.hiveClient.getAllPartitions(tableName).size());
    }

    private void reSyncHiveTable() {
        this.hiveSyncTool.syncHoodieTable();
        this.reInitHiveSyncClient();
    }

    private String getLastCommitCompletionTimeSynced() {
        return (String)this.hiveClient.getActiveTimeline().getLatestCompletionTime().get();
    }

    private void reInitHiveSyncClient() {
        this.hiveSyncTool = new HiveSyncTool((Properties)HiveTestUtil.hiveSyncProps, (Configuration)HiveTestUtil.getHiveConf());
        this.hiveClient = (HoodieHiveSyncClient)this.hiveSyncTool.syncClient;
    }

    private int getPartitionFieldSize() {
        return HiveTestUtil.hiveSyncProps.getString(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key()).split(",").length;
    }

    private static /* synthetic */ boolean lambda$testBasicSync$3(PartitionEvent e) {
        return e.eventType == PartitionEvent.PartitionEventType.DROP;
    }

    private static /* synthetic */ boolean lambda$testBasicSync$2(PartitionEvent e) {
        return e.eventType == PartitionEvent.PartitionEventType.UPDATE;
    }

    private static /* synthetic */ boolean lambda$testBasicSync$1(PartitionEvent e) {
        return e.eventType == PartitionEvent.PartitionEventType.ADD;
    }
}

